/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver.cave;

import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseColumn;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseGen;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseTuple;
import com.yungnickyoung.minecraft.bettercaves.util.BetterCavesUtils;
import com.yungnickyoung.minecraft.bettercaves.util.ColPos;
import com.yungnickyoung.minecraft.bettercaves.world.carver.CarverSettings;
import com.yungnickyoung.minecraft.bettercaves.world.carver.CarverUtils;
import com.yungnickyoung.minecraft.bettercaves.world.carver.ICarver;
import com.yungnickyoung.minecraft.bettercaves.world.carver.cave.CaveCarverBuilder;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.IChunk;

public class CaveCarver
implements ICarver {
    private CarverSettings settings;
    private NoiseGen noiseGen;
    private int surfaceCutoff;
    private int bottomY;
    private int topY;
    private boolean enableYAdjust;
    private float yAdjustF1;
    private float yAdjustF2;

    public CaveCarver(CaveCarverBuilder builder) {
        this.settings = builder.getSettings();
        this.noiseGen = new NoiseGen(this.settings.getSeed(), this.settings.isFastNoise(), this.settings.getNoiseSettings(), this.settings.getNumGens(), this.settings.getyCompression(), this.settings.getXzCompression());
        this.surfaceCutoff = builder.getSurfaceCutoff();
        this.bottomY = builder.getBottomY();
        this.topY = builder.getTopY();
        this.enableYAdjust = builder.isEnableYAdjust();
        this.yAdjustF1 = builder.getyAdjustF1();
        this.yAdjustF2 = builder.getyAdjustF2();
        if (this.bottomY > this.topY) {
            BetterCaves.LOGGER.warn("Warning: Min altitude for caves should not be greater than max altitude.");
            BetterCaves.LOGGER.warn("Using default values...");
            this.bottomY = 1;
            this.topY = 80;
        }
    }

    public void carveColumn(IChunk chunk, ColPos colPos, int topY, NoiseColumn noises, BlockState liquidBlock, boolean flooded, BitSet carvingMask) {
        int localX = BetterCavesUtils.getLocal(colPos.getX());
        int localZ = BetterCavesUtils.getLocal(colPos.getZ());
        if (localX < 0 || localX > 15) {
            return;
        }
        if (localZ < 0 || localZ > 15) {
            return;
        }
        if (this.bottomY < 0 || this.bottomY > 255) {
            return;
        }
        if (topY < 0 || topY > 255) {
            return;
        }
        int transitionBoundary = topY - this.surfaceCutoff;
        if (transitionBoundary < 1) {
            transitionBoundary = 1;
        }
        Map<Integer, Float> thresholds = this.generateThresholds(topY, this.bottomY, transitionBoundary);
        if (this.enableYAdjust) {
            this.preprocessCaveNoiseCol(noises, topY, this.bottomY, thresholds, this.settings.getNumGens());
        }
        for (int y = topY; y >= this.bottomY && (y > this.settings.getLiquidAltitude() || liquidBlock != null); --y) {
            List<Double> noiseBlock = noises.get(y).getNoiseValues();
            boolean digBlock = true;
            for (double noise : noiseBlock) {
                if (!(noise < (double)thresholds.get(y).floatValue())) continue;
                digBlock = false;
                break;
            }
            BlockPos blockPos = new BlockPos(localX, y, localZ);
            if (this.settings.isEnableDebugVisualizer()) {
                CarverUtils.debugCarveBlock(chunk, blockPos, this.settings.getDebugBlock(), digBlock);
                continue;
            }
            if (!digBlock) continue;
            if (flooded) {
                CarverUtils.carveFloodedBlock(chunk, new Random(), new BlockPos.Mutable(blockPos), liquidBlock, this.settings.getLiquidAltitude(), this.settings.isReplaceFloatingGravel(), carvingMask);
                continue;
            }
            CarverUtils.carveBlock(chunk, blockPos, liquidBlock, this.settings.getLiquidAltitude(), this.settings.isReplaceFloatingGravel(), carvingMask);
        }
    }

    private void preprocessCaveNoiseCol(NoiseColumn noises, int topY, int bottomY, Map<Integer, Float> thresholds, int numGens) {
        for (int realY = topY; realY >= bottomY; --realY) {
            int i;
            NoiseTuple noiseBlock = noises.get(realY);
            float threshold = thresholds.get(realY).floatValue();
            boolean valid = true;
            for (double noise : noiseBlock.getNoiseValues()) {
                if (!(noise < (double)threshold)) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            float f1 = this.yAdjustF1;
            float f2 = this.yAdjustF2;
            if (realY < topY) {
                NoiseTuple tupleAbove = noises.get(realY + 1);
                for (i = 0; i < numGens; ++i) {
                    tupleAbove.set(i, (double)(1.0f - f1) * tupleAbove.get(i) + (double)f1 * noiseBlock.get(i));
                }
            }
            if (realY >= topY - 1) continue;
            NoiseTuple tupleTwoAbove = noises.get(realY + 2);
            for (i = 0; i < numGens; ++i) {
                tupleTwoAbove.set(i, (double)(1.0f - f2) * tupleTwoAbove.get(i) + (double)f2 * noiseBlock.get(i));
            }
        }
    }

    private Map<Integer, Float> generateThresholds(int topY, int bottomY, int transitionBoundary) {
        HashMap<Integer, Float> thresholds = new HashMap<Integer, Float>();
        for (int realY = bottomY; realY <= topY; ++realY) {
            float noiseThreshold = this.settings.getNoiseThreshold();
            if (realY >= transitionBoundary) {
                noiseThreshold *= 1.0f + 0.3f * ((float)(realY - transitionBoundary) / (float)(topY - transitionBoundary));
            }
            thresholds.put(realY, Float.valueOf(noiseThreshold));
        }
        return thresholds;
    }

    public NoiseGen getNoiseGen() {
        return this.noiseGen;
    }

    public CarverSettings getSettings() {
        return this.settings;
    }

    @Override
    public int getPriority() {
        return this.settings.getPriority();
    }

    public int getBottomY() {
        return this.bottomY;
    }

    @Override
    public int getTopY() {
        return this.topY;
    }
}

