/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver.controller;

import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.config.util.ConfigHolder;
import com.yungnickyoung.minecraft.bettercaves.enums.CavernType;
import com.yungnickyoung.minecraft.bettercaves.noise.FastNoise;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseColumn;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseUtils;
import com.yungnickyoung.minecraft.bettercaves.util.BetterCavesUtils;
import com.yungnickyoung.minecraft.bettercaves.util.ColPos;
import com.yungnickyoung.minecraft.bettercaves.world.carver.CarverNoiseRange;
import com.yungnickyoung.minecraft.bettercaves.world.carver.cavern.CavernCarver;
import com.yungnickyoung.minecraft.bettercaves.world.carver.cavern.CavernCarverBuilder;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;

public class CavernCarverController {
    private IWorld world;
    private FastNoise cavernRegionController;
    private List<CarverNoiseRange> noiseRanges = new ArrayList<CarverNoiseRange>();
    private boolean isDebugViewEnabled;
    private boolean isOverrideSurfaceDetectionEnabled;
    private boolean isFloodedUndergroundEnabled;

    public CavernCarverController(IWorld worldIn, ConfigHolder config) {
        this.world = worldIn;
        this.isDebugViewEnabled = config.debugVisualizer.get();
        this.isOverrideSurfaceDetectionEnabled = config.overrideSurfaceDetection.get();
        this.isFloodedUndergroundEnabled = config.enableFloodedUnderground.get();
        float cavernRegionSize = this.calcCavernRegionSize(config.cavernRegionSize.get(), config.cavernRegionCustomSize.get().floatValue());
        this.cavernRegionController = new FastNoise();
        this.cavernRegionController.SetSeed((int)this.world.func_72905_C() + 333);
        this.cavernRegionController.SetFrequency(cavernRegionSize);
        ArrayList<CavernCarver> carvers = new ArrayList<CavernCarver>();
        carvers.add(new CavernCarverBuilder(this.world.func_72905_C()).ofTypeFromConfig(CavernType.LIQUID, config).debugVisualizerBlock(Blocks.field_150451_bX.func_176223_P()).build());
        carvers.add(new CavernCarverBuilder(this.world.func_72905_C()).ofTypeFromConfig(CavernType.FLOORED, config).debugVisualizerBlock(Blocks.field_150340_R.func_176223_P()).build());
        float spawnChance = config.cavernSpawnChance.get().floatValue() / 100.0f;
        int totalPriority = carvers.stream().map(CavernCarver::getPriority).reduce(0, Integer::sum);
        BetterCaves.LOGGER.debug("CAVERN INFORMATION");
        BetterCaves.LOGGER.debug("--> SPAWN CHANCE SET TO: " + spawnChance);
        BetterCaves.LOGGER.debug("--> TOTAL PRIORITY: " + totalPriority);
        carvers.removeIf(carver -> carver.getPriority() == 0);
        float totalDeadzonePercent = 1.0f - spawnChance;
        float deadzonePercent = carvers.size() > 1 ? totalDeadzonePercent / (float)(carvers.size() - 1) : totalDeadzonePercent;
        BetterCaves.LOGGER.debug("--> DEADZONE PERCENT: " + deadzonePercent + "(" + totalDeadzonePercent + " TOTAL)");
        float currNoise = -1.0f;
        for (CavernCarver carver2 : carvers) {
            BetterCaves.LOGGER.debug("--> CARVER");
            float rangeCDFPercent = (float)carver2.getPriority() / (float)totalPriority * spawnChance;
            float topNoise = NoiseUtils.simplexNoiseOffsetByPercent(currNoise, rangeCDFPercent);
            CarverNoiseRange range = new CarverNoiseRange(currNoise, topNoise, carver2);
            this.noiseRanges.add(range);
            currNoise = NoiseUtils.simplexNoiseOffsetByPercent(topNoise, deadzonePercent);
            BetterCaves.LOGGER.debug("    --> RANGE PERCENT LENGTH WANTED: " + rangeCDFPercent);
            BetterCaves.LOGGER.debug("    --> RANGE FOUND: " + range);
        }
    }

    public void carveChunk(IChunk chunk, int chunkX, int chunkZ, int[][] surfaceAltitudes, BlockState[][] liquidBlocks, Map<Long, Biome> biomeMap, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        if (this.noiseRanges.size() == 0) {
            return;
        }
        boolean flooded = false;
        float smoothAmpFloodFactor = 1.0f;
        for (int subX = 0; subX < 4; ++subX) {
            for (int subZ = 0; subZ < 4; ++subZ) {
                int startX = subX * 4;
                int startZ = subZ * 4;
                int endX = startX + 4 - 1;
                int endZ = startZ + 4 - 1;
                BlockPos startPos = new BlockPos(chunkX * 16 + startX, 1, chunkZ * 16 + startZ);
                BlockPos endPos = new BlockPos(chunkX * 16 + endX, 1, chunkZ * 16 + endZ);
                this.noiseRanges.forEach(range -> range.setNoiseCube(null));
                int maxHeight = 0;
                if (!this.isOverrideSurfaceDetectionEnabled) {
                    for (int x = startX; x < endX; ++x) {
                        for (int z = startZ; z < endZ; ++z) {
                            maxHeight = Math.max(maxHeight, surfaceAltitudes[x][z]);
                        }
                    }
                    for (CarverNoiseRange range2 : this.noiseRanges) {
                        CavernCarver carver = (CavernCarver)range2.getCarver();
                        maxHeight = Math.max(maxHeight, carver.getTopY());
                    }
                }
                for (int offsetX = 0; offsetX < 4; ++offsetX) {
                    block6: for (int offsetZ = 0; offsetZ < 4; ++offsetZ) {
                        int localX = startX + offsetX;
                        int localZ = startZ + offsetZ;
                        ColPos colPos = new ColPos(chunkX * 16 + localX, chunkZ * 16 + localZ);
                        if (this.isFloodedUndergroundEnabled && !this.isDebugViewEnabled && (double)(smoothAmpFloodFactor = BetterCavesUtils.getDistFactor(this.world, biomeMap, colPos, 2, (flooded = biomeMap.get(colPos.toLong()).func_201856_r() == Biome.Category.OCEAN) ? BetterCavesUtils.isNotOcean : BetterCavesUtils.isOcean)) <= 0.25) continue;
                        int surfaceAltitude = surfaceAltitudes[localX][localZ];
                        BlockState liquidBlock = liquidBlocks[localX][localZ];
                        float cavernRegionNoise = this.cavernRegionController.GetNoise(colPos.getX(), colPos.getZ());
                        for (CarverNoiseRange range3 : this.noiseRanges) {
                            int topY;
                            if (!range3.contains(cavernRegionNoise)) continue;
                            CavernCarver carver = (CavernCarver)range3.getCarver();
                            int bottomY = carver.getBottomY();
                            int n = topY = this.isDebugViewEnabled ? carver.getTopY() : Math.min(surfaceAltitude, carver.getTopY());
                            if (this.isOverrideSurfaceDetectionEnabled) {
                                topY = carver.getTopY();
                                maxHeight = carver.getTopY();
                            }
                            float smoothAmp = range3.getSmoothAmp(cavernRegionNoise) * smoothAmpFloodFactor;
                            if (range3.getNoiseCube() == null) {
                                range3.setNoiseCube(carver.getNoiseGen().interpolateNoiseCube(startPos, endPos, bottomY, maxHeight));
                            }
                            NoiseColumn noiseColumn = range3.getNoiseCube().get(offsetX).get(offsetZ);
                            carver.carveColumn(chunk, colPos, topY, smoothAmp, noiseColumn, liquidBlock, flooded, flooded ? liquidCarvingMask : airCarvingMask);
                            continue block6;
                        }
                    }
                }
            }
        }
    }

    private float calcCavernRegionSize(String cavernRegionSize, float cavernRegionCustomSize) {
        switch (cavernRegionSize) {
            case "Small": {
                return 0.01f;
            }
            case "Large": {
                return 0.005f;
            }
            case "ExtraLarge": {
                return 0.001f;
            }
            case "Custom": {
                return cavernRegionCustomSize;
            }
        }
        return 0.007f;
    }

    public void setWorld(IWorld worldIn) {
        this.world = worldIn;
    }
}

