/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver.controller;

import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.config.util.ConfigHolder;
import com.yungnickyoung.minecraft.bettercaves.noise.FastNoise;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseUtils;
import com.yungnickyoung.minecraft.bettercaves.util.BetterCavesUtils;
import com.yungnickyoung.minecraft.bettercaves.util.ColPos;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.registries.ForgeRegistries;

public class WaterRegionController {
    private FastNoise waterRegionController;
    private IWorld world;
    private int dimensionId;
    private String dimensionName;
    private Random rand;
    private BlockState lavaBlock;
    private BlockState waterBlock;
    private float waterRegionThreshold;
    private static final float SMOOTH_RANGE = 0.04f;
    private static final float SMOOTH_DELTA = 0.01f;

    public WaterRegionController(IWorld worldIn, ConfigHolder config) {
        this.world = worldIn;
        this.dimensionId = worldIn.func_201675_m().func_186058_p().func_186068_a();
        this.dimensionName = DimensionType.func_212678_a((DimensionType)worldIn.func_201675_m().func_186058_p()).toString();
        this.rand = new Random();
        this.lavaBlock = this.getLavaBlockFromString(config.lavaBlock.get());
        this.waterBlock = this.getWaterBlockFromString(config.waterBlock.get());
        this.waterRegionThreshold = NoiseUtils.simplexNoiseOffsetByPercent(-1.0f, config.waterRegionSpawnChance.get().floatValue() / 100.0f);
        float waterRegionSize = config.cavernRegionSize.get().equals("ExtraLarge") ? 0.001f : 0.004f;
        this.waterRegionController = new FastNoise();
        this.waterRegionController.SetSeed((int)this.world.func_72905_C() + 444);
        this.waterRegionController.SetFrequency(waterRegionSize);
    }

    public BlockState[][] getLiquidBlocksForChunk(int chunkX, int chunkZ) {
        this.rand.setSeed(this.world.func_72905_C() ^ (long)chunkX ^ (long)chunkZ);
        BlockState[][] blocks = new BlockState[16][16];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int realX = chunkX * 16 + x;
                int realZ = chunkZ * 16 + z;
                ColPos pos = new ColPos(realX, realZ);
                blocks[x][z] = this.getLiquidBlockAtPos(this.rand, pos);
            }
        }
        return blocks;
    }

    private BlockState getLiquidBlockAtPos(Random rand, ColPos colPos) {
        BlockState liquidBlock = this.lavaBlock;
        if (this.waterRegionThreshold > -1.0f) {
            float randOffset;
            float waterRegionNoise = this.waterRegionController.GetNoise(colPos.getX(), colPos.getZ());
            if (waterRegionNoise < this.waterRegionThreshold - (randOffset = rand.nextFloat() * 0.01f + 0.04f)) {
                liquidBlock = this.waterBlock;
            } else if (waterRegionNoise < this.waterRegionThreshold + randOffset) {
                liquidBlock = null;
            }
        }
        return liquidBlock;
    }

    private BlockState getLavaBlockFromString(String lavaString) {
        BlockState lavaBlock;
        try {
            lavaBlock = ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(lavaString))).func_176223_P();
            BetterCaves.LOGGER.info("Using block '" + lavaString + "' as lava in cave generation for dimension " + BetterCavesUtils.dimensionAsString(this.dimensionId, this.dimensionName) + " ...");
        }
        catch (Exception e) {
            BetterCaves.LOGGER.warn("Unable to use block '" + lavaString + "': " + e);
            BetterCaves.LOGGER.warn("Using vanilla lava instead...");
            lavaBlock = Blocks.field_150353_l.func_176223_P();
        }
        if (lavaBlock == null || lavaBlock == Blocks.field_150350_a.func_176223_P() && !lavaString.equals("minecraft:air")) {
            BetterCaves.LOGGER.warn("Unable to use block '" + lavaString + "': null block returned.\n Using vanilla lava instead...");
            lavaBlock = Blocks.field_150353_l.func_176223_P();
        }
        return lavaBlock;
    }

    private BlockState getWaterBlockFromString(String waterString) {
        BlockState waterBlock;
        try {
            waterBlock = ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(waterString))).func_176223_P();
            BetterCaves.LOGGER.info("Using block '" + waterString + "' as water in cave generation for dimension " + BetterCavesUtils.dimensionAsString(this.dimensionId, this.dimensionName) + " ...");
        }
        catch (Exception e) {
            BetterCaves.LOGGER.warn("Unable to use block '" + waterString + "': " + e);
            BetterCaves.LOGGER.warn("Using vanilla water instead...");
            waterBlock = Blocks.field_150355_j.func_176223_P();
        }
        if (waterBlock == null || waterBlock == Blocks.field_150350_a.func_176223_P() && !waterString.equals("minecraft:air")) {
            BetterCaves.LOGGER.warn("Unable to use block '" + waterString + "': null block returned.\n Using vanilla water instead...");
            waterBlock = Blocks.field_150355_j.func_176223_P();
        }
        return waterBlock;
    }

    public void setWorld(IWorld worldIn) {
        this.world = worldIn;
    }
}

