/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.feature;

import com.mojang.datafixers.Dynamic;
import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.config.Configuration;
import com.yungnickyoung.minecraft.bettercaves.world.carver.BetterCavesCarver;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class CarverFeature
extends Feature<NoFeatureConfig> {
    public CarverFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    @ParametersAreNonnullByDefault
    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos position, NoFeatureConfig config) {
        String dimensionName = null;
        try {
            dimensionName = Objects.requireNonNull(DimensionType.func_212678_a((DimensionType)world.func_201675_m().func_186058_p())).toString();
        }
        catch (NullPointerException ignored) {
            BetterCaves.LOGGER.error("ERROR: Unable to get dimension name! Using default cave gen...");
        }
        IChunk chunk = world.func_217349_x(position);
        ChunkPos chunkPos = chunk.func_76632_l();
        int xChunkPos = chunkPos.field_77276_a;
        int zChunkPos = chunkPos.field_77275_b;
        Biome biome = chunk.func_225549_i_().func_225526_b_(position.func_177958_n(), 1, position.func_177952_p());
        BiomeManager biomeManager = world.func_225523_d_().func_226835_a_(generator.func_202090_b());
        Function<BlockPos, Biome> gb = blockPos -> generator.func_225552_a_(biomeManager, blockPos);
        if (dimensionName == null || !this.isDimensionWhitelisted(dimensionName)) {
            SharedSeedRandom sharedSeedRandom = new SharedSeedRandom();
            BitSet airBitset = chunk.func_205749_a(GenerationStage.Carving.AIR);
            BitSet liquidBitset = chunk.func_205749_a(GenerationStage.Carving.LIQUID);
            List<ConfiguredCarver<?>> defaultAirCarvers = BetterCaves.defaultBiomeAirCarvers.get(biome.getClass());
            List<ConfiguredCarver<?>> defaultLiquidCarvers = BetterCaves.defaultBiomeLiquidCarvers.get(biome.getClass());
            for (int currChunkX = xChunkPos - 8; currChunkX <= xChunkPos + 8; ++currChunkX) {
                for (int currChunkZ = zChunkPos - 8; currChunkZ <= zChunkPos + 8; ++currChunkZ) {
                    ConfiguredCarver<?> carver;
                    int i;
                    for (i = 0; i < defaultAirCarvers.size(); ++i) {
                        sharedSeedRandom.func_202425_c(world.func_72905_C() + (long)i, currChunkX, currChunkZ);
                        carver = defaultAirCarvers.get(i);
                        if (!carver.func_222730_a((Random)sharedSeedRandom, currChunkX, currChunkZ)) continue;
                        carver.func_227207_a_(chunk, gb, (Random)sharedSeedRandom, world.func_181545_F(), currChunkX, currChunkZ, xChunkPos, zChunkPos, airBitset);
                    }
                    for (i = 0; i < defaultLiquidCarvers.size(); ++i) {
                        sharedSeedRandom.func_202425_c(world.func_72905_C() + (long)i, currChunkX, currChunkZ);
                        carver = defaultLiquidCarvers.get(i);
                        if (!carver.func_222730_a((Random)sharedSeedRandom, currChunkX, currChunkZ)) continue;
                        carver.func_227207_a_(chunk, gb, (Random)sharedSeedRandom, world.func_181545_F(), currChunkX, currChunkZ, xChunkPos, zChunkPos, liquidBitset);
                    }
                }
            }
            return true;
        }
        if (BetterCaves.activeCarversMap.get(dimensionName) == null || BetterCaves.activeCarversMap.get(dimensionName).getSeed() != world.func_72905_C()) {
            BetterCavesCarver newCarver = new BetterCavesCarver();
            BetterCaves.activeCarversMap.put(dimensionName, newCarver);
            BetterCaves.LOGGER.info(String.format("CREATING AND INIT'ING CARVER W DIMENSION %s...", dimensionName));
            newCarver.initialize(world);
        }
        BetterCavesCarver carver = BetterCaves.activeCarversMap.get(dimensionName);
        carver.setWorld(world);
        carver.carve(chunk, xChunkPos, zChunkPos);
        return true;
    }

    private boolean isDimensionWhitelisted(String dimensionName) {
        return (Boolean)Configuration.enableGlobalWhitelist.get() != false || BetterCaves.whitelistedDimensions.contains(dimensionName);
    }
}

