/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.server;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.server.entity.EntityDataCapabilityImplementation;
import com.github.alexthe666.citadel.server.entity.EntityDataHandler;
import com.github.alexthe666.citadel.server.entity.EntityProperties;
import com.github.alexthe666.citadel.server.entity.EntityPropertiesHandler;
import com.github.alexthe666.citadel.server.entity.IEntityData;
import com.github.alexthe666.citadel.server.entity.PropertiesTracker;
import com.github.alexthe666.citadel.server.message.PropertiesMessage;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CitadelServerEvents {
    private int updateTimer;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAttachCapabilities(final AttachCapabilitiesEvent<Entity> event) {
        event.addCapability(new ResourceLocation("citadel", "extended_entity_data_citadel"), (ICapabilityProvider)new ICapabilitySerializable(){
            private final LazyOptional<IEntityData> holder = LazyOptional.of(() -> new EntityDataCapabilityImplementation());

            public INBT serializeNBT() {
                Capability<IEntityData> capability = Citadel.ENTITY_DATA_CAPABILITY;
                IEntityData instance = (IEntityData)capability.getDefaultInstance();
                instance.init((Entity)event.getObject(), ((Entity)event.getObject()).func_130014_f_(), false);
                return capability.getStorage().writeNBT(capability, (Object)instance, null);
            }

            public void deserializeNBT(INBT nbt) {
                Capability<IEntityData> capability = Citadel.ENTITY_DATA_CAPABILITY;
                IEntityData instance = (IEntityData)capability.getDefaultInstance();
                instance.init((Entity)event.getObject(), ((Entity)event.getObject()).func_130014_f_(), true);
                capability.getStorage().readNBT(capability, (Object)instance, null, nbt);
            }

            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
                if (capability == Citadel.ENTITY_DATA_CAPABILITY) {
                    return Citadel.ENTITY_DATA_CAPABILITY.orEmpty(capability, this.holder).cast();
                }
                return LazyOptional.empty();
            }
        });
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        boolean cached = EntityPropertiesHandler.INSTANCE.hasEntityInCache(event.getEntity().getClass());
        ArrayList<String> entityPropertiesIDCache = !cached ? new ArrayList<String>() : null;
        EntityPropertiesHandler.INSTANCE.getRegisteredProperties().filter(propEntry -> ((Class)propEntry.getKey()).isAssignableFrom(event.getEntity().getClass())).forEach(propEntry -> {
            for (Class propClass : (List)propEntry.getValue()) {
                try {
                    Constructor constructor = propClass.getConstructor(new Class[0]);
                    EntityProperties prop = (EntityProperties)constructor.newInstance(new Object[0]);
                    String propID = prop.getID();
                    EntityDataHandler.INSTANCE.registerExtendedEntityData(event.getEntity(), prop);
                    if (cached) continue;
                    entityPropertiesIDCache.add(propID);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        if (!cached) {
            EntityPropertiesHandler.INSTANCE.addEntityToCache(event.getEntity().getClass(), entityPropertiesIDCache);
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K || !(event.getEntity() instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
        List<PropertiesTracker<?>> trackers = EntityPropertiesHandler.INSTANCE.getEntityTrackers(player);
        if (trackers != null && trackers.size() > 0) {
            PropertiesTracker<?> tracker2;
            boolean hasPlayer = false;
            Iterator<PropertiesTracker<?>> iterator = trackers.iterator();
            while (iterator.hasNext() && !(hasPlayer = (tracker2 = iterator.next()).getEntity() == player)) {
            }
            if (!hasPlayer) {
                EntityPropertiesHandler.INSTANCE.addTracker(player, player);
            }
            for (PropertiesTracker<?> tracker2 : trackers) {
                tracker2.updateTracker();
                if (!tracker2.isTrackerReady()) continue;
                tracker2.onSync();
                PropertiesMessage message = new PropertiesMessage(tracker2.getProperties(), (Entity)tracker2.getEntity());
                Citadel.sendNonLocal(message, player);
            }
        }
    }

    @SubscribeEvent
    public void onEntityUpdateDebug(LivingEvent.LivingUpdateEvent event) {
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            EntityPropertiesHandler.INSTANCE.addTracker(player, player);
        }
    }

    @SubscribeEvent
    public void onEntityStartTracking(PlayerEvent.StartTracking event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            EntityPropertiesHandler.INSTANCE.addTracker((ServerPlayerEntity)event.getPlayer(), event.getTarget());
        }
    }

    @SubscribeEvent
    public void onEntityStopTracking(PlayerEvent.StopTracking event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            EntityPropertiesHandler.INSTANCE.removeTracker((ServerPlayerEntity)event.getPlayer(), event.getTarget());
        }
    }

    @SubscribeEvent
    public void onServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++this.updateTimer;
            if (this.updateTimer > 20) {
                this.updateTimer = 0;
                Iterator<Map.Entry<ServerPlayerEntity, List<PropertiesTracker<?>>>> iterator = EntityPropertiesHandler.INSTANCE.getTrackerIterator();
                while (iterator.hasNext()) {
                    Map.Entry<ServerPlayerEntity, List<PropertiesTracker<?>>> trackerEntry = iterator.next();
                    ServerPlayerEntity player = trackerEntry.getKey();
                    ServerWorld playerWorld = player.field_70170_p.func_73046_m().func_71218_a(player.field_71093_bK);
                    if (player == null || player.field_70128_L || playerWorld == null || !playerWorld.getEntities().collect(Collectors.toList()).contains(player)) {
                        iterator.remove();
                        trackerEntry.getValue().forEach(PropertiesTracker::removeTracker);
                        continue;
                    }
                    Iterator<PropertiesTracker<?>> it = trackerEntry.getValue().iterator();
                    while (it.hasNext()) {
                        PropertiesTracker<?> tracker = it.next();
                        Object entity = tracker.getEntity();
                        ServerWorld entityWorld = ((Entity)entity).field_70170_p.func_73046_m().func_71218_a(player.field_71093_bK);
                        if (entity != null && !((Entity)entity).field_70128_L && entityWorld != null && playerWorld.getEntities().collect(Collectors.toList()).contains(entity)) continue;
                        it.remove();
                        tracker.removeTracker();
                    }
                }
            }
        }
    }
}

