/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.controls;

import com.ldtteam.blockout.Log;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneParams;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;

public class Image
extends Pane {
    public static final int MINECRAFT_DEFAULT_TEXTURE_MAP_SIZE = 256;
    protected ResourceLocation resourceLocation;
    protected int imageOffsetX = 0;
    protected int imageOffsetY = 0;
    protected int imageWidth = 0;
    protected int imageHeight = 0;
    protected int mapWidth = 256;
    protected int mapHeight = 256;
    protected boolean customSized = true;
    protected boolean autoscale = true;

    public Image() {
    }

    public Image(PaneParams params) {
        super(params);
        PaneParams.SizePair size;
        String source = params.getStringAttribute("source", null);
        if (source != null) {
            this.resourceLocation = new ResourceLocation(source);
            this.loadMapDimensions();
        }
        if ((size = params.getSizePairAttribute("imageoffset", null, null)) != null) {
            this.imageOffsetX = size.getX();
            this.imageOffsetY = size.getY();
        }
        if ((size = params.getSizePairAttribute("imagesize", null, null)) != null) {
            this.imageWidth = size.getX();
            this.imageHeight = size.getY();
        }
        this.autoscale = params.getBooleanAttribute("autoscale", true);
    }

    private void loadMapDimensions() {
        Tuple<Integer, Integer> dimensions = Image.getImageDimensions(this.resourceLocation);
        this.mapWidth = (Integer)dimensions.func_76341_a();
        this.mapHeight = (Integer)dimensions.func_76340_b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tuple<Integer, Integer> getImageDimensions(ResourceLocation resourceLocation) {
        int width = 0;
        int height = 0;
        Iterator<ImageReader> it = ImageIO.getImageReadersBySuffix("png");
        if (it.hasNext()) {
            ImageReader reader = it.next();
            try (ImageInputStream stream = ImageIO.createImageInputStream(Minecraft.func_71410_x().func_195551_G().func_199002_a(resourceLocation).func_199027_b());){
                reader.setInput(stream);
                width = reader.getWidth(reader.getMinIndex());
                height = reader.getHeight(reader.getMinIndex());
            }
            catch (IOException e) {
                Log.getLogger().warn((Object)e);
            }
            finally {
                reader.dispose();
            }
        }
        return new Tuple((Object)width, (Object)height);
    }

    public void setImage(String source) {
        this.setImage(source, 0, 0, 0, 0);
    }

    public void setImage(String source, int offsetX, int offsetY, int w, int h) {
        this.setImage(source != null ? new ResourceLocation(source) : null, offsetX, offsetY, w, h);
    }

    public void setImage(ResourceLocation loc, int offsetX, int offsetY, int w, int h) {
        this.resourceLocation = loc;
        this.imageOffsetX = offsetX;
        this.imageOffsetY = offsetY;
        this.imageWidth = w;
        this.imageHeight = h;
        this.loadMapDimensions();
    }

    public void setImage(ResourceLocation loc, int offsetX, int offsetY, int w, int h, boolean customSized) {
        this.customSized = customSized;
        this.resourceLocation = loc;
        this.imageOffsetX = offsetX;
        this.imageOffsetY = offsetY;
        this.imageWidth = w;
        this.imageHeight = h;
        this.loadMapDimensions();
    }

    public void setImage(ResourceLocation loc) {
        this.setImage(loc, 0, 0, 0, 0);
    }

    @Override
    public void drawSelf(int mx, int my) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.setupOpenGL(this.resourceLocation);
        if (this.customSized) {
            Image.drawScaledCustomSizeModalRect(this.x, this.y, this.imageOffsetX, this.imageOffsetY, this.mapWidth, this.mapHeight, this.imageWidth != 0 ? this.imageWidth : this.getWidth(), this.imageHeight != 0 ? this.imageHeight : this.getHeight(), this.mapWidth, this.mapHeight);
        } else {
            this.blit(this.x, this.y, this.imageOffsetX, this.imageOffsetY, this.imageWidth != 0 ? this.imageWidth : this.getWidth(), this.imageHeight != 0 ? this.imageHeight : this.getHeight());
        }
        RenderSystem.disableBlend();
    }

    @Override
    public void drawSelfLast(int mx, int my) {
    }

    public static void drawScaledCustomSizeModalRect(int x, int y, float u, float v, int uWidth, int vHeight, int width, int height, float tileWidth, float tileHeight) {
        float f = 1.0f / tileWidth;
        float f1 = 1.0f / tileHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_((double)x, (double)(y + height), 0.0).func_225583_a_(u * f, (v + (float)vHeight) * f1).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)(y + height), 0.0).func_225583_a_((u + (float)uWidth) * f, (v + (float)vHeight) * f1).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)y, 0.0).func_225583_a_((u + (float)uWidth) * f, v * f1).func_181675_d();
        bufferbuilder.func_225582_a_((double)x, (double)y, 0.0).func_225583_a_(u * f, v * f1).func_181675_d();
        tessellator.func_78381_a();
    }

    private void setupOpenGL(ResourceLocation texture) {
        this.mc.func_110434_K().func_110577_a(texture);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.blendFunc((int)770, (int)771);
    }
}

