/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.shaded.mariuszgromada.math.mxparser;

import com.ldtteam.shaded.mariuszgromada.math.mxparser.Argument;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.ArgumentParameter;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.Constant;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.DescKwLenComparator;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.Function;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.FunctionParameter;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.IterativeOperatorParameters;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.KeyWord;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.KwStrComparator;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.KwTypeComparator;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.PrimitiveElement;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.RecursiveArgument;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.SyntaxStackElement;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.TokenStackElement;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.mXparser;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.mathcollection.BinaryRelations;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.mathcollection.BooleanAlgebra;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.mathcollection.Calculus;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.mathcollection.MathFunctions;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.mathcollection.NumberTheory;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.mathcollection.ProbabilityDistributions;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.mathcollection.SpecialFunctions;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.mathcollection.Statistics;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.parsertokens.Token;
import com.ldtteam.shaded.mariuszgromada.math.mxparser.syntaxchecker.SyntaxChecker;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Expression {
    static final int NOT_FOUND = -1;
    static final int FOUND = 0;
    static final boolean INTERNAL = true;
    private static final boolean WITH_EXP_STR = true;
    private static final boolean NO_EXP_STR = false;
    public static final boolean NO_SYNTAX_ERRORS = true;
    public static final boolean SYNTAX_ERROR_OR_STATUS_UNKNOWN = false;
    String expressionString;
    private String description;
    ArrayList<Argument> argumentsList;
    ArrayList<Function> functionsList;
    ArrayList<Constant> constantsList;
    private ArrayList<KeyWord> keyWordsList;
    private ArrayList<Token> initialTokens;
    private ArrayList<Token> tokensList;
    ArrayList<Expression> relatedExpressionsList;
    private double computingTime;
    private boolean expressionWasModified;
    boolean recursiveMode;
    private boolean verboseMode;
    boolean disableUlpRounding;
    static final boolean DISABLE_ULP_ROUNDING = true;
    static final boolean KEEP_ULP_ROUNDING_SETTINGS = false;
    private boolean syntaxStatus;
    private String errorMessage;
    private boolean recursionCallPending;
    private boolean parserKeyWordsOnly;

    void addRelatedExpression(Expression expression) {
        if (expression != null && expression != this && !this.relatedExpressionsList.contains(expression)) {
            this.relatedExpressionsList.add(expression);
        }
    }

    void removeRelatedExpression(Expression expression) {
        this.relatedExpressionsList.remove(expression);
    }

    void showRelatedExpressions() {
        mXparser.consolePrintln();
        mXparser.consolePrintln(this.description + " = " + this.expressionString + ":");
        for (Expression e : this.relatedExpressionsList) {
            mXparser.consolePrintln("-> " + e.description + " = " + e.expressionString);
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean getSyntaxStatus() {
        return this.syntaxStatus;
    }

    void setSyntaxStatus(boolean syntaxStatus, String errorMessage) {
        this.syntaxStatus = syntaxStatus;
        this.errorMessage = errorMessage;
    }

    void setExpressionModifiedFlag() {
        if (!this.recursionCallPending) {
            this.recursionCallPending = true;
            this.expressionWasModified = true;
            this.syntaxStatus = false;
            this.errorMessage = "Syntax status unknown.";
            for (Expression e : this.relatedExpressionsList) {
                e.setExpressionModifiedFlag();
            }
            this.recursionCallPending = false;
        }
    }

    private void expressionInternalVarsInit() {
        this.description = "";
        this.errorMessage = "";
        this.computingTime = 0.0;
        this.recursionCallPending = false;
        this.parserKeyWordsOnly = false;
        this.disableUlpRounding = false;
    }

    private void expressionInit() {
        this.argumentsList = new ArrayList();
        this.functionsList = new ArrayList();
        this.constantsList = new ArrayList();
        this.relatedExpressionsList = new ArrayList();
        this.setSilentMode();
        this.disableRecursiveMode();
        this.expressionInternalVarsInit();
    }

    public Expression(PrimitiveElement ... elements) {
        this.expressionString = "";
        this.expressionInit();
        this.setExpressionModifiedFlag();
        this.addDefinitions(elements);
    }

    public Expression(String expressionString, PrimitiveElement ... elements) {
        this.expressionInit();
        this.expressionString = new String(expressionString);
        this.setExpressionModifiedFlag();
        this.addDefinitions(elements);
    }

    Expression(String expressionString, boolean parserKeyWordsOnly) {
        this.expressionInit();
        this.expressionString = new String(expressionString);
        this.setExpressionModifiedFlag();
        this.parserKeyWordsOnly = parserKeyWordsOnly;
    }

    Expression(String expressionString, ArrayList<Token> initialTokens, ArrayList<Argument> argumentsList, ArrayList<Function> functionsList, ArrayList<Constant> constantsList, boolean disableUlpRounding) {
        this.expressionString = expressionString;
        this.initialTokens = initialTokens;
        this.argumentsList = argumentsList;
        this.functionsList = functionsList;
        this.constantsList = constantsList;
        this.relatedExpressionsList = new ArrayList();
        this.expressionWasModified = false;
        this.syntaxStatus = true;
        this.description = "_internal_";
        this.errorMessage = "";
        this.computingTime = 0.0;
        this.recursionCallPending = false;
        this.parserKeyWordsOnly = false;
        this.disableUlpRounding = disableUlpRounding;
        this.setSilentMode();
        this.disableRecursiveMode();
    }

    Expression(String expressionString, ArrayList<Argument> argumentsList, ArrayList<Function> functionsList, ArrayList<Constant> constantsList, boolean internal) {
        this.expressionString = new String(expressionString);
        this.expressionInternalVarsInit();
        this.setSilentMode();
        this.disableRecursiveMode();
        this.argumentsList = argumentsList;
        this.functionsList = functionsList;
        this.constantsList = constantsList;
        this.relatedExpressionsList = new ArrayList();
        this.setExpressionModifiedFlag();
    }

    private Expression(Expression expression) {
        this.expressionString = new String(expression.expressionString);
        this.description = new String(expression.description);
        this.argumentsList = expression.argumentsList;
        this.functionsList = expression.functionsList;
        this.constantsList = expression.constantsList;
        this.keyWordsList = expression.keyWordsList;
        this.relatedExpressionsList = expression.relatedExpressionsList;
        this.computingTime = 0.0;
        this.expressionWasModified = expression.expressionWasModified;
        this.recursiveMode = expression.recursiveMode;
        this.verboseMode = expression.verboseMode;
        this.syntaxStatus = expression.syntaxStatus;
        this.errorMessage = new String(expression.errorMessage);
        this.recursionCallPending = expression.recursionCallPending;
        this.parserKeyWordsOnly = expression.parserKeyWordsOnly;
        this.disableUlpRounding = expression.disableUlpRounding;
    }

    public void setExpressionString(String expressionString) {
        this.expressionString = expressionString;
        this.setExpressionModifiedFlag();
    }

    public String getExpressionString() {
        return this.expressionString;
    }

    public void clearExpressionString() {
        this.expressionString = "";
        this.setExpressionModifiedFlag();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void clearDescription() {
        this.description = "";
    }

    public void setVerboseMode() {
        this.verboseMode = true;
    }

    public void setSilentMode() {
        this.verboseMode = false;
    }

    public boolean getVerboseMode() {
        return this.verboseMode;
    }

    void setRecursiveMode() {
        this.recursiveMode = true;
    }

    void disableRecursiveMode() {
        this.recursiveMode = false;
    }

    public boolean getRecursiveMode() {
        return this.recursiveMode;
    }

    public double getComputingTime() {
        return this.computingTime;
    }

    public void addDefinitions(PrimitiveElement ... elements) {
        for (PrimitiveElement e : elements) {
            int elementTypeId = e.getMyTypeId();
            if (e == null) continue;
            if (elementTypeId == 101) {
                this.addArguments((Argument)e);
                continue;
            }
            if (elementTypeId == 104) {
                this.addConstants((Constant)e);
                continue;
            }
            if (elementTypeId == 103) {
                this.addFunctions((Function)e);
                continue;
            }
            if (elementTypeId != 102) continue;
            this.addArguments((Argument)e);
        }
    }

    public void removeDefinitions(PrimitiveElement ... elements) {
        for (PrimitiveElement e : elements) {
            int elementTypeId = e.getMyTypeId();
            if (e == null) continue;
            if (elementTypeId == 101) {
                this.removeArguments((Argument)e);
                continue;
            }
            if (elementTypeId == 104) {
                this.removeConstants((Constant)e);
                continue;
            }
            if (elementTypeId == 103) {
                this.removeFunctions((Function)e);
                continue;
            }
            if (elementTypeId != 102) continue;
            this.removeArguments((Argument)e);
        }
    }

    public void addArguments(Argument ... arguments) {
        for (Argument arg : arguments) {
            if (arg == null) continue;
            this.argumentsList.add(arg);
            arg.addRelatedExpression(this);
        }
        this.setExpressionModifiedFlag();
    }

    public void defineArguments(String ... argumentsNames) {
        for (String argName : argumentsNames) {
            Argument arg = new Argument(argName, new PrimitiveElement[0]);
            arg.addRelatedExpression(this);
            this.argumentsList.add(arg);
        }
        this.setExpressionModifiedFlag();
    }

    public void defineArgument(String argumentName, double argumentValue) {
        Argument arg = new Argument(argumentName, argumentValue);
        arg.addRelatedExpression(this);
        this.argumentsList.add(arg);
        this.setExpressionModifiedFlag();
    }

    public int getArgumentIndex(String argumentName) {
        int argumentsNumber = this.argumentsList.size();
        if (argumentsNumber > 0) {
            int argumentIndex = 0;
            int searchResult = -1;
            while (argumentIndex < argumentsNumber && searchResult == -1) {
                if (this.argumentsList.get(argumentIndex).getArgumentName().equals(argumentName)) {
                    searchResult = 0;
                    continue;
                }
                ++argumentIndex;
            }
            if (searchResult == 0) {
                return argumentIndex;
            }
            return -1;
        }
        return -1;
    }

    public Argument getArgument(String argumentName) {
        int argumentIndex = this.getArgumentIndex(argumentName);
        if (argumentIndex == -1) {
            return null;
        }
        return this.argumentsList.get(argumentIndex);
    }

    public Argument getArgument(int argumentIndex) {
        if (argumentIndex < 0 || argumentIndex >= this.argumentsList.size()) {
            return null;
        }
        return this.argumentsList.get(argumentIndex);
    }

    public int getArgumentsNumber() {
        return this.argumentsList.size();
    }

    public void setArgumentValue(String argumentName, double argumentValue) {
        int argumentIndex = this.getArgumentIndex(argumentName);
        if (argumentIndex != -1) {
            this.argumentsList.get(argumentIndex).setArgumentValue(argumentValue);
        }
    }

    public double getArgumentValue(String argumentName) {
        int argumentIndex = this.getArgumentIndex(argumentName);
        if (argumentIndex != -1) {
            return this.argumentsList.get(argumentIndex).getArgumentValue();
        }
        return Double.NaN;
    }

    public void removeArguments(String ... argumentsNames) {
        for (String argumentName : argumentsNames) {
            int argumentIndex = this.getArgumentIndex(argumentName);
            if (argumentIndex == -1) continue;
            Argument arg = this.argumentsList.get(argumentIndex);
            arg.removeRelatedExpression(this);
            this.argumentsList.remove(argumentIndex);
        }
        this.setExpressionModifiedFlag();
    }

    public void removeArguments(Argument ... arguments) {
        for (Argument argument : arguments) {
            if (argument == null) continue;
            this.argumentsList.remove(argument);
            argument.removeRelatedExpression(this);
        }
        this.setExpressionModifiedFlag();
    }

    public void removeAllArguments() {
        for (Argument arg : this.argumentsList) {
            arg.removeRelatedExpression(this);
        }
        this.argumentsList.clear();
        this.setExpressionModifiedFlag();
    }

    public void addConstants(Constant ... constants) {
        for (Constant constant : constants) {
            if (constant == null) continue;
            this.constantsList.add(constant);
            constant.addRelatedExpression(this);
        }
        this.setExpressionModifiedFlag();
    }

    public void addConstants(ArrayList<Constant> constantsList) {
        this.constantsList.addAll(constantsList);
        for (Constant c : constantsList) {
            c.addRelatedExpression(this);
        }
        this.setExpressionModifiedFlag();
    }

    public void defineConstant(String constantName, double constantValue) {
        Constant c = new Constant(constantName, constantValue);
        c.addRelatedExpression(this);
        this.constantsList.add(c);
        this.setExpressionModifiedFlag();
    }

    public int getConstantIndex(String constantName) {
        int constantsNumber = this.constantsList.size();
        if (constantsNumber > 0) {
            int constantIndex = 0;
            int searchResult = -1;
            while (constantIndex < constantsNumber && searchResult == -1) {
                if (this.constantsList.get(constantIndex).getConstantName().equals(constantName)) {
                    searchResult = 0;
                    continue;
                }
                ++constantIndex;
            }
            if (searchResult == 0) {
                return constantIndex;
            }
            return -1;
        }
        return -1;
    }

    public Constant getConstant(String constantName) {
        int constantIndex = this.getConstantIndex(constantName);
        if (constantIndex == -1) {
            return null;
        }
        return this.constantsList.get(constantIndex);
    }

    public Constant getConstant(int constantIndex) {
        if (constantIndex < 0 || constantIndex >= this.constantsList.size()) {
            return null;
        }
        return this.constantsList.get(constantIndex);
    }

    public int getConstantsNumber() {
        return this.constantsList.size();
    }

    public void removeConstants(String ... constantsNames) {
        for (String constantName : constantsNames) {
            int constantIndex = this.getConstantIndex(constantName);
            if (constantIndex == -1) continue;
            Constant c = this.constantsList.get(constantIndex);
            c.removeRelatedExpression(this);
            this.constantsList.remove(constantIndex);
        }
        this.setExpressionModifiedFlag();
    }

    public void removeConstants(Constant ... constants) {
        for (Constant constant : constants) {
            if (constant == null) continue;
            this.constantsList.remove(constant);
            constant.removeRelatedExpression(this);
            this.setExpressionModifiedFlag();
        }
    }

    public void removeAllConstants() {
        for (Constant c : this.constantsList) {
            c.removeRelatedExpression(this);
        }
        this.constantsList.clear();
        this.setExpressionModifiedFlag();
    }

    public void addFunctions(Function ... functions) {
        for (Function f : functions) {
            if (f == null) continue;
            this.functionsList.add(f);
            if (f.getFunctionBodyType() != 1) continue;
            f.addRelatedExpression(this);
        }
        this.setExpressionModifiedFlag();
    }

    public void defineFunction(String functionName, String functionExpressionString, String ... argumentsNames) {
        Function f = new Function(functionName, functionExpressionString, argumentsNames);
        this.functionsList.add(f);
        f.addRelatedExpression(this);
        this.setExpressionModifiedFlag();
    }

    public int getFunctionIndex(String functionName) {
        int functionsNumber = this.functionsList.size();
        if (functionsNumber > 0) {
            int functionIndex = 0;
            int searchResult = -1;
            while (functionIndex < functionsNumber && searchResult == -1) {
                if (this.functionsList.get(functionIndex).getFunctionName().equals(functionName)) {
                    searchResult = 0;
                    continue;
                }
                ++functionIndex;
            }
            if (searchResult == 0) {
                return functionIndex;
            }
            return -1;
        }
        return -1;
    }

    public Function getFunction(String functionName) {
        int functionIndex = this.getFunctionIndex(functionName);
        if (functionIndex == -1) {
            return null;
        }
        return this.functionsList.get(functionIndex);
    }

    public Function getFunction(int functionIndex) {
        if (functionIndex < 0 || functionIndex >= this.functionsList.size()) {
            return null;
        }
        return this.functionsList.get(functionIndex);
    }

    public int getFunctionsNumber() {
        return this.functionsList.size();
    }

    public void removeFunctions(String ... functionsNames) {
        for (String functionName : functionsNames) {
            int functionIndex = this.getFunctionIndex(functionName);
            if (functionIndex == -1) continue;
            Function f = this.functionsList.get(functionIndex);
            f.removeRelatedExpression(this);
            this.functionsList.remove(f);
        }
        this.setExpressionModifiedFlag();
    }

    public void removeFunctions(Function ... functions) {
        for (Function function : functions) {
            if (function == null) continue;
            function.removeRelatedExpression(this);
            this.functionsList.remove(function);
        }
        this.setExpressionModifiedFlag();
    }

    public void removeAllFunctions() {
        for (Function f : this.functionsList) {
            f.removeRelatedExpression(this);
        }
        this.functionsList.clear();
        this.setExpressionModifiedFlag();
    }

    private void setToNumber(int pos, double number, boolean ulpRound) {
        int precision;
        Token token = this.tokensList.get(pos);
        token.tokenValue = mXparser.ulpRounding && !this.disableUlpRounding ? (ulpRound ? (Double.isNaN(number) || Double.isInfinite(number) ? number : ((precision = MathFunctions.ulpDecimalDigitsBefore(number)) >= 0 ? MathFunctions.round(number, precision) : number)) : number) : number;
        token.tokenTypeId = 0;
        token.tokenId = 1;
        token.keyWord = "_num_";
    }

    private void setToNumber(int pos, double number) {
        this.setToNumber(pos, number, false);
    }

    private void f1SetDecreaseRemove(int pos, double result, boolean ulpRound) {
        this.setToNumber(pos, result, ulpRound);
        --this.tokensList.get((int)pos).tokenLevel;
        this.tokensList.remove(pos + 1);
    }

    private void f1SetDecreaseRemove(int pos, double result) {
        this.f1SetDecreaseRemove(pos, result, false);
    }

    private void f2SetDecreaseRemove(int pos, double result, boolean ulpRound) {
        this.setToNumber(pos, result, ulpRound);
        --this.tokensList.get((int)pos).tokenLevel;
        this.tokensList.remove(pos + 2);
        this.tokensList.remove(pos + 1);
    }

    private void f2SetDecreaseRemove(int pos, double result) {
        this.f2SetDecreaseRemove(pos, result, false);
    }

    private void f3SetDecreaseRemove(int pos, double result, boolean ulpRound) {
        this.setToNumber(pos, result, ulpRound);
        --this.tokensList.get((int)pos).tokenLevel;
        this.tokensList.remove(pos + 3);
        this.tokensList.remove(pos + 2);
        this.tokensList.remove(pos + 1);
    }

    private void f3SetDecreaseRemove(int pos, double result) {
        this.f3SetDecreaseRemove(pos, result, false);
    }

    private void opSetDecreaseRemove(int pos, double result, boolean ulpRound) {
        this.setToNumber(pos, result, ulpRound);
        this.tokensList.remove(pos + 1);
        this.tokensList.remove(pos - 1);
    }

    private void opSetDecreaseRemove(int pos, double result) {
        this.opSetDecreaseRemove(pos, result, false);
    }

    private void calcSetDecreaseRemove(int pos, double result, boolean ulpRound) {
        this.setToNumber(pos, result, ulpRound);
        --this.tokensList.get((int)pos).tokenLevel;
        int lPos = pos + 1;
        int rPos = lPos + 1;
        while (this.tokensList.get((int)rPos).tokenTypeId != 20 || this.tokensList.get((int)rPos).tokenId != 2 || this.tokensList.get((int)rPos).tokenLevel != this.tokensList.get((int)lPos).tokenLevel) {
            ++rPos;
        }
        for (int p = rPos; p >= lPos; --p) {
            this.tokensList.remove(p);
        }
    }

    private void calcSetDecreaseRemove(int pos, double result) {
        this.calcSetDecreaseRemove(pos, result, false);
    }

    private void variadicSetDecreaseRemove(int pos, double value, int length, boolean ulpRound) {
        this.setToNumber(pos, value, ulpRound);
        --this.tokensList.get((int)pos).tokenLevel;
        for (int p = pos + length; p > pos; --p) {
            this.tokensList.remove(p);
        }
    }

    private void variadicSetDecreaseRemove(int pos, double value, int length) {
        this.variadicSetDecreaseRemove(pos, value, length, false);
    }

    private void ifSetRemove(int pos, double ifCondition, boolean ulpRound) {
        int lPos = pos + 1;
        int ifLevel = this.tokensList.get((int)lPos).tokenLevel;
        int c1Pos = lPos + 1;
        while (this.tokensList.get((int)c1Pos).tokenTypeId != 20 || this.tokensList.get((int)c1Pos).tokenId != 3 || this.tokensList.get((int)c1Pos).tokenLevel != ifLevel) {
            ++c1Pos;
        }
        int c2Pos = c1Pos + 1;
        while (this.tokensList.get((int)c2Pos).tokenTypeId != 20 || this.tokensList.get((int)c2Pos).tokenId != 3 || this.tokensList.get((int)c2Pos).tokenLevel != ifLevel) {
            ++c2Pos;
        }
        int rPos = c2Pos + 1;
        while (this.tokensList.get((int)rPos).tokenTypeId != 20 || this.tokensList.get((int)rPos).tokenId != 2 || this.tokensList.get((int)rPos).tokenLevel != ifLevel) {
            ++rPos;
        }
        if (!Double.isNaN(ifCondition)) {
            if (ifCondition != 0.0) {
                this.setToNumber(c2Pos + 1, Double.NaN);
                this.tokensList.get((int)(c2Pos + 1)).tokenLevel = ifLevel;
                this.removeTokens(c2Pos + 2, rPos - 1);
            } else {
                this.setToNumber(c1Pos + 1, Double.NaN);
                this.tokensList.get((int)(c1Pos + 1)).tokenLevel = ifLevel;
                this.removeTokens(c1Pos + 2, c2Pos - 1);
            }
        } else {
            this.setToNumber(c1Pos + 1, Double.NaN);
            this.setToNumber(c2Pos + 1, Double.NaN);
            this.tokensList.get((int)(c1Pos + 1)).tokenLevel = ifLevel;
            this.tokensList.get((int)(c2Pos + 1)).tokenLevel = ifLevel;
            this.removeTokens(c2Pos + 2, rPos - 1);
            this.removeTokens(c1Pos + 2, c2Pos - 1);
        }
        this.setToNumber(lPos + 1, ifCondition, ulpRound);
        this.tokensList.get((int)(lPos + 1)).tokenLevel = ifLevel;
        this.removeTokens(lPos + 2, c1Pos - 1);
        this.tokensList.get((int)pos).tokenId = 2;
    }

    private void removeTokens(int from, int to) {
        if (from < to) {
            for (int p = to; p >= from; --p) {
                this.tokensList.remove(p);
            }
        } else if (from == to) {
            this.tokensList.remove(from);
        }
    }

    private void ifSetRemove(int pos, double ifCondition) {
        this.ifSetRemove(pos, ifCondition, false);
    }

    private ArrayList<Token> createInitialTokens(int startPos, int endPos, ArrayList<Token> tokensList) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (int p = startPos; p <= endPos; ++p) {
            Token t = tokensList.get(p).clone();
            tokens.add(t);
        }
        return tokens;
    }

    private int getParametersNumber(int pos) {
        int lPpos = pos + 1;
        if (lPpos == this.initialTokens.size()) {
            return -1;
        }
        if (this.initialTokens.get((int)lPpos).tokenTypeId == 20 && this.initialTokens.get((int)lPpos).tokenId == 1) {
            int tokenLevel = this.initialTokens.get((int)lPpos).tokenLevel;
            int endPos = lPpos + 1;
            while (this.initialTokens.get((int)endPos).tokenTypeId != 20 || this.initialTokens.get((int)endPos).tokenId != 2 || this.initialTokens.get((int)endPos).tokenLevel != tokenLevel) {
                ++endPos;
            }
            if (endPos == lPpos + 1) {
                return 0;
            }
            int numberOfCommas = 0;
            for (int p = lPpos; p < endPos; ++p) {
                Token token = this.initialTokens.get(p);
                if (token.tokenTypeId != 20 || token.tokenId != 3 || token.tokenLevel != tokenLevel) continue;
                ++numberOfCommas;
            }
            return numberOfCommas + 1;
        }
        return -1;
    }

    private ArrayList<FunctionParameter> getFunctionParameters(int pos, ArrayList<Token> tokensList) {
        ArrayList<FunctionParameter> functionParameters = new ArrayList<FunctionParameter>();
        int cPos = pos + 2;
        int tokenLevel = tokensList.get((int)(pos + 1)).tokenLevel;
        int pPos = cPos;
        boolean end = false;
        ArrayList<Token> paramTkones = new ArrayList<Token>();
        String paramStr = "";
        do {
            Token t = tokensList.get(cPos);
            boolean comma = false;
            boolean paren = false;
            if (t.tokenLevel == tokenLevel && t.tokenTypeId == 20) {
                if (t.tokenId == 2) {
                    paren = true;
                } else if (t.tokenId == 3) {
                    comma = true;
                }
            }
            if (paren || comma) {
                if (cPos > pos + 2) {
                    functionParameters.add(new FunctionParameter(paramTkones, paramStr, pPos, cPos - 1));
                    paramTkones = new ArrayList();
                    paramStr = "";
                    pPos = cPos + 1;
                }
            } else {
                paramTkones.add(t);
                paramStr = paramStr + t.tokenStr;
            }
            if (paren) {
                end = true;
                continue;
            }
            ++cPos;
        } while (!end);
        return functionParameters;
    }

    private ArgumentParameter getParamArgument(String argumentName) {
        ArgumentParameter argParam = new ArgumentParameter();
        argParam.index = this.getArgumentIndex(argumentName);
        argParam.argument = this.getArgument(argParam.index);
        argParam.presence = 0;
        if (argParam.argument == null) {
            argParam.argument = new Argument(argumentName, new PrimitiveElement[0]);
            this.argumentsList.add(argParam.argument);
            argParam.index = this.argumentsList.size() - 1;
            argParam.presence = -1;
        } else {
            argParam.initialValue = argParam.argument.argumentValue;
            argParam.initialType = argParam.argument.argumentType;
            argParam.argument.argumentValue = argParam.argument.getArgumentValue();
            argParam.argument.argumentType = 1;
        }
        return argParam;
    }

    private void clearParamArgument(ArgumentParameter argParam) {
        if (argParam.presence == -1) {
            this.argumentsList.remove(argParam.index);
        } else {
            argParam.argument.argumentValue = argParam.initialValue;
            argParam.argument.argumentType = argParam.initialType;
        }
    }

    private void ARGUMENT(int pos) {
        Argument argument = this.argumentsList.get(this.tokensList.get((int)pos).tokenId);
        boolean argumentVerboseMode = argument.getVerboseMode();
        if (this.verboseMode) {
            argument.setVerboseMode();
        }
        this.setToNumber(pos, argument.getArgumentValue());
        if (!argumentVerboseMode) {
            argument.setSilentMode();
        }
    }

    private void USER_FUNCTION(int pos) {
        double value;
        Function fun = this.functionsList.get(this.tokensList.get((int)pos).tokenId);
        Function function = fun.getRecursiveMode() ? fun.clone() : fun;
        int argsNumber = function.getParametersNumber();
        for (int argIdx = 0; argIdx < argsNumber; ++argIdx) {
            function.setArgumentValue(argIdx, this.tokensList.get((int)(pos + argIdx + 1)).tokenValue);
        }
        boolean functionVerboseMode = function.getVerboseMode();
        if (this.verboseMode) {
            function.setVerboseMode();
        }
        try {
            value = function.calculate();
        }
        catch (StackOverflowError soe) {
            value = Double.NaN;
            this.errorMessage = soe.getMessage();
        }
        this.setToNumber(pos, value);
        --this.tokensList.get((int)pos).tokenLevel;
        if (!functionVerboseMode) {
            function.setSilentMode();
        }
        for (int argIdx = argsNumber; argIdx > 0; --argIdx) {
            this.tokensList.remove(pos + argIdx);
        }
    }

    private void USER_CONSTANT(int pos) {
        Constant constant = this.constantsList.get(this.tokensList.get((int)pos).tokenId);
        this.setToNumber(pos, constant.getConstantValue());
    }

    private void RECURSIVE_ARGUMENT(int pos) {
        double index = this.tokensList.get((int)(pos + 1)).tokenValue;
        RecursiveArgument argument = (RecursiveArgument)this.argumentsList.get(this.tokensList.get((int)pos).tokenId);
        boolean argumentVerboseMode = argument.getVerboseMode();
        if (this.verboseMode) {
            argument.setVerboseMode();
        }
        double result = argument.getArgumentValue(index);
        this.f1SetDecreaseRemove(pos, result);
        if (!argumentVerboseMode) {
            argument.setSilentMode();
        }
    }

    private void CONSTANT(int pos) {
        double constValue = Double.NaN;
        switch (this.tokensList.get((int)pos).tokenId) {
            case 1: {
                constValue = Math.PI;
                break;
            }
            case 2: {
                constValue = Math.E;
                break;
            }
            case 3: {
                constValue = 0.5772156649015329;
                break;
            }
            case 4: {
                constValue = 1.618033988749895;
                break;
            }
            case 5: {
                constValue = 1.324717957244746;
                break;
            }
            case 6: {
                constValue = 0.70258;
                break;
            }
            case 7: {
                constValue = 4.66920160910299;
                break;
            }
            case 8: {
                constValue = 2.5029078750958926;
                break;
            }
            case 9: {
                constValue = 0.6601618158468696;
                break;
            }
            case 10: {
                constValue = 0.26149721284764277;
                break;
            }
            case 11: {
                constValue = 1.9021605823;
                break;
            }
            case 12: {
                constValue = 0.87058838;
                break;
            }
            case 13: {
                constValue = -2.7E-9;
                break;
            }
            case 14: {
                constValue = 0.915965594177219;
                break;
            }
            case 15: {
                constValue = 0.7642236535892206;
                break;
            }
            case 16: {
                constValue = 1.13198824;
                break;
            }
            case 17: {
                constValue = 1.0;
                break;
            }
            case 18: {
                constValue = 1.451369234883381;
                break;
            }
            case 19: {
                constValue = 1.6066951524152917;
                break;
            }
            case 20: {
                constValue = 0.2801694990238691;
                break;
            }
            case 21: {
                constValue = 0.30366300289873266;
                break;
            }
            case 22: {
                constValue = 0.353236371854996;
                break;
            }
            case 23: {
                constValue = 0.6243299885435508;
                break;
            }
            case 24: {
                constValue = 0.6434105463;
                break;
            }
            case 25: {
                constValue = 0.6627434193491816;
                break;
            }
            case 26: {
                constValue = 0.8093940205;
                break;
            }
            case 27: {
                constValue = 1.0986858055;
                break;
            }
            case 28: {
                constValue = 3.2758229187218113;
                break;
            }
            case 29: {
                constValue = 1.2020569031595942;
                break;
            }
            case 30: {
                constValue = 1.3063778838630806;
                break;
            }
            case 31: {
                constValue = 1.4560749485826896;
                break;
            }
            case 32: {
                constValue = 1.4670780794;
                break;
            }
            case 33: {
                constValue = 1.5396007178;
                break;
            }
            case 34: {
                constValue = 1.7052111401053678;
                break;
            }
            case 35: {
                constValue = 2.5849817595792532;
                break;
            }
            case 36: {
                constValue = 2.6854520010653062;
                break;
            }
            case 37: {
                constValue = 2.8077702420285195;
                break;
            }
            case 38: {
                constValue = 0.5;
                break;
            }
            case 39: {
                constValue = 2.295587149392638;
                break;
            }
            case 40: {
                constValue = 0.5671432904097838;
                break;
            }
            case 41: {
                constValue = 0.187859;
                break;
            }
            case 42: {
                constValue = 1.045163780117493;
                break;
            }
            case 43: {
                constValue = 0.5963473623231941;
                break;
            }
            case 101: {
                constValue = 2.99792458E8;
                break;
            }
            case 102: {
                constValue = 6.67408E-11;
                break;
            }
            case 103: {
                constValue = 9.80665;
                break;
            }
            case 104: {
                constValue = 6.62607004E-34;
                break;
            }
            case 105: {
                constValue = 1.0545718001391127E-34;
                break;
            }
            case 106: {
                constValue = 1.616229E-35;
                break;
            }
            case 107: {
                constValue = 2.17647E-8;
                break;
            }
            case 108: {
                constValue = 5.39116E-44;
                break;
            }
            case 201: {
                constValue = 9.4607304725808E15;
                break;
            }
            case 202: {
                constValue = 1.495978707E11;
                break;
            }
            case 203: {
                constValue = 3.085677581491362E16;
                break;
            }
            case 204: {
                constValue = 3.085677581491362E19;
                break;
            }
            case 205: {
                constValue = 6378137.0;
                break;
            }
            case 206: {
                constValue = 6356752.3;
                break;
            }
            case 207: {
                constValue = 6371008.8;
                break;
            }
            case 208: {
                constValue = 5.9722E24;
                break;
            }
            case 209: {
                constValue = 1.495980229906324E11;
                break;
            }
            case 210: {
                constValue = 1737100.0;
                break;
            }
            case 211: {
                constValue = 7.34582809714E22;
                break;
            }
            case 212: {
                constValue = 3.84399E8;
                break;
            }
            case 213: {
                constValue = 6.957E8;
                break;
            }
            case 214: {
                constValue = 1.98842039204614E30;
                break;
            }
            case 215: {
                constValue = 2439700.0;
                break;
            }
            case 216: {
                constValue = 3.3026266E23;
                break;
            }
            case 217: {
                constValue = 5.79090365522286E10;
                break;
            }
            case 218: {
                constValue = 6051800.0;
                break;
            }
            case 219: {
                constValue = 4.867343E24;
                break;
            }
            case 220: {
                constValue = 1.082089270091724E11;
                break;
            }
            case 221: {
                constValue = 3389500.0;
                break;
            }
            case 222: {
                constValue = 6.390254E23;
                break;
            }
            case 223: {
                constValue = 2.279391340303053E11;
                break;
            }
            case 224: {
                constValue = 6.9911E7;
                break;
            }
            case 225: {
                constValue = 1.8979651600000002E27;
                break;
            }
            case 226: {
                constValue = 7.782978821038201E11;
                break;
            }
            case 227: {
                constValue = 5.8232E7;
                break;
            }
            case 228: {
                constValue = 5.6830857980000005E26;
                break;
            }
            case 229: {
                constValue = 1.42939269475143E12;
                break;
            }
            case 230: {
                constValue = 2.5362E7;
                break;
            }
            case 231: {
                constValue = 8.681189920000001E25;
                break;
            }
            case 232: {
                constValue = 2.87503171826088E12;
                break;
            }
            case 233: {
                constValue = 2.4622E7;
                break;
            }
            case 234: {
                constValue = 1.024053134E26;
                break;
            }
            case 235: {
                constValue = 4.504449781152961E12;
            }
        }
        this.setToNumber(pos, constValue);
    }

    private void UNIT(int pos) {
        double unitValue = Double.NaN;
        switch (this.tokensList.get((int)pos).tokenId) {
            case 1: {
                unitValue = 0.01;
                break;
            }
            case 2: {
                unitValue = 0.001;
                break;
            }
            case 101: {
                unitValue = 1.0E24;
                break;
            }
            case 102: {
                unitValue = 1.0E21;
                break;
            }
            case 103: {
                unitValue = 1.0E18;
                break;
            }
            case 104: {
                unitValue = 1.0E15;
                break;
            }
            case 105: {
                unitValue = 1.0E12;
                break;
            }
            case 106: {
                unitValue = 1.0E9;
                break;
            }
            case 107: {
                unitValue = 1000000.0;
                break;
            }
            case 108: {
                unitValue = 1000.0;
                break;
            }
            case 109: {
                unitValue = 100.0;
                break;
            }
            case 110: {
                unitValue = 10.0;
                break;
            }
            case 111: {
                unitValue = 0.1;
                break;
            }
            case 112: {
                unitValue = 0.01;
                break;
            }
            case 113: {
                unitValue = 0.001;
                break;
            }
            case 114: {
                unitValue = 1.0E-6;
                break;
            }
            case 115: {
                unitValue = 1.0E-9;
                break;
            }
            case 116: {
                unitValue = 1.0E-12;
                break;
            }
            case 117: {
                unitValue = 1.0E-15;
                break;
            }
            case 118: {
                unitValue = 1.0E-18;
                break;
            }
            case 119: {
                unitValue = 1.0E-21;
                break;
            }
            case 120: {
                unitValue = 1.0E-24;
                break;
            }
            case 201: {
                unitValue = 1.0;
                break;
            }
            case 202: {
                unitValue = 1000.0;
                break;
            }
            case 203: {
                unitValue = 0.01;
                break;
            }
            case 204: {
                unitValue = 0.001;
                break;
            }
            case 205: {
                unitValue = 0.025400000000000002;
                break;
            }
            case 206: {
                unitValue = 0.9144;
                break;
            }
            case 207: {
                unitValue = 0.3048;
                break;
            }
            case 208: {
                unitValue = 1609.344;
                break;
            }
            case 209: {
                unitValue = 1852.0;
                break;
            }
            case 301: {
                unitValue = 1.0;
                break;
            }
            case 302: {
                unitValue = 1.0E-4;
                break;
            }
            case 303: {
                unitValue = 1.0E-6;
                break;
            }
            case 304: {
                unitValue = 100.0;
                break;
            }
            case 305: {
                unitValue = 10000.0;
                break;
            }
            case 306: {
                unitValue = 4046.8564224000006;
                break;
            }
            case 307: {
                unitValue = 1000000.0;
                break;
            }
            case 401: {
                unitValue = 1.0E-9;
                break;
            }
            case 402: {
                unitValue = 1.0000000000000002E-6;
                break;
            }
            case 403: {
                unitValue = 1.0;
                break;
            }
            case 404: {
                unitValue = 1.0E9;
                break;
            }
            case 405: {
                unitValue = 1.0000000000000002E-6;
                break;
            }
            case 406: {
                unitValue = 0.0010000000000000002;
                break;
            }
            case 407: {
                unitValue = 0.003785411780000001;
                break;
            }
            case 408: {
                unitValue = 4.7317647300000007E-4;
                break;
            }
            case 501: {
                unitValue = 1.0;
                break;
            }
            case 502: {
                unitValue = 0.001;
                break;
            }
            case 503: {
                unitValue = 60.0;
                break;
            }
            case 504: {
                unitValue = 3600.0;
                break;
            }
            case 505: {
                unitValue = 86400.0;
                break;
            }
            case 506: {
                unitValue = 604800.0;
                break;
            }
            case 507: {
                unitValue = 3.15576E7;
                break;
            }
            case 508: {
                unitValue = 1.0;
                break;
            }
            case 509: {
                unitValue = 0.001;
                break;
            }
            case 510: {
                unitValue = 1.0E-6;
                break;
            }
            case 511: {
                unitValue = 0.01;
                break;
            }
            case 512: {
                unitValue = 1000.0;
                break;
            }
            case 513: {
                unitValue = 0.0283495231;
                break;
            }
            case 514: {
                unitValue = 0.45359237;
                break;
            }
            case 601: {
                unitValue = 1.0;
                break;
            }
            case 602: {
                unitValue = 1024.0;
                break;
            }
            case 603: {
                unitValue = 1048576.0;
                break;
            }
            case 604: {
                unitValue = 1.073741824E9;
                break;
            }
            case 605: {
                unitValue = 1.099511627776E12;
                break;
            }
            case 606: {
                unitValue = 1.125899906842624E15;
                break;
            }
            case 607: {
                unitValue = 1.152921504606847E18;
                break;
            }
            case 608: {
                unitValue = 1.1805916207174113E21;
                break;
            }
            case 609: {
                unitValue = 1.2089258196146292E24;
                break;
            }
            case 610: {
                unitValue = 8.0;
                break;
            }
            case 611: {
                unitValue = 8192.0;
                break;
            }
            case 612: {
                unitValue = 8388608.0;
                break;
            }
            case 613: {
                unitValue = 8.589934592E9;
                break;
            }
            case 614: {
                unitValue = 8.796093022208E12;
                break;
            }
            case 615: {
                unitValue = 9.007199254740992E15;
                break;
            }
            case 616: {
                unitValue = 9.223372036854776E18;
                break;
            }
            case 617: {
                unitValue = 9.44473296573929E21;
                break;
            }
            case 618: {
                unitValue = 9.671406556917033E24;
                break;
            }
            case 701: {
                unitValue = 1.0;
                break;
            }
            case 702: {
                unitValue = 1.6021766208E-19;
                break;
            }
            case 703: {
                unitValue = 1.6021766208000002E-16;
                break;
            }
            case 704: {
                unitValue = 1.6021766208000001E-13;
                break;
            }
            case 705: {
                unitValue = 1.6021766208000002E-10;
                break;
            }
            case 706: {
                unitValue = 1.6021766208000002E-7;
                break;
            }
            case 801: {
                unitValue = 1.0;
                break;
            }
            case 802: {
                unitValue = 0.2777777777777778;
                break;
            }
            case 803: {
                unitValue = 0.44704;
                break;
            }
            case 804: {
                unitValue = 0.514444444;
                break;
            }
            case 901: {
                unitValue = 1.0;
                break;
            }
            case 902: {
                unitValue = 7.716049382716049E-5;
                break;
            }
            case 903: {
                unitValue = 1.2417777777777778E-4;
                break;
            }
            case 1001: {
                unitValue = 1.0;
                break;
            }
            case 1002: {
                unitValue = Math.PI / 180;
                break;
            }
            case 1003: {
                unitValue = 2.908882086657216E-4;
                break;
            }
            case 1004: {
                unitValue = 4.84813681109536E-6;
            }
        }
        this.setToNumber(pos, unitValue);
    }

    private void RANDOM_VARIABLE(int pos) {
        double rndVar = Double.NaN;
        switch (this.tokensList.get((int)pos).tokenId) {
            case 1: {
                rndVar = ProbabilityDistributions.rndUniformContinuous(ProbabilityDistributions.randomGenerator);
                break;
            }
            case 2: {
                rndVar = ProbabilityDistributions.rndInteger(ProbabilityDistributions.randomGenerator);
                break;
            }
            case 3: {
                rndVar = ProbabilityDistributions.rndInteger(-10, 10, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 4: {
                rndVar = ProbabilityDistributions.rndInteger(-100, 100, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 5: {
                rndVar = ProbabilityDistributions.rndInteger(-1000, 1000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 6: {
                rndVar = ProbabilityDistributions.rndInteger(-10000, 10000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 7: {
                rndVar = ProbabilityDistributions.rndInteger(-100000, 100000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 8: {
                rndVar = ProbabilityDistributions.rndInteger(-1000000, 1000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 9: {
                rndVar = ProbabilityDistributions.rndInteger(-10000000, 10000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 10: {
                rndVar = ProbabilityDistributions.rndInteger(-100000000, 100000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 11: {
                rndVar = ProbabilityDistributions.rndInteger(-1000000000, 1000000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 12: {
                rndVar = ProbabilityDistributions.rndInteger(0, 0x7FFFFFFE, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 13: {
                rndVar = ProbabilityDistributions.rndInteger(0, 10, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 14: {
                rndVar = ProbabilityDistributions.rndInteger(0, 100, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 15: {
                rndVar = ProbabilityDistributions.rndInteger(0, 1000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 16: {
                rndVar = ProbabilityDistributions.rndInteger(0, 10000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 17: {
                rndVar = ProbabilityDistributions.rndInteger(0, 100000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 18: {
                rndVar = ProbabilityDistributions.rndInteger(0, 1000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 19: {
                rndVar = ProbabilityDistributions.rndInteger(0, 10000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 20: {
                rndVar = ProbabilityDistributions.rndInteger(0, 100000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 21: {
                rndVar = ProbabilityDistributions.rndInteger(0, 1000000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 22: {
                rndVar = ProbabilityDistributions.rndInteger(1, 0x7FFFFFFE, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 23: {
                rndVar = ProbabilityDistributions.rndInteger(1, 10, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 24: {
                rndVar = ProbabilityDistributions.rndInteger(1, 100, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 25: {
                rndVar = ProbabilityDistributions.rndInteger(1, 1000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 26: {
                rndVar = ProbabilityDistributions.rndInteger(1, 10000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 27: {
                rndVar = ProbabilityDistributions.rndInteger(1, 100000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 28: {
                rndVar = ProbabilityDistributions.rndInteger(1, 1000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 29: {
                rndVar = ProbabilityDistributions.rndInteger(1, 10000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 30: {
                rndVar = ProbabilityDistributions.rndInteger(1, 100000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 31: {
                rndVar = ProbabilityDistributions.rndInteger(1, 1000000000, ProbabilityDistributions.randomGenerator);
                break;
            }
            case 32: {
                rndVar = ProbabilityDistributions.rndNormal(0.0, 1.0, ProbabilityDistributions.randomGenerator);
            }
        }
        this.setToNumber(pos, rndVar);
    }

    private double getTokenValue(int tokenIndex) {
        return this.tokensList.get((int)tokenIndex).tokenValue;
    }

    private void POWER(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, MathFunctions.power(a, b), true);
    }

    private void MODULO(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, MathFunctions.mod(a, b));
    }

    private void DIVIDE(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, MathFunctions.div(a, b), true);
    }

    private void MULTIPLY(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, a * b, true);
    }

    private void PLUS(int pos) {
        Token b = this.tokensList.get(pos + 1);
        if (pos > 0) {
            Token a = this.tokensList.get(pos - 1);
            if (a.tokenTypeId == 0 && b.tokenTypeId == 0) {
                this.opSetDecreaseRemove(pos, a.tokenValue + b.tokenValue, true);
            } else if (b.tokenTypeId == 0) {
                this.setToNumber(pos, b.tokenValue);
                this.tokensList.remove(pos + 1);
            }
        } else if (b.tokenTypeId == 0) {
            this.setToNumber(pos, b.tokenValue);
            this.tokensList.remove(pos + 1);
        }
    }

    private void MINUS(int pos) {
        Token b = this.tokensList.get(pos + 1);
        if (pos > 0) {
            Token a = this.tokensList.get(pos - 1);
            if (a.tokenTypeId == 0 && b.tokenTypeId == 0) {
                this.opSetDecreaseRemove(pos, a.tokenValue - b.tokenValue, true);
            } else if (b.tokenTypeId == 0) {
                this.setToNumber(pos, -b.tokenValue);
                this.tokensList.remove(pos + 1);
            }
        } else if (b.tokenTypeId == 0) {
            this.setToNumber(pos, -b.tokenValue);
            this.tokensList.remove(pos + 1);
        }
    }

    private void AND(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.and(a, b));
    }

    private void OR(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.or(a, b));
    }

    private void NAND(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.nand(a, b));
    }

    private void NOR(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.nor(a, b));
    }

    private void XOR(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.xor(a, b));
    }

    private void IMP(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.imp(a, b));
    }

    private void CIMP(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.cimp(a, b));
    }

    private void NIMP(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.nimp(a, b));
    }

    private void CNIMP(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.cnimp(a, b));
    }

    private void EQV(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BooleanAlgebra.eqv(a, b));
    }

    private void NEG(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.setToNumber(pos, BooleanAlgebra.not(a));
        this.tokensList.remove(pos + 1);
    }

    private void EQ(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BinaryRelations.eq(a, b));
    }

    private void NEQ(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BinaryRelations.neq(a, b));
    }

    private void LT(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BinaryRelations.lt(a, b));
    }

    private void GT(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BinaryRelations.gt(a, b));
    }

    private void LEQ(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BinaryRelations.leq(a, b));
    }

    private void GEQ(int pos) {
        double a = this.getTokenValue(pos - 1);
        double b = this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, BinaryRelations.geq(a, b));
    }

    private void BITWISE_COMPL(int pos) {
        long a = (long)this.getTokenValue(pos + 1);
        this.setToNumber(pos, a ^ 0xFFFFFFFFFFFFFFFFL);
        this.tokensList.remove(pos + 1);
    }

    private void BITWISE_AND(int pos) {
        long a = (long)this.getTokenValue(pos - 1);
        long b = (long)this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, a & b);
    }

    private void BITWISE_OR(int pos) {
        long a = (long)this.getTokenValue(pos - 1);
        long b = (long)this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, a | b);
    }

    private void BITWISE_XOR(int pos) {
        long a = (long)this.getTokenValue(pos - 1);
        long b = (long)this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, a ^ b);
    }

    private void BITWISE_LEFT_SHIFT(int pos) {
        long a = (long)this.getTokenValue(pos - 1);
        int b = (int)this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, a << b);
    }

    private void BITWISE_RIGHT_SHIFT(int pos) {
        long a = (long)this.getTokenValue(pos - 1);
        int b = (int)this.getTokenValue(pos + 1);
        this.opSetDecreaseRemove(pos, a >> b);
    }

    private void SIN(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.sin(a));
    }

    private void COS(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.cos(a));
    }

    private void TAN(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.tan(a));
    }

    private void CTAN(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.ctan(a));
    }

    private void SEC(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.sec(a));
    }

    private void COSEC(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.cosec(a));
    }

    private void ASIN(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.asin(a));
    }

    private void ACOS(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.acos(a));
    }

    private void ATAN(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.atan(a));
    }

    private void ACTAN(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.actan(a));
    }

    private void LN(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.ln(a));
    }

    private void LOG2(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.log2(a));
    }

    private void LOG10(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.log10(a));
    }

    private void RAD(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.rad(a));
    }

    private void EXP(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.exp(a));
    }

    private void SQRT(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.sqrt(a));
    }

    private void SINH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.sinh(a));
    }

    private void COSH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.cosh(a));
    }

    private void TANH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.tanh(a));
    }

    private void COTH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.coth(a));
    }

    private void SECH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.sech(a));
    }

    private void CSCH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.csch(a));
    }

    private void DEG(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.deg(a));
    }

    private void ABS(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.abs(a));
    }

    private void SGN(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.sgn(a));
    }

    private void FLOOR(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.floor(a));
    }

    private void CEIL(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.ceil(a));
    }

    private void ARSINH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.arsinh(a));
    }

    private void ARCOSH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.arcosh(a));
    }

    private void ARTANH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.artanh(a));
    }

    private void ARCOTH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.arcoth(a));
    }

    private void ARSECH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.arsech(a));
    }

    private void ARCSCH(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.arcsch(a));
    }

    private void SA(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.sa(a));
    }

    private void SINC(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.sinc(a));
    }

    private void BELL_NUMBER(int pos) {
        double n = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.bellNumber(n));
    }

    private void LUCAS_NUMBER(int pos) {
        double n = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.lucasNumber(n));
    }

    private void FIBONACCI_NUMBER(int pos) {
        double n = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.fibonacciNumber(n));
    }

    private void HARMONIC_NUMBER(int pos) {
        double n = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.harmonicNumber(n));
    }

    private void IS_PRIME(int pos) {
        double n = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, NumberTheory.primeTest(n));
    }

    private void PRIME_COUNT(int pos) {
        double n = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, NumberTheory.primeCount(n));
    }

    private void EXP_INT(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.exponentialIntegralEi(x));
    }

    private void LOG_INT(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.logarithmicIntegralLi(x));
    }

    private void OFF_LOG_INT(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.offsetLogarithmicIntegralLi(x));
    }

    private void FACT(int pos) {
        double a = this.getTokenValue(pos - 1);
        this.setToNumber(pos, MathFunctions.factorial(a));
        this.tokensList.remove(pos - 1);
    }

    private void NOT(int pos) {
        double a = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, BooleanAlgebra.not(a));
    }

    private void GAUSS_ERF(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.erf(x));
    }

    private void GAUSS_ERFC(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.erfc(x));
    }

    private void GAUSS_ERF_INV(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.erfInv(x));
    }

    private void GAUSS_ERFC_INV(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, SpecialFunctions.erfcInv(x));
    }

    private void ULP(int pos) {
        double x = this.getTokenValue(pos + 1);
        this.f1SetDecreaseRemove(pos, MathFunctions.ulp(x));
    }

    private void LOG(int pos) {
        double b = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.log(a, b));
    }

    private ArrayList<Double> getNumbers(int pos) {
        ArrayList<Double> numbers = new ArrayList<Double>();
        int pn = pos;
        int lastIndex = this.tokensList.size() - 1;
        boolean end = false;
        do {
            Token t = this.tokensList.get(++pn);
            boolean isNumber = false;
            if (t.tokenTypeId == 0 && t.tokenId == 1) {
                isNumber = true;
                numbers.add(t.tokenValue);
            }
            if (pn != lastIndex && isNumber) continue;
            end = true;
        } while (!end);
        return numbers;
    }

    private void MOD(int pos) {
        double a = this.getTokenValue(pos + 1);
        double b = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.mod(a, b));
    }

    private void BINOM_COEFF(int pos) {
        double a = this.getTokenValue(pos + 1);
        double b = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.binomCoeff(a, b));
    }

    private void BERNOULLI_NUMBER(int pos) {
        double m = this.getTokenValue(pos + 1);
        double n = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.bernoulliNumber(m, n));
    }

    private void STIRLING1_NUMBER(int pos) {
        double n = this.getTokenValue(pos + 1);
        double k = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.Srirling1Number(n, k));
    }

    private void STIRLING2_NUMBER(int pos) {
        double n = this.getTokenValue(pos + 1);
        double k = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.Srirling2Number(n, k));
    }

    private void WORPITZKY_NUMBER(int pos) {
        double n = this.getTokenValue(pos + 1);
        double k = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.worpitzkyNumber(n, k));
    }

    private void EULER_NUMBER(int pos) {
        double n = this.getTokenValue(pos + 1);
        double k = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.eulerNumber(n, k));
    }

    private void KRONECKER_DELTA(int pos) {
        double i = this.getTokenValue(pos + 1);
        double j = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.kroneckerDelta(i, j));
    }

    private void EULER_POLYNOMIAL(int pos) {
        double m = this.getTokenValue(pos + 1);
        double x = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.eulerPolynomial(m, x));
    }

    private void HARMONIC2_NUMBER(int pos) {
        double x = this.getTokenValue(pos + 1);
        double n = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.harmonicNumber(x, n));
    }

    private void ROUND(int pos) {
        double value = this.getTokenValue(pos + 1);
        int places = (int)this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, MathFunctions.round(value, places));
    }

    private void RND_VAR_UNIFORM_CONT(int pos) {
        double a = this.getTokenValue(pos + 1);
        double b = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, ProbabilityDistributions.rndUniformContinuous(a, b, ProbabilityDistributions.randomGenerator));
    }

    private void RND_VAR_UNIFORM_DISCR(int pos) {
        int a = (int)this.getTokenValue(pos + 1);
        int b = (int)this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, ProbabilityDistributions.rndInteger(a, b, ProbabilityDistributions.randomGenerator));
    }

    private void RND_NORMAL(int pos) {
        double mean = this.getTokenValue(pos + 1);
        double stddev = this.getTokenValue(pos + 2);
        this.f2SetDecreaseRemove(pos, ProbabilityDistributions.rndNormal(mean, stddev, ProbabilityDistributions.randomGenerator));
    }

    private void IF_CONDITION(int pos) {
        ArrayList<FunctionParameter> ifParams = this.getFunctionParameters(pos, this.tokensList);
        FunctionParameter ifParam = ifParams.get(0);
        Expression ifExp = new Expression(ifParam.paramStr, ifParam.tokens, this.argumentsList, this.functionsList, this.constantsList, false);
        if (this.verboseMode) {
            ifExp.setVerboseMode();
        }
        this.ifSetRemove(pos, ifExp.calculate());
    }

    private void IFF(int pos) {
        ArrayList<FunctionParameter> iffParams = this.getFunctionParameters(pos, this.tokensList);
        FunctionParameter iffParam = iffParams.get(0);
        int parametersNumber = iffParams.size();
        int paramNumber = 1;
        double iffValue = 0.0;
        boolean iffCon = true;
        do {
            Expression iffExp = new Expression(iffParam.paramStr, iffParam.tokens, this.argumentsList, this.functionsList, this.constantsList, false);
            if (this.verboseMode) {
                iffExp.setVerboseMode();
            }
            iffCon = true;
            iffValue = iffExp.calculate();
            if (iffValue != 0.0 && !Double.isNaN(iffValue)) continue;
            iffCon = false;
            if ((paramNumber += 2) >= parametersNumber) continue;
            iffParam = iffParams.get(paramNumber - 1);
        } while (!iffCon && paramNumber < parametersNumber);
        if (iffCon) {
            int p;
            int trueParamNumber = paramNumber + 1;
            int from = pos + 1;
            int to = iffParams.get((int)(parametersNumber - 1)).toIndex + 1;
            --this.tokensList.get((int)from).tokenLevel;
            --this.tokensList.get((int)to).tokenLevel;
            if (trueParamNumber < parametersNumber) {
                to = iffParams.get((int)(parametersNumber - 1)).toIndex;
                from = iffParams.get((int)trueParamNumber).fromIndex - 1;
                for (p = to; p >= from; --p) {
                    this.tokensList.remove(p);
                }
            }
            from = iffParams.get((int)(trueParamNumber - 1)).fromIndex;
            to = iffParams.get((int)(trueParamNumber - 1)).toIndex;
            for (p = from; p <= to; ++p) {
                --this.tokensList.get((int)p).tokenLevel;
            }
            to = from - 1;
            from = pos;
            for (p = to; p >= from; --p) {
                if (p == pos + 1) continue;
                this.tokensList.remove(p);
            }
        } else {
            int to = iffParams.get((int)(parametersNumber - 1)).toIndex + 1;
            int from = pos + 1;
            for (int p = to; p >= from; --p) {
                this.tokensList.remove(p);
            }
            this.setToNumber(pos, Double.NaN);
            --this.tokensList.get((int)pos).tokenLevel;
        }
    }

    private void IF(int pos) {
        double ifFalse;
        double ifCondition = this.tokensList.get((int)(pos + 1)).tokenValue;
        double ifTrue = this.tokensList.get((int)(pos + 2)).tokenValue;
        double result = ifFalse = this.tokensList.get((int)(pos + 3)).tokenValue;
        if (ifCondition != 0.0) {
            result = ifTrue;
        }
        if (ifCondition == Double.NaN) {
            result = Double.NaN;
        }
        this.f3SetDecreaseRemove(pos, result);
    }

    private void CHI(int pos) {
        double x = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, MathFunctions.chi(x, a, b));
    }

    private void CHI_LR(int pos) {
        double x = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, MathFunctions.chi_LR(x, a, b));
    }

    private void CHI_L(int pos) {
        double x = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, MathFunctions.chi_L(x, a, b));
    }

    private void CHI_R(int pos) {
        double x = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, MathFunctions.chi_R(x, a, b));
    }

    private void PDF_UNIFORM_CONT(int pos) {
        double x = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, ProbabilityDistributions.pdfUniformContinuous(x, a, b));
    }

    private void CDF_UNIFORM_CONT(int pos) {
        double x = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, ProbabilityDistributions.cdfUniformContinuous(x, a, b));
    }

    private void QNT_UNIFORM_CONT(int pos) {
        double q = this.getTokenValue(pos + 1);
        double a = this.getTokenValue(pos + 2);
        double b = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, ProbabilityDistributions.qntUniformContinuous(q, a, b));
    }

    private void PDF_NORMAL(int pos) {
        double x = this.getTokenValue(pos + 1);
        double mean = this.getTokenValue(pos + 2);
        double stddev = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, ProbabilityDistributions.pdfNormal(x, mean, stddev));
    }

    private void CDF_NORMAL(int pos) {
        double x = this.getTokenValue(pos + 1);
        double mean = this.getTokenValue(pos + 2);
        double stddev = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, ProbabilityDistributions.cdfNormal(x, mean, stddev));
    }

    private void QNT_NORMAL(int pos) {
        double q = this.getTokenValue(pos + 1);
        double mean = this.getTokenValue(pos + 2);
        double stddev = this.getTokenValue(pos + 3);
        this.f3SetDecreaseRemove(pos, ProbabilityDistributions.qntNormal(q, mean, stddev));
    }

    private void updateMissingTokens(ArrayList<Token> tokens, String keyWord, int tokenId, int tokenTypeId) {
        for (Token t : tokens) {
            if (t.tokenTypeId != -1 || !t.tokenStr.equals(keyWord)) continue;
            t.keyWord = keyWord;
            t.tokenId = tokenId;
            t.tokenTypeId = tokenTypeId;
        }
    }

    private void updateMissingTokens(ArgumentParameter index, IterativeOperatorParameters iterParams) {
        if (index.presence == -1) {
            this.updateMissingTokens(iterParams.indexParam.tokens, iterParams.indexParam.paramStr, index.index, 101);
            this.updateMissingTokens(iterParams.fromParam.tokens, iterParams.indexParam.paramStr, index.index, 101);
            this.updateMissingTokens(iterParams.toParam.tokens, iterParams.indexParam.paramStr, index.index, 101);
            this.updateMissingTokens(iterParams.funParam.tokens, iterParams.indexParam.paramStr, index.index, 101);
        }
    }

    private void evalFromToDeltaParameters(ArgumentParameter index, IterativeOperatorParameters iterParams) {
        iterParams.fromExp = new Expression(iterParams.fromParam.paramStr, iterParams.fromParam.tokens, this.argumentsList, this.functionsList, this.constantsList, false);
        iterParams.toExp = new Expression(iterParams.toParam.paramStr, iterParams.toParam.tokens, this.argumentsList, this.functionsList, this.constantsList, false);
        iterParams.funExp = new Expression(iterParams.funParam.paramStr, iterParams.funParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true);
        iterParams.deltaExp = null;
        if (this.verboseMode) {
            iterParams.fromExp.setVerboseMode();
            iterParams.toExp.setVerboseMode();
            iterParams.funExp.setVerboseMode();
        }
        iterParams.from = iterParams.fromExp.calculate();
        iterParams.to = iterParams.toExp.calculate();
        iterParams.delta = 1.0;
        if (iterParams.to < iterParams.from) {
            iterParams.delta = -1.0;
        }
        if (iterParams.withDelta) {
            iterParams.deltaExp = new Expression(iterParams.deltaParam.paramStr, iterParams.deltaParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true);
            if (index.presence == -1) {
                this.updateMissingTokens(iterParams.deltaParam.tokens, iterParams.indexParam.paramStr, index.index, 101);
            }
            if (this.verboseMode) {
                iterParams.deltaExp.setVerboseMode();
            }
            iterParams.delta = iterParams.deltaExp.calculate();
        }
    }

    private void SUM(int pos) {
        IterativeOperatorParameters iterParams = new IterativeOperatorParameters(this.getFunctionParameters(pos, this.tokensList));
        ArgumentParameter index = this.getParamArgument(iterParams.indexParam.paramStr);
        this.updateMissingTokens(index, iterParams);
        this.evalFromToDeltaParameters(index, iterParams);
        double sigma = NumberTheory.sigmaSummation(iterParams.funExp, index.argument, iterParams.from, iterParams.to, iterParams.delta);
        this.clearParamArgument(index);
        this.calcSetDecreaseRemove(pos, sigma, true);
    }

    private void PROD(int pos) {
        IterativeOperatorParameters iterParams = new IterativeOperatorParameters(this.getFunctionParameters(pos, this.tokensList));
        ArgumentParameter index = this.getParamArgument(iterParams.indexParam.paramStr);
        this.updateMissingTokens(index, iterParams);
        this.evalFromToDeltaParameters(index, iterParams);
        double product = NumberTheory.piProduct(iterParams.funExp, index.argument, iterParams.from, iterParams.to, iterParams.delta);
        this.clearParamArgument(index);
        this.calcSetDecreaseRemove(pos, product, true);
    }

    private void MIN(int pos) {
        IterativeOperatorParameters iterParams = new IterativeOperatorParameters(this.getFunctionParameters(pos, this.tokensList));
        ArgumentParameter index = this.getParamArgument(iterParams.indexParam.paramStr);
        this.updateMissingTokens(index, iterParams);
        this.evalFromToDeltaParameters(index, iterParams);
        double min = NumberTheory.min(iterParams.funExp, index.argument, iterParams.from, iterParams.to, iterParams.delta);
        this.clearParamArgument(index);
        this.calcSetDecreaseRemove(pos, min);
    }

    private void MAX(int pos) {
        IterativeOperatorParameters iterParams = new IterativeOperatorParameters(this.getFunctionParameters(pos, this.tokensList));
        ArgumentParameter index = this.getParamArgument(iterParams.indexParam.paramStr);
        this.updateMissingTokens(index, iterParams);
        this.evalFromToDeltaParameters(index, iterParams);
        double max = NumberTheory.max(iterParams.funExp, index.argument, iterParams.from, iterParams.to, iterParams.delta);
        this.clearParamArgument(index);
        this.calcSetDecreaseRemove(pos, max);
    }

    private void AVG(int pos) {
        IterativeOperatorParameters iterParams = new IterativeOperatorParameters(this.getFunctionParameters(pos, this.tokensList));
        ArgumentParameter index = this.getParamArgument(iterParams.indexParam.paramStr);
        this.updateMissingTokens(index, iterParams);
        this.evalFromToDeltaParameters(index, iterParams);
        double avg = Statistics.avg(iterParams.funExp, index.argument, iterParams.from, iterParams.to, iterParams.delta);
        this.clearParamArgument(index);
        this.calcSetDecreaseRemove(pos, avg, true);
    }

    private void VAR(int pos) {
        IterativeOperatorParameters iterParams = new IterativeOperatorParameters(this.getFunctionParameters(pos, this.tokensList));
        ArgumentParameter index = this.getParamArgument(iterParams.indexParam.paramStr);
        this.updateMissingTokens(index, iterParams);
        this.evalFromToDeltaParameters(index, iterParams);
        double var = Statistics.var(iterParams.funExp, index.argument, iterParams.from, iterParams.to, iterParams.delta);
        this.clearParamArgument(index);
        this.calcSetDecreaseRemove(pos, var, true);
    }

    private void STD(int pos) {
        IterativeOperatorParameters iterParams = new IterativeOperatorParameters(this.getFunctionParameters(pos, this.tokensList));
        ArgumentParameter index = this.getParamArgument(iterParams.indexParam.paramStr);
        this.updateMissingTokens(index, iterParams);
        this.evalFromToDeltaParameters(index, iterParams);
        double std = Statistics.std(iterParams.funExp, index.argument, iterParams.from, iterParams.to, iterParams.delta);
        this.clearParamArgument(index);
        this.calcSetDecreaseRemove(pos, std, true);
    }

    private void DERIVATIVE(int pos, int derivativeType) {
        ArrayList<FunctionParameter> derParams = this.getFunctionParameters(pos, this.tokensList);
        double DEF_EPS = 1.0E-8;
        int DEF_MAX_STEPS = 20;
        FunctionParameter funParam = derParams.get(0);
        FunctionParameter xParam = derParams.get(1);
        ArgumentParameter x = this.getParamArgument(xParam.paramStr);
        if (x.presence == -1) {
            this.updateMissingTokens(xParam.tokens, xParam.paramStr, x.index, 101);
            this.updateMissingTokens(funParam.tokens, xParam.paramStr, x.index, 101);
        }
        Expression funExp = new Expression(funParam.paramStr, funParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true);
        double x0 = x.argument.getArgumentValue();
        double eps = 1.0E-8;
        int maxSteps = 20;
        if (derParams.size() == 4) {
            FunctionParameter epsParam = derParams.get(2);
            FunctionParameter maxStepsParam = derParams.get(3);
            if (x.presence == -1) {
                this.updateMissingTokens(epsParam.tokens, xParam.paramStr, x.index, 101);
                this.updateMissingTokens(maxStepsParam.tokens, xParam.paramStr, x.index, 101);
            }
            Expression epsExpr = new Expression(epsParam.paramStr, epsParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true);
            Expression maxStepsExp = new Expression(maxStepsParam.paramStr, maxStepsParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true);
            eps = epsExpr.calculate();
            maxSteps = (int)Math.round(maxStepsExp.calculate());
        }
        if (derivativeType == 3) {
            double general = Calculus.derivative(funExp, x.argument, x0, 3, eps, maxSteps);
            this.calcSetDecreaseRemove(pos, general);
        } else if (derivativeType == 1) {
            double left = Calculus.derivative(funExp, x.argument, x0, 1, eps, maxSteps);
            this.calcSetDecreaseRemove(pos, left);
        } else {
            double right = Calculus.derivative(funExp, x.argument, x0, 2, eps, maxSteps);
            this.calcSetDecreaseRemove(pos, right);
        }
        this.clearParamArgument(x);
    }

    private void DERIVATIVE_NTH(int pos, int derivativeType) {
        double DEF_EPS = 1.0E-6;
        int DEF_MAX_STEPS = 20;
        ArrayList<FunctionParameter> derParams = this.getFunctionParameters(pos, this.tokensList);
        FunctionParameter funParam = derParams.get(0);
        FunctionParameter nParam = derParams.get(1);
        FunctionParameter xParam = derParams.get(2);
        ArgumentParameter x = this.getParamArgument(xParam.paramStr);
        if (x.presence == -1) {
            this.updateMissingTokens(xParam.tokens, xParam.paramStr, x.index, 101);
            this.updateMissingTokens(funParam.tokens, xParam.paramStr, x.index, 101);
            this.updateMissingTokens(nParam.tokens, xParam.paramStr, x.index, 101);
        }
        Expression funExp = new Expression(funParam.paramStr, funParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true);
        Expression nExp = new Expression(nParam.paramStr, nParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true);
        double n = nExp.calculate();
        double x0 = x.argument.getArgumentValue();
        double eps = 1.0E-6;
        int maxSteps = 20;
        if (derParams.size() == 5) {
            FunctionParameter epsParam = derParams.get(3);
            FunctionParameter maxStepsParam = derParams.get(4);
            if (x.presence == -1) {
                this.updateMissingTokens(epsParam.tokens, xParam.paramStr, x.index, 101);
                this.updateMissingTokens(maxStepsParam.tokens, xParam.paramStr, x.index, 101);
            }
            Expression epsExpr = new Expression(epsParam.paramStr, epsParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true);
            Expression maxStepsExp = new Expression(maxStepsParam.paramStr, maxStepsParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true);
            eps = epsExpr.calculate();
            maxSteps = (int)Math.round(maxStepsExp.calculate());
        }
        if (derivativeType == 3) {
            double left = Calculus.derivativeNth(funExp, n, x.argument, x0, 1, eps, maxSteps);
            double right = Calculus.derivativeNth(funExp, n, x.argument, x0, 2, eps, maxSteps);
            this.calcSetDecreaseRemove(pos, (left + right) / 2.0);
        } else if (derivativeType == 1) {
            double left = Calculus.derivativeNth(funExp, n, x.argument, x0, 1, eps, maxSteps);
            this.calcSetDecreaseRemove(pos, left);
        } else {
            double right = Calculus.derivativeNth(funExp, n, x.argument, x0, 2, eps, maxSteps);
            this.calcSetDecreaseRemove(pos, right);
        }
        this.clearParamArgument(x);
    }

    private void INTEGRAL(int pos) {
        double DEF_EPS = 1.0E-6;
        int DEF_MAX_STEPS = 20;
        ArrayList<FunctionParameter> intParams = this.getFunctionParameters(pos, this.tokensList);
        FunctionParameter funParam = intParams.get(0);
        FunctionParameter xParam = intParams.get(1);
        FunctionParameter aParam = intParams.get(2);
        FunctionParameter bParam = intParams.get(3);
        ArgumentParameter x = this.getParamArgument(xParam.paramStr);
        if (x.presence == -1) {
            this.updateMissingTokens(xParam.tokens, xParam.paramStr, x.index, 101);
            this.updateMissingTokens(funParam.tokens, xParam.paramStr, x.index, 101);
            this.updateMissingTokens(aParam.tokens, xParam.paramStr, x.index, 101);
            this.updateMissingTokens(bParam.tokens, xParam.paramStr, x.index, 101);
        }
        Expression funExp = new Expression(funParam.paramStr, funParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true);
        Expression aExp = new Expression(aParam.paramStr, aParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true);
        Expression bExp = new Expression(bParam.paramStr, bParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true);
        double eps = 1.0E-6;
        int maxSteps = 20;
        this.calcSetDecreaseRemove(pos, Calculus.integralTrapezoid(funExp, x.argument, aExp.calculate(), bExp.calculate(), eps, maxSteps));
        this.clearParamArgument(x);
    }

    private void SOLVE(int pos) {
        double DEF_EPS = 1.0E-9;
        int DEF_MAX_STEPS = 100;
        ArrayList<FunctionParameter> intParams = this.getFunctionParameters(pos, this.tokensList);
        FunctionParameter funParam = intParams.get(0);
        FunctionParameter xParam = intParams.get(1);
        FunctionParameter aParam = intParams.get(2);
        FunctionParameter bParam = intParams.get(3);
        ArgumentParameter x = this.getParamArgument(xParam.paramStr);
        if (x.presence == -1) {
            this.updateMissingTokens(xParam.tokens, xParam.paramStr, x.index, 101);
            this.updateMissingTokens(funParam.tokens, xParam.paramStr, x.index, 101);
            this.updateMissingTokens(aParam.tokens, xParam.paramStr, x.index, 101);
            this.updateMissingTokens(bParam.tokens, xParam.paramStr, x.index, 101);
        }
        Expression funExp = new Expression(funParam.paramStr, funParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true);
        Expression aExp = new Expression(aParam.paramStr, aParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true);
        Expression bExp = new Expression(bParam.paramStr, bParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true);
        double eps = 1.0E-9;
        int maxSteps = 100;
        this.calcSetDecreaseRemove(pos, Calculus.solveBrent(funExp, x.argument, aExp.calculate(), bExp.calculate(), eps, maxSteps));
        this.clearParamArgument(x);
    }

    private void FORWARD_DIFFERENCE(int pos) {
        ArrayList<FunctionParameter> params = this.getFunctionParameters(pos, this.tokensList);
        FunctionParameter funParam = params.get(0);
        FunctionParameter xParam = params.get(1);
        ArgumentParameter x = this.getParamArgument(xParam.paramStr);
        Expression funExp = new Expression(funParam.paramStr, funParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true);
        if (this.verboseMode) {
            funExp.setVerboseMode();
        }
        double h = 1.0;
        if (params.size() == 3) {
            FunctionParameter hParam = params.get(2);
            Expression hExp = new Expression(hParam.paramStr, hParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true);
            if (this.verboseMode) {
                hExp.setVerboseMode();
            }
            h = hExp.calculate();
        }
        this.calcSetDecreaseRemove(pos, Calculus.forwardDifference(funExp, h, x.argument));
        this.clearParamArgument(x);
    }

    private void BACKWARD_DIFFERENCE(int pos) {
        ArrayList<FunctionParameter> params = this.getFunctionParameters(pos, this.tokensList);
        FunctionParameter funParam = params.get(0);
        FunctionParameter xParam = params.get(1);
        ArgumentParameter x = this.getParamArgument(xParam.paramStr);
        Expression funExp = new Expression(funParam.paramStr, funParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true);
        if (this.verboseMode) {
            funExp.setVerboseMode();
        }
        double h = 1.0;
        if (params.size() == 3) {
            FunctionParameter hParam = params.get(2);
            Expression hExp = new Expression(hParam.paramStr, hParam.tokens, this.argumentsList, this.functionsList, this.constantsList, true);
            if (this.verboseMode) {
                hExp.setVerboseMode();
            }
            h = hExp.calculate();
        }
        this.calcSetDecreaseRemove(pos, Calculus.backwardDifference(funExp, h, x.argument));
        this.clearParamArgument(x);
    }

    private void MIN_VARIADIC(int pos) {
        ArrayList<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.min(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void MAX_VARIADIC(int pos) {
        ArrayList<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.max(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void SUM_VARIADIC(int pos) {
        ArrayList<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.sum(mXparser.arrayList2double(numbers)), numbers.size(), true);
    }

    private void PROD_VARIADIC(int pos) {
        ArrayList<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.prod(mXparser.arrayList2double(numbers)), numbers.size(), true);
    }

    private void AVG_VARIADIC(int pos) {
        ArrayList<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, Statistics.avg(mXparser.arrayList2double(numbers)), numbers.size(), true);
    }

    private void VAR_VARIADIC(int pos) {
        ArrayList<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, Statistics.var(mXparser.arrayList2double(numbers)), numbers.size(), true);
    }

    private void STD_VARIADIC(int pos) {
        ArrayList<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, Statistics.std(mXparser.arrayList2double(numbers)), numbers.size(), true);
    }

    private void CONTINUED_FRACTION(int pos) {
        ArrayList<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, MathFunctions.continuedFraction(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void CONTINUED_POLYNOMIAL(int pos) {
        ArrayList<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, MathFunctions.continuedPolynomial(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void GCD(int pos) {
        ArrayList<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.gcd(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void LCM(int pos) {
        ArrayList<Double> numbers = this.getNumbers(pos);
        this.variadicSetDecreaseRemove(pos, NumberTheory.lcm(mXparser.arrayList2double(numbers)), numbers.size());
    }

    private void RND_LIST(int pos) {
        ArrayList<Double> numbers = this.getNumbers(pos);
        int n = numbers.size();
        int i = ProbabilityDistributions.rndIndex(n, ProbabilityDistributions.randomGenerator);
        this.variadicSetDecreaseRemove(pos, numbers.get(i), numbers.size());
    }

    private void COMMA(int pos) {
        this.tokensList.remove(pos);
    }

    private void PARENTHESES(int lPos, int rPos) {
        for (int p = lPos; p <= rPos; ++p) {
            --this.tokensList.get((int)p).tokenLevel;
        }
        this.tokensList.remove(rPos);
        this.tokensList.remove(lPos);
    }

    public boolean checkLexSyntax() {
        boolean syntax = true;
        SyntaxChecker syn = new SyntaxChecker(new ByteArrayInputStream(this.expressionString.getBytes()));
        try {
            syn.checkSyntax();
        }
        catch (Exception e) {
            syntax = false;
            this.errorMessage = "lexical error \n\n" + e.getMessage() + "\n";
        }
        return syntax;
    }

    public boolean checkSyntax() {
        boolean syntax = this.checkSyntax("[" + this.expressionString + "] ", false);
        return syntax;
    }

    private int checkCalculusParameter(String param) {
        int errors = 0;
        for (KeyWord kw : this.keyWordsList) {
            if (kw.wordTypeId == 101 || !param.equals(kw.wordString)) continue;
            ++errors;
        }
        return errors;
    }

    private boolean checkIfKnownArgument(FunctionParameter param) {
        if (param.tokens.size() > 1) {
            return false;
        }
        Token t = param.tokens.get(0);
        return t.tokenTypeId == 101;
    }

    private boolean checkIfUnknownToken(FunctionParameter param) {
        if (param.tokens.size() > 1) {
            return false;
        }
        Token t = param.tokens.get(0);
        return t.tokenTypeId == -1;
    }

    private boolean checkSyntax(String level, boolean functionWithBodyExt) {
        if (!this.expressionWasModified && this.syntaxStatus) {
            this.errorMessage = level + "already checked - no errors!\n";
            this.recursionCallPending = false;
            return true;
        }
        if (functionWithBodyExt) {
            this.syntaxStatus = true;
            this.recursionCallPending = false;
            this.expressionWasModified = false;
            this.errorMessage = this.errorMessage + level + "function with extended body - assuming no errors.\n";
            return true;
        }
        this.recursionCallPending = true;
        this.errorMessage = level + "checking ...\n";
        boolean syntax = true;
        SyntaxChecker syn = new SyntaxChecker(new ByteArrayInputStream(this.expressionString.getBytes()));
        try {
            syn.checkSyntax();
            this.tokenizeExpressionString();
            Collections.sort(this.keyWordsList, new KwStrComparator());
            for (int kwId = 1; kwId < this.keyWordsList.size(); ++kwId) {
                String kw1 = this.keyWordsList.get((int)(kwId - 1)).wordString;
                String kw2 = this.keyWordsList.get((int)kwId).wordString;
                if (!kw1.equals(kw2)) continue;
                syntax = false;
                this.errorMessage = this.errorMessage + level + "(" + kw1 + ") Duplicated <KEYWORD>.\n";
            }
            int tokensNumber = this.initialTokens.size();
            Stack<SyntaxStackElement> syntaxStack = new Stack<SyntaxStackElement>();
            for (int tokenIndex = 0; tokenIndex < tokensNumber; ++tokenIndex) {
                boolean syntaxRec;
                Argument arg;
                Token t = this.initialTokens.get(tokenIndex);
                String tokenStr = "(" + t.tokenStr + ", " + tokenIndex + ") ";
                if (t.tokenTypeId == 101 && (arg = this.getArgument(t.tokenId)).getArgumentType() == 2) {
                    if (this.getParametersNumber(tokenIndex) >= 0) {
                        syntax = false;
                        this.errorMessage = this.errorMessage + level + tokenStr + "<ARGUMENT> was expected.\n";
                    } else if (arg.argumentExpression != this && !arg.argumentExpression.recursionCallPending) {
                        syntaxRec = arg.argumentExpression.checkSyntax(level + "-> " + "[" + t.tokenStr + "] = [" + arg.argumentExpression.getExpressionString() + "] ", false);
                        syntax = syntax && syntaxRec;
                        this.errorMessage = this.errorMessage + level + tokenStr + "checking dependent argument ...\n" + arg.argumentExpression.getErrorMessage();
                    }
                }
                if (t.tokenTypeId == 102) {
                    arg = this.getArgument(t.tokenId);
                    if (this.getParametersNumber(tokenIndex) != 1) {
                        syntax = false;
                        this.errorMessage = this.errorMessage + level + tokenStr + "<RECURSIVE_ARGUMENT> expecting 1 parameter.\n";
                    } else if (arg.argumentExpression != this && !arg.argumentExpression.recursionCallPending) {
                        syntaxRec = arg.argumentExpression.checkSyntax(level + "-> " + "[" + t.tokenStr + "] = [" + arg.argumentExpression.getExpressionString() + "] ", false);
                        syntax = syntax && syntaxRec;
                        this.errorMessage = this.errorMessage + level + tokenStr + "checking recursive argument ...\n" + arg.argumentExpression.getErrorMessage();
                    }
                }
                if (t.tokenTypeId == -1) {
                    boolean calculusToken = false;
                    for (SyntaxStackElement e : syntaxStack) {
                        if (!e.tokenStr.equals(t.tokenStr)) continue;
                        calculusToken = true;
                    }
                    if (!calculusToken) {
                        syntax = false;
                        this.errorMessage = this.errorMessage + level + tokenStr + "invalid <TOKEN>.\n";
                    }
                }
                if (t.tokenTypeId == 103) {
                    Function fun = this.getFunction(t.tokenId);
                    fun.checkRecursiveMode();
                    if (fun.getParametersNumber() != this.getParametersNumber(tokenIndex)) {
                        syntax = false;
                        this.errorMessage = this.errorMessage + level + tokenStr + "<USER_DEFINED_FUNCTION> expecting " + fun.getParametersNumber() + " arguments.\n";
                    } else if (fun.functionExpression != this && !fun.functionExpression.recursionCallPending) {
                        boolean syntaxRec2 = fun.getFunctionBodyType() == 1 ? fun.functionExpression.checkSyntax(level + "-> " + "[" + t.tokenStr + "] = [" + fun.functionExpression.getExpressionString() + "] ", false) : fun.functionExpression.checkSyntax(level + "-> " + "[" + t.tokenStr + "] = [" + fun.functionExpression.getExpressionString() + "] ", true);
                        syntax = syntax && syntaxRec2;
                        this.errorMessage = this.errorMessage + level + tokenStr + "checking user defined function ...\n" + fun.functionExpression.getErrorMessage();
                    }
                }
                if (t.tokenTypeId == 9 && this.getParametersNumber(tokenIndex) >= 0) {
                    syntax = false;
                    this.errorMessage = this.errorMessage + level + tokenStr + "<CONSTANT> was expected.\n";
                }
                if (t.tokenTypeId == 104 && this.getParametersNumber(tokenIndex) >= 0) {
                    syntax = false;
                    this.errorMessage = this.errorMessage + level + tokenStr + "<USER_DEFINED_CONSTANT> was expected.\n";
                }
                if (t.tokenTypeId == 4 && this.getParametersNumber(tokenIndex) != 1) {
                    syntax = false;
                    this.errorMessage = this.errorMessage + level + tokenStr + "<FUNCTION> expecting 1 argument.\n";
                }
                if (t.tokenTypeId == 5 && this.getParametersNumber(tokenIndex) != 2) {
                    syntax = false;
                    this.errorMessage = this.errorMessage + level + tokenStr + "<FUNCTION> expecting 2 arguments.\n";
                }
                if (t.tokenTypeId == 6 && this.getParametersNumber(tokenIndex) != 3) {
                    syntax = false;
                    this.errorMessage = this.errorMessage + level + tokenStr + "<FUNCTION> expecting 3 arguments.\n";
                }
                if (t.tokenTypeId == 8) {
                    int errors;
                    SyntaxStackElement stackElement;
                    FunctionParameter argParam;
                    int paramsNumber = this.getParametersNumber(tokenIndex);
                    ArrayList<FunctionParameter> funParams = null;
                    if (paramsNumber > 0) {
                        funParams = this.getFunctionParameters(tokenIndex, this.initialTokens);
                    }
                    if (t.tokenId == 6 || t.tokenId == 7 || t.tokenId == 8) {
                        if (paramsNumber != 2 && paramsNumber != 4) {
                            syntax = false;
                            this.errorMessage = this.errorMessage + level + tokenStr + "<DERIVATIVE> expecting 2 or 4 calculus arguments.\n";
                        } else {
                            argParam = funParams.get(1);
                            if (!this.checkIfKnownArgument(argParam)) {
                                syntax = false;
                                this.errorMessage = this.errorMessage + level + tokenStr + "<DERIVATIVE> argument was expected.\n";
                            }
                        }
                    }
                    if (t.tokenId == 9) {
                        if (paramsNumber != 3 && paramsNumber != 5) {
                            syntax = false;
                            this.errorMessage = this.errorMessage + level + tokenStr + "<NTH_DERIVATIVE> expecting 3 or 5 calculus arguments.\n";
                        } else {
                            argParam = funParams.get(2);
                            if (!this.checkIfKnownArgument(argParam)) {
                                syntax = false;
                                this.errorMessage = this.errorMessage + level + tokenStr + "<DERIVATIVE> argument was expected.\n";
                            }
                        }
                    }
                    if (t.tokenId == 5 || t.tokenId == 17) {
                        if (paramsNumber != 4) {
                            syntax = false;
                            this.errorMessage = this.errorMessage + level + tokenStr + "<INTEGRAL/SOLVE> expecting 4 calculus arguments.\n";
                        } else {
                            argParam = funParams.get(1);
                            stackElement = new SyntaxStackElement(argParam.paramStr, t.tokenLevel + 1);
                            syntaxStack.push(stackElement);
                            errors = this.checkCalculusParameter(stackElement.tokenStr);
                            if (errors > 0) {
                                syntax = false;
                                this.errorMessage = this.errorMessage + level + tokenStr + "Found duplicated key words for calculus parameter " + "(" + stackElement.tokenStr + ", " + errors + ").\n";
                            }
                            if (!this.checkIfKnownArgument(argParam) && !this.checkIfUnknownToken(argParam)) {
                                syntax = false;
                                this.errorMessage = this.errorMessage + level + tokenStr + "One token (argument or unknown) was expected.\n";
                            }
                        }
                    }
                    if (t.tokenId == 3 || t.tokenId == 1 || t.tokenId == 15 || t.tokenId == 16 || t.tokenId == 12 || t.tokenId == 13 || t.tokenId == 14) {
                        if (paramsNumber != 4 && paramsNumber != 5) {
                            syntax = false;
                            this.errorMessage = this.errorMessage + level + tokenStr + "<ITER_OPERATOR> expecting 4 or 5 calculus arguments.\n";
                        } else {
                            FunctionParameter indexParam = funParams.get(0);
                            stackElement = new SyntaxStackElement(indexParam.paramStr, t.tokenLevel + 1);
                            syntaxStack.push(stackElement);
                            errors = this.checkCalculusParameter(stackElement.tokenStr);
                            if (errors > 0) {
                                syntax = false;
                                this.errorMessage = this.errorMessage + level + tokenStr + "Found duplicated key words for calculus parameter " + "(" + stackElement.tokenStr + ", " + errors + ").\n";
                            }
                            if (!this.checkIfKnownArgument(indexParam) && !this.checkIfUnknownToken(indexParam)) {
                                syntax = false;
                                this.errorMessage = this.errorMessage + level + tokenStr + "One token (argument or unknown) was expected.\n";
                            }
                        }
                    }
                    if (t.tokenId == 10 || t.tokenId == 11) {
                        if (paramsNumber != 2 && paramsNumber != 3) {
                            syntax = false;
                            this.errorMessage = this.errorMessage + level + tokenStr + "<DIFF> expecting 2 or 3 arguments.\n";
                        } else {
                            FunctionParameter xParam = funParams.get(1);
                            if (!this.checkIfKnownArgument(xParam)) {
                                syntax = false;
                                this.errorMessage = this.errorMessage + level + tokenStr + "<DIFF> argument was expected.\n";
                            }
                        }
                    }
                }
                if (t.tokenTypeId == 7) {
                    int paramsNumber = this.getParametersNumber(tokenIndex);
                    if (paramsNumber < 1) {
                        syntax = false;
                        this.errorMessage = this.errorMessage + level + tokenStr + "At least one argument was expected.\n";
                    }
                    if (t.tokenId == 1 && (paramsNumber % 2 != 0 || paramsNumber < 2)) {
                        syntax = false;
                        this.errorMessage = this.errorMessage + level + tokenStr + "Expecting parity number of arguments.\n";
                    }
                }
                if (t.tokenTypeId != 20 || t.tokenId != 2 || syntaxStack.size() <= 0 || t.tokenLevel != ((SyntaxStackElement)syntaxStack.lastElement()).tokenLevel) continue;
                syntaxStack.pop();
            }
        }
        catch (Exception e) {
            syntax = false;
            this.errorMessage = this.errorMessage + level + "lexical error \n\n" + e.getMessage() + "\n";
        }
        if (syntax) {
            this.errorMessage = this.errorMessage + level + "no errors.\n";
            this.expressionWasModified = false;
        } else {
            this.errorMessage = this.errorMessage + level + "errors were found.\n";
            this.expressionWasModified = true;
        }
        this.syntaxStatus = syntax;
        this.recursionCallPending = false;
        return syntax;
    }

    public double calculate() {
        this.computingTime = 0.0;
        long startTime = System.currentTimeMillis();
        if (this.verboseMode) {
            this.printSystemInfo("\n", false);
            this.printSystemInfo("\n", true);
            this.printSystemInfo("Starting ...\n", true);
            this.showArguments();
        }
        if (this.expressionWasModified || !this.syntaxStatus) {
            this.syntaxStatus = this.checkSyntax();
        }
        if (!this.syntaxStatus) {
            return Double.NaN;
        }
        this.copyInitialTokens();
        if (this.tokensList.size() == 0) {
            return Double.NaN;
        }
        ArrayList<Integer> commas = null;
        do {
            Token token;
            int tokensNumber = this.tokensList.size();
            int maxPartLevel = -1;
            int lPos = -1;
            int rPos = -1;
            int calculusPos = -1;
            int ifPos = -1;
            int iffPos = -1;
            int variadicFunPos = -1;
            int recArgPos = -1;
            int f3ArgPos = -1;
            int f2ArgPos = -1;
            int f1ArgPos = -1;
            int userFunPos = -1;
            int plusPos = -1;
            int minusPos = -1;
            int multiplyPos = -1;
            int dividePos = -1;
            int powerPos = -1;
            int factPos = -1;
            int modPos = -1;
            int powerNum = 0;
            int negPos = -1;
            int bolPos = -1;
            int eqPos = -1;
            int neqPos = -1;
            int ltPos = -1;
            int gtPos = -1;
            int leqPos = -1;
            int geqPos = -1;
            int commaPos = -1;
            int lParPos = -1;
            int rParPos = -1;
            int bitwisePos = -1;
            int bitwiseComplPos = -1;
            tokensNumber = this.tokensList.size();
            int p = -1;
            do {
                token = this.tokensList.get(++p);
                if (token.tokenTypeId != 8) continue;
                calculusPos = p;
            } while (p < tokensNumber - 1 && calculusPos < 0);
            if (calculusPos < 0) {
                p = -1;
                do {
                    token = this.tokensList.get(++p);
                    if (token.tokenTypeId != 6 || token.tokenId != 1) continue;
                    ifPos = p;
                } while (p < tokensNumber - 1 && ifPos < 0);
            }
            if (calculusPos < 0 && ifPos < 0) {
                p = -1;
                do {
                    token = this.tokensList.get(++p);
                    if (token.tokenTypeId != 7 || token.tokenId != 1) continue;
                    iffPos = p;
                } while (p < tokensNumber - 1 && iffPos < 0);
            }
            if (calculusPos < 0 && ifPos < 0 && iffPos < 0) {
                int tokenIndex;
                for (tokenIndex = 0; tokenIndex < tokensNumber; ++tokenIndex) {
                    token = this.tokensList.get(tokenIndex);
                    if (token.tokenLevel > maxPartLevel) {
                        maxPartLevel = this.tokensList.get((int)tokenIndex).tokenLevel;
                        lPos = tokenIndex;
                    }
                    if (token.tokenTypeId == 101) {
                        this.ARGUMENT(tokenIndex);
                        continue;
                    }
                    if (token.tokenTypeId == 9) {
                        this.CONSTANT(tokenIndex);
                        continue;
                    }
                    if (token.tokenTypeId == 12) {
                        this.UNIT(tokenIndex);
                        continue;
                    }
                    if (token.tokenTypeId == 104) {
                        this.USER_CONSTANT(tokenIndex);
                        continue;
                    }
                    if (token.tokenTypeId != 10) continue;
                    this.RANDOM_VARIABLE(tokenIndex);
                }
                for (tokenIndex = lPos; tokenIndex < tokensNumber && maxPartLevel == this.tokensList.get((int)tokenIndex).tokenLevel; ++tokenIndex) {
                }
                rPos = tokenIndex - 1;
                if (this.verboseMode) {
                    this.printSystemInfo("Parsing (" + lPos + ", " + rPos + ") ", true);
                    this.showParsing(lPos, rPos);
                }
                for (int pos = lPos; pos <= rPos; ++pos) {
                    boolean leftIsNUmber = false;
                    boolean rigthIsNUmber = false;
                    token = this.tokensList.get(pos);
                    if (pos - 1 >= 0) {
                        Token tokenL = this.tokensList.get(pos - 1);
                        if (tokenL.tokenTypeId == 0) {
                            leftIsNUmber = true;
                        }
                    }
                    if (pos + 1 < tokensNumber) {
                        Token tokenR = this.tokensList.get(pos + 1);
                        if (tokenR.tokenTypeId == 0) {
                            rigthIsNUmber = true;
                        }
                    }
                    if (token.tokenTypeId == 102 && recArgPos < 0) {
                        recArgPos = pos;
                        continue;
                    }
                    if (token.tokenTypeId == 7 && variadicFunPos < 0) {
                        variadicFunPos = pos;
                        continue;
                    }
                    if (token.tokenTypeId == 6 && f3ArgPos < 0) {
                        f3ArgPos = pos;
                        continue;
                    }
                    if (token.tokenTypeId == 5 && f2ArgPos < 0) {
                        f2ArgPos = pos;
                        continue;
                    }
                    if (token.tokenTypeId == 4 && f1ArgPos < 0) {
                        f1ArgPos = pos;
                        continue;
                    }
                    if (token.tokenTypeId == 103 && userFunPos < 0) {
                        userFunPos = pos;
                        continue;
                    }
                    if (token.tokenTypeId == 1) {
                        if (token.tokenId == 5 && leftIsNUmber && rigthIsNUmber) {
                            powerPos = pos;
                            ++powerNum;
                            continue;
                        }
                        if (token.tokenId == 6 && factPos < 0 && leftIsNUmber) {
                            factPos = pos;
                            continue;
                        }
                        if (token.tokenId == 7 && modPos < 0 && leftIsNUmber && rigthIsNUmber) {
                            modPos = pos;
                            continue;
                        }
                        if (token.tokenId == 1 && plusPos < 0 && leftIsNUmber && rigthIsNUmber) {
                            plusPos = pos;
                            continue;
                        }
                        if (token.tokenId == 2 && minusPos < 0 && rigthIsNUmber) {
                            minusPos = pos;
                            continue;
                        }
                        if (token.tokenId == 3 && multiplyPos < 0 && leftIsNUmber && rigthIsNUmber) {
                            multiplyPos = pos;
                            continue;
                        }
                        if (token.tokenId != 4 || dividePos >= 0 || !leftIsNUmber || !rigthIsNUmber) continue;
                        dividePos = pos;
                        continue;
                    }
                    if (token.tokenTypeId == 2 && token.tokenId == 11 && negPos < 0 && rigthIsNUmber) {
                        negPos = pos;
                        continue;
                    }
                    if (token.tokenTypeId == 2 && bolPos < 0 && leftIsNUmber && rigthIsNUmber) {
                        bolPos = pos;
                        continue;
                    }
                    if (token.tokenTypeId == 3) {
                        if (token.tokenId == 1 && eqPos < 0 && leftIsNUmber && rigthIsNUmber) {
                            eqPos = pos;
                            continue;
                        }
                        if (token.tokenId == 2 && neqPos < 0 && leftIsNUmber && rigthIsNUmber) {
                            neqPos = pos;
                            continue;
                        }
                        if (token.tokenId == 3 && ltPos < 0 && leftIsNUmber && rigthIsNUmber) {
                            ltPos = pos;
                            continue;
                        }
                        if (token.tokenId == 4 && gtPos < 0 && leftIsNUmber && rigthIsNUmber) {
                            gtPos = pos;
                            continue;
                        }
                        if (token.tokenId == 5 && leqPos < 0 && leftIsNUmber && rigthIsNUmber) {
                            leqPos = pos;
                            continue;
                        }
                        if (token.tokenId != 6 || geqPos >= 0 || !leftIsNUmber || !rigthIsNUmber) continue;
                        geqPos = pos;
                        continue;
                    }
                    if (token.tokenTypeId == 11) {
                        if (token.tokenId == 1 && bitwiseComplPos < 0 && rigthIsNUmber) {
                            bitwiseComplPos = pos;
                            continue;
                        }
                        if (bitwisePos >= 0 || !leftIsNUmber || !rigthIsNUmber) continue;
                        bitwisePos = pos;
                        continue;
                    }
                    if (token.tokenTypeId != 20) continue;
                    if (token.tokenId == 3) {
                        if (commaPos < 0) {
                            commas = new ArrayList<Integer>();
                        }
                        commas.add(pos);
                        commaPos = pos;
                        continue;
                    }
                    if (token.tokenId == 1 && lParPos < 0) {
                        lParPos = pos;
                        continue;
                    }
                    if (token.tokenId != 2 || rParPos >= 0) continue;
                    rParPos = pos;
                }
                if (powerNum > 1) {
                    powerPos = -1;
                    p = rPos + 1;
                    do {
                        token = this.tokensList.get(--p);
                        if (token.tokenTypeId != 1 || token.tokenId != 5) continue;
                        powerPos = p;
                    } while (p > lPos && powerPos == -1);
                }
            }
            if (calculusPos >= 0) {
                this.calculusCalc(calculusPos);
            } else if (ifPos >= 0) {
                this.IF_CONDITION(ifPos);
            } else if (iffPos >= 0) {
                this.IFF(iffPos);
            } else if (recArgPos >= 0) {
                this.RECURSIVE_ARGUMENT(recArgPos);
            } else if (variadicFunPos >= 0) {
                this.variadicFunCalc(variadicFunPos);
            } else if (f3ArgPos >= 0) {
                this.f3ArgCalc(f3ArgPos);
            } else if (f2ArgPos >= 0) {
                this.f2ArgCalc(f2ArgPos);
            } else if (f1ArgPos >= 0) {
                this.f1ArgCalc(f1ArgPos);
            } else if (userFunPos >= 0) {
                this.USER_FUNCTION(userFunPos);
            } else if (powerPos >= 0) {
                this.POWER(powerPos);
            } else if (factPos >= 0) {
                this.FACT(factPos);
            } else if (modPos >= 0) {
                this.MODULO(modPos);
            } else if (negPos >= 0) {
                this.NEG(negPos);
            } else if (bitwiseComplPos >= 0) {
                this.BITWISE_COMPL(bitwiseComplPos);
            } else if (multiplyPos >= 0 || dividePos >= 0) {
                if (multiplyPos >= 0 && dividePos >= 0) {
                    if (multiplyPos <= dividePos) {
                        this.MULTIPLY(multiplyPos);
                    } else {
                        this.DIVIDE(dividePos);
                    }
                } else if (multiplyPos >= 0) {
                    this.MULTIPLY(multiplyPos);
                } else {
                    this.DIVIDE(dividePos);
                }
            } else if (minusPos >= 0 || plusPos >= 0) {
                if (minusPos >= 0 && plusPos >= 0) {
                    if (minusPos <= plusPos) {
                        this.MINUS(minusPos);
                    } else {
                        this.PLUS(plusPos);
                    }
                } else if (minusPos >= 0) {
                    this.MINUS(minusPos);
                } else {
                    this.PLUS(plusPos);
                }
            } else if (neqPos >= 0) {
                this.NEQ(neqPos);
            } else if (eqPos >= 0) {
                this.EQ(eqPos);
            } else if (ltPos >= 0) {
                this.LT(ltPos);
            } else if (gtPos >= 0) {
                this.GT(gtPos);
            } else if (leqPos >= 0) {
                this.LEQ(leqPos);
            } else if (geqPos >= 0) {
                this.GEQ(geqPos);
            } else if (commaPos >= 0) {
                for (int i = commas.size() - 1; i >= 0; --i) {
                    this.COMMA((Integer)commas.get(i));
                }
            } else if (bolPos >= 0) {
                this.bolCalc(bolPos);
            } else if (bitwisePos >= 0) {
                this.bitwiseCalc(bitwisePos);
            } else if (lParPos >= 0 && rParPos > lParPos) {
                this.PARENTHESES(lParPos, rParPos);
            } else if (this.tokensList.size() > 1) {
                this.errorMessage = this.errorMessage + "\n" + "[" + this.description + "][" + this.expressionString + "] " + "Fatal error - not know what to do with tokens while calculate().";
            }
            if (!this.verboseMode) continue;
            this.showParsing(0, this.tokensList.size() - 1);
            this.printSystemInfo(" done\n", false);
        } while (this.tokensList.size() > 1);
        if (this.verboseMode) {
            this.printSystemInfo("Calculated value: " + this.tokensList.get((int)0).tokenValue + "\n", true);
            this.printSystemInfo("Exiting\n", true);
            this.printSystemInfo("\n", false);
        }
        long endTime = System.currentTimeMillis();
        this.computingTime = (double)(endTime - startTime) / 1000.0;
        return this.tokensList.get((int)0).tokenValue;
    }

    private void f1ArgCalc(int pos) {
        switch (this.tokensList.get((int)pos).tokenId) {
            case 1: {
                this.SIN(pos);
                break;
            }
            case 2: {
                this.COS(pos);
                break;
            }
            case 3: {
                this.TAN(pos);
                break;
            }
            case 4: {
                this.CTAN(pos);
                break;
            }
            case 5: {
                this.SEC(pos);
                break;
            }
            case 6: {
                this.COSEC(pos);
                break;
            }
            case 7: {
                this.ASIN(pos);
                break;
            }
            case 8: {
                this.ACOS(pos);
                break;
            }
            case 9: {
                this.ATAN(pos);
                break;
            }
            case 10: {
                this.ACTAN(pos);
                break;
            }
            case 11: {
                this.LN(pos);
                break;
            }
            case 12: {
                this.LOG2(pos);
                break;
            }
            case 13: {
                this.LOG10(pos);
                break;
            }
            case 14: {
                this.RAD(pos);
                break;
            }
            case 15: {
                this.EXP(pos);
                break;
            }
            case 16: {
                this.SQRT(pos);
                break;
            }
            case 17: {
                this.SINH(pos);
                break;
            }
            case 18: {
                this.COSH(pos);
                break;
            }
            case 19: {
                this.TANH(pos);
                break;
            }
            case 20: {
                this.COTH(pos);
                break;
            }
            case 21: {
                this.SECH(pos);
                break;
            }
            case 22: {
                this.CSCH(pos);
                break;
            }
            case 23: {
                this.DEG(pos);
                break;
            }
            case 24: {
                this.ABS(pos);
                break;
            }
            case 25: {
                this.SGN(pos);
                break;
            }
            case 26: {
                this.FLOOR(pos);
                break;
            }
            case 27: {
                this.CEIL(pos);
                break;
            }
            case 29: {
                this.NOT(pos);
                break;
            }
            case 30: {
                this.ARSINH(pos);
                break;
            }
            case 31: {
                this.ARCOSH(pos);
                break;
            }
            case 32: {
                this.ARTANH(pos);
                break;
            }
            case 33: {
                this.ARCOTH(pos);
                break;
            }
            case 34: {
                this.ARSECH(pos);
                break;
            }
            case 35: {
                this.ARCSCH(pos);
                break;
            }
            case 36: {
                this.SA(pos);
                break;
            }
            case 37: {
                this.SINC(pos);
                break;
            }
            case 38: {
                this.BELL_NUMBER(pos);
                break;
            }
            case 39: {
                this.LUCAS_NUMBER(pos);
                break;
            }
            case 40: {
                this.FIBONACCI_NUMBER(pos);
                break;
            }
            case 41: {
                this.HARMONIC_NUMBER(pos);
                break;
            }
            case 42: {
                this.IS_PRIME(pos);
                break;
            }
            case 43: {
                this.PRIME_COUNT(pos);
                break;
            }
            case 44: {
                this.EXP_INT(pos);
                break;
            }
            case 45: {
                this.LOG_INT(pos);
                break;
            }
            case 46: {
                this.OFF_LOG_INT(pos);
                break;
            }
            case 47: {
                this.GAUSS_ERF(pos);
                break;
            }
            case 48: {
                this.GAUSS_ERFC(pos);
                break;
            }
            case 49: {
                this.GAUSS_ERF_INV(pos);
                break;
            }
            case 50: {
                this.GAUSS_ERFC_INV(pos);
                break;
            }
            case 51: {
                this.ULP(pos);
            }
        }
    }

    private void f2ArgCalc(int pos) {
        switch (this.tokensList.get((int)pos).tokenId) {
            case 1: {
                this.LOG(pos);
                break;
            }
            case 2: {
                this.MOD(pos);
                break;
            }
            case 3: {
                this.BINOM_COEFF(pos);
                break;
            }
            case 4: {
                this.BERNOULLI_NUMBER(pos);
                break;
            }
            case 5: {
                this.STIRLING1_NUMBER(pos);
                break;
            }
            case 6: {
                this.STIRLING2_NUMBER(pos);
                break;
            }
            case 7: {
                this.WORPITZKY_NUMBER(pos);
                break;
            }
            case 8: {
                this.EULER_NUMBER(pos);
                break;
            }
            case 9: {
                this.KRONECKER_DELTA(pos);
                break;
            }
            case 10: {
                this.EULER_POLYNOMIAL(pos);
                break;
            }
            case 11: {
                this.HARMONIC2_NUMBER(pos);
                break;
            }
            case 12: {
                this.RND_VAR_UNIFORM_CONT(pos);
                break;
            }
            case 13: {
                this.RND_VAR_UNIFORM_DISCR(pos);
                break;
            }
            case 14: {
                this.ROUND(pos);
                break;
            }
            case 15: {
                this.RND_NORMAL(pos);
            }
        }
    }

    private void f3ArgCalc(int pos) {
        switch (this.tokensList.get((int)pos).tokenId) {
            case 2: {
                this.IF(pos);
                break;
            }
            case 3: {
                this.CHI(pos);
                break;
            }
            case 4: {
                this.CHI_LR(pos);
                break;
            }
            case 5: {
                this.CHI_L(pos);
                break;
            }
            case 6: {
                this.CHI_R(pos);
                break;
            }
            case 7: {
                this.PDF_UNIFORM_CONT(pos);
                break;
            }
            case 8: {
                this.CDF_UNIFORM_CONT(pos);
                break;
            }
            case 9: {
                this.QNT_UNIFORM_CONT(pos);
                break;
            }
            case 10: {
                this.PDF_NORMAL(pos);
                break;
            }
            case 11: {
                this.CDF_NORMAL(pos);
                break;
            }
            case 12: {
                this.QNT_NORMAL(pos);
            }
        }
    }

    private void variadicFunCalc(int pos) {
        switch (this.tokensList.get((int)pos).tokenId) {
            case 1: {
                this.IFF(pos);
                break;
            }
            case 2: {
                this.MIN_VARIADIC(pos);
                break;
            }
            case 3: {
                this.MAX_VARIADIC(pos);
                break;
            }
            case 8: {
                this.SUM_VARIADIC(pos);
                break;
            }
            case 9: {
                this.PROD_VARIADIC(pos);
                break;
            }
            case 10: {
                this.AVG_VARIADIC(pos);
                break;
            }
            case 11: {
                this.VAR_VARIADIC(pos);
                break;
            }
            case 12: {
                this.STD_VARIADIC(pos);
                break;
            }
            case 4: {
                this.CONTINUED_FRACTION(pos);
                break;
            }
            case 5: {
                this.CONTINUED_POLYNOMIAL(pos);
                break;
            }
            case 6: {
                this.GCD(pos);
                break;
            }
            case 7: {
                this.LCM(pos);
                break;
            }
            case 13: {
                this.RND_LIST(pos);
            }
        }
    }

    private void calculusCalc(int pos) {
        switch (this.tokensList.get((int)pos).tokenId) {
            case 1: {
                this.SUM(pos);
                break;
            }
            case 3: {
                this.PROD(pos);
                break;
            }
            case 15: {
                this.MIN(pos);
                break;
            }
            case 16: {
                this.MAX(pos);
                break;
            }
            case 12: {
                this.AVG(pos);
                break;
            }
            case 13: {
                this.VAR(pos);
                break;
            }
            case 14: {
                this.STD(pos);
                break;
            }
            case 5: {
                this.INTEGRAL(pos);
                break;
            }
            case 17: {
                this.SOLVE(pos);
                break;
            }
            case 6: {
                this.DERIVATIVE(pos, 3);
                break;
            }
            case 7: {
                this.DERIVATIVE(pos, 1);
                break;
            }
            case 8: {
                this.DERIVATIVE(pos, 2);
                break;
            }
            case 9: {
                this.DERIVATIVE_NTH(pos, 3);
                break;
            }
            case 10: {
                this.FORWARD_DIFFERENCE(pos);
                break;
            }
            case 11: {
                this.BACKWARD_DIFFERENCE(pos);
            }
        }
    }

    private void bolCalc(int pos) {
        switch (this.tokensList.get((int)pos).tokenId) {
            case 1: {
                this.AND(pos);
                break;
            }
            case 7: {
                this.CIMP(pos);
                break;
            }
            case 9: {
                this.CNIMP(pos);
                break;
            }
            case 10: {
                this.EQV(pos);
                break;
            }
            case 6: {
                this.IMP(pos);
                break;
            }
            case 2: {
                this.NAND(pos);
                break;
            }
            case 8: {
                this.NIMP(pos);
                break;
            }
            case 4: {
                this.NOR(pos);
                break;
            }
            case 3: {
                this.OR(pos);
                break;
            }
            case 5: {
                this.XOR(pos);
            }
        }
    }

    private void bitwiseCalc(int pos) {
        switch (this.tokensList.get((int)pos).tokenId) {
            case 2: {
                this.BITWISE_AND(pos);
                break;
            }
            case 4: {
                this.BITWISE_OR(pos);
                break;
            }
            case 3: {
                this.BITWISE_XOR(pos);
                break;
            }
            case 5: {
                this.BITWISE_LEFT_SHIFT(pos);
                break;
            }
            case 6: {
                this.BITWISE_RIGHT_SHIFT(pos);
            }
        }
    }

    private void addParserKeyWords() {
        this.addKeyWord("+", "addition", 1, 1);
        this.addKeyWord("-", "subtraction", 2, 1);
        this.addKeyWord("*", "multiplication", 3, 1);
        this.addKeyWord("/", "division", 4, 1);
        this.addKeyWord("^", "exponentiation", 5, 1);
        this.addKeyWord("!", "factorial", 6, 1);
        this.addKeyWord("#", "modulo function", 7, 1);
        this.addKeyWord("&", "logical conjunction (AND)", 1, 2);
        this.addKeyWord("&&", "logical conjunction (AND)", 1, 2);
        this.addKeyWord("/\\", "logical conjunction (AND)", 1, 2);
        this.addKeyWord("~&", "NAND - Sheffer stroke", 2, 2);
        this.addKeyWord("~&&", "NAND - Sheffer stroke", 2, 2);
        this.addKeyWord("~/\\", "NAND - Sheffer stroke", 2, 2);
        this.addKeyWord("|", "logical disjunction (OR)", 3, 2);
        this.addKeyWord("||", "logical disjunction (OR)", 3, 2);
        this.addKeyWord("\\/", "logical disjunction (OR)", 3, 2);
        this.addKeyWord("~|", "logical NOR", 4, 2);
        this.addKeyWord("~||", "logical NOR", 4, 2);
        this.addKeyWord("~\\/", "logical NOR", 4, 2);
        this.addKeyWord("(+)", "exclusive or (XOR)", 5, 2);
        this.addKeyWord("-->", "implication (IMP)", 6, 2);
        this.addKeyWord("-/>", "material nonimplication (NIMP)", 8, 2);
        this.addKeyWord("<--", "converse implication (CIMP)", 7, 2);
        this.addKeyWord("</-", "converse nonimplication (CNIMP)", 9, 2);
        this.addKeyWord("<->", "logical biconditional (EQV)", 10, 2);
        this.addKeyWord("~", "negation", 11, 2);
        this.addKeyWord("\u00ac", "negation", 11, 2);
        this.addKeyWord("=", "equality", 1, 3);
        this.addKeyWord("==", "equality", 1, 3);
        this.addKeyWord("<>", "inequation", 2, 3);
        this.addKeyWord("~=", "inequation", 2, 3);
        this.addKeyWord("!=", "inequation", 2, 3);
        this.addKeyWord("<", "lower than", 3, 3);
        this.addKeyWord(">", "greater than", 4, 3);
        this.addKeyWord("<=", "lower or equal", 5, 3);
        this.addKeyWord(">=", "greater or equal", 6, 3);
        if (!this.parserKeyWordsOnly) {
            this.addKeyWord("sin", "trigonometric sine function", 1, 4);
            this.addKeyWord("cos", "trigonometric cosine function", 2, 4);
            this.addKeyWord("tan", "trigonometric tangent function", 3, 4);
            this.addKeyWord("tg", "trigonometric tangent function", 3, 4);
            this.addKeyWord("ctan", "trigonometric cotangent function", 4, 4);
            this.addKeyWord("ctg", "trigonometric cotangent function", 4, 4);
            this.addKeyWord("cot", "trigonometric cotangent function", 4, 4);
            this.addKeyWord("sec", "trigonometric secant function", 5, 4);
            this.addKeyWord("cosec", "trigonometric cosecant function", 6, 4);
            this.addKeyWord("csc", "trigonometric cosecant function", 6, 4);
            this.addKeyWord("asin", "inverse trigonometric sine function", 7, 4);
            this.addKeyWord("arsin", "inverse trigonometric sine function", 7, 4);
            this.addKeyWord("arcsin", "inverse trigonometric sine function", 7, 4);
            this.addKeyWord("acos", "inverse trigonometric cosine function", 8, 4);
            this.addKeyWord("arcos", "inverse trigonometric cosine function", 8, 4);
            this.addKeyWord("arccos", "inverse trigonometric cosine function", 8, 4);
            this.addKeyWord("atan", "inverse trigonometric tangent function", 9, 4);
            this.addKeyWord("arctan", "inverse trigonometric tangent function", 9, 4);
            this.addKeyWord("atg", "inverse trigonometric tangent function", 9, 4);
            this.addKeyWord("arctg", "inverse trigonometric tangent function", 9, 4);
            this.addKeyWord("actan", "inverse trigonometric cotangent function", 10, 4);
            this.addKeyWord("arcctan", "inverse trigonometric cotangent function", 10, 4);
            this.addKeyWord("actg", "inverse trigonometric cotangent function", 10, 4);
            this.addKeyWord("arcctg", "inverse trigonometric cotangent function", 10, 4);
            this.addKeyWord("acot", "inverse trigonometric cotangent function", 10, 4);
            this.addKeyWord("arccot", "inverse trigonometric cotangent function", 10, 4);
            this.addKeyWord("ln", "natural logarithm function (base e)", 11, 4);
            this.addKeyWord("log2", "binary logarithm function (base 2)", 12, 4);
            this.addKeyWord("log10", "common logarithm function (base 10)", 13, 4);
            this.addKeyWord("rad", "degrees to radians function", 14, 4);
            this.addKeyWord("exp", "exponential function", 15, 4);
            this.addKeyWord("sqrt", "squre root function", 16, 4);
            this.addKeyWord("sinh", "hyperbolic sine function", 17, 4);
            this.addKeyWord("cosh", "hyperbolic cosine function", 18, 4);
            this.addKeyWord("tanh", "hyperbolic tangent function", 19, 4);
            this.addKeyWord("tgh", "hyperbolic tangent function", 19, 4);
            this.addKeyWord("ctanh", "hyperbolic cotangent function", 20, 4);
            this.addKeyWord("coth", "hyperbolic cotangent function", 20, 4);
            this.addKeyWord("ctgh", "hyperbolic cotangent function", 20, 4);
            this.addKeyWord("sech", "hyperbolic secant function", 21, 4);
            this.addKeyWord("csch", "hyperbolic cosecant function", 22, 4);
            this.addKeyWord("cosech", "hyperbolic cosecant function", 22, 4);
            this.addKeyWord("deg", "radians to degrees function", 23, 4);
            this.addKeyWord("abs", "absolut value function", 24, 4);
            this.addKeyWord("sgn", "signum function", 25, 4);
            this.addKeyWord("floor", "floor function", 26, 4);
            this.addKeyWord("ceil", "ceiling function", 27, 4);
            this.addKeyWord("not", "negation function", 29, 4);
            this.addKeyWord("asinh", "inverse hyperbolic sine function", 30, 4);
            this.addKeyWord("arsinh", "inverse hyperbolic sine function", 30, 4);
            this.addKeyWord("arcsinh", "inverse hyperbolic sine function", 30, 4);
            this.addKeyWord("acosh", "inverse hyperbolic cosine function", 31, 4);
            this.addKeyWord("arcosh", "inverse hyperbolic cosine function", 31, 4);
            this.addKeyWord("arccosh", "inverse hyperbolic cosine function", 31, 4);
            this.addKeyWord("atanh", "inverse hyperbolic tangent function", 32, 4);
            this.addKeyWord("arctanh", "inverse hyperbolic tangent function", 32, 4);
            this.addKeyWord("atgh", "inverse hyperbolic tangent function", 32, 4);
            this.addKeyWord("arctgh", "inverse hyperbolic tangent function", 32, 4);
            this.addKeyWord("actanh", "inverse hyperbolic cotangent function", 33, 4);
            this.addKeyWord("arcctanh", "inverse hyperbolic cotangent function", 33, 4);
            this.addKeyWord("acoth", "inverse hyperbolic cotangent function", 33, 4);
            this.addKeyWord("arcoth", "inverse hyperbolic cotangent function", 33, 4);
            this.addKeyWord("arccoth", "inverse hyperbolic cotangent function", 33, 4);
            this.addKeyWord("actgh", "inverse hyperbolic cotangent function", 33, 4);
            this.addKeyWord("arcctgh", "inverse hyperbolic cotangent function", 33, 4);
            this.addKeyWord("asech", "inverse hyperbolic secant function", 34, 4);
            this.addKeyWord("arsech", "inverse hyperbolic secant function", 34, 4);
            this.addKeyWord("arcsech", "inverse hyperbolic secant function", 34, 4);
            this.addKeyWord("acsch", "inverse hyperbolic cosecant function", 35, 4);
            this.addKeyWord("arcsch", "inverse hyperbolic cosecant function", 35, 4);
            this.addKeyWord("arccsch", "inverse hyperbolic cosecant function", 35, 4);
            this.addKeyWord("acosech", "inverse hyperbolic cosecant function", 35, 4);
            this.addKeyWord("arcosech", "inverse hyperbolic cosecant function", 35, 4);
            this.addKeyWord("arccosech", "inverse hyperbolic cosecant function", 35, 4);
            this.addKeyWord("sinc", "sinc function (normalized)", 36, 4);
            this.addKeyWord("Sa", "sinc function (normalized)", 36, 4);
            this.addKeyWord("Sinc", "sinc function (unnormalized)", 37, 4);
            this.addKeyWord("Bell", "Bell number", 38, 4);
            this.addKeyWord("Fib", "Fionacci number", 40, 4);
            this.addKeyWord("Luc", "Lucas number", 39, 4);
            this.addKeyWord("harm", "Harmonic number", 41, 4);
            this.addKeyWord("ispr", "(2.3) Prime number test (is number a prime?)", 42, 4);
            this.addKeyWord("Pi", "(2.3) Prime-counting function - Pi(x)", 43, 4);
            this.addKeyWord("Ei", "(2.3) Exponential integral function (non-elementary special function) - usage example: Ei(x)", 44, 4);
            this.addKeyWord("li", "(2.3) Logarithmic integral function (non-elementary special function) - usage example: li(x)", 45, 4);
            this.addKeyWord("Li", "(2.3) Offset logarithmic integral function (non-elementary special function) - usage example: Li(x)", 46, 4);
            this.addKeyWord("erf", "(3.0) Gauss error function (non-elementary special function) - usage example: 2 + erf(x)", 47, 4);
            this.addKeyWord("erfc", "(3.0) Gauss complementary error function (non-elementary special function) - usage example: 1 - erfc(x)", 48, 4);
            this.addKeyWord("erfInv", "(3.0) Inverse Gauss error function (non-elementary special function) - usage example: erfInv(x)", 49, 4);
            this.addKeyWord("erfcInv", "(3.0) Inverse Gauss complementary error function (non-elementary special function) - usage example: erfcInv(x)", 50, 4);
            this.addKeyWord("ulp", "(3.0) Unit in The Last Place - ulp(0.1)", 51, 4);
            this.addKeyWord("log", "logarithm function", 1, 5);
            this.addKeyWord("mod", "modulo function", 2, 5);
            this.addKeyWord("C", "binomial coefficient function", 3, 5);
            this.addKeyWord("Bern", "Bernoulli numbers", 4, 5);
            this.addKeyWord("Stirl1", "Stirling numbers of the first kind", 5, 5);
            this.addKeyWord("Stirl2", "Stirling numbers of the second kind", 6, 5);
            this.addKeyWord("Worp", "Worpitzky number", 7, 5);
            this.addKeyWord("Euler", "Euler number", 8, 5);
            this.addKeyWord("KDelta", "Kronecker delta", 9, 5);
            this.addKeyWord("EulerPol", "EulerPol", 10, 5);
            this.addKeyWord("Harm", "Harmonic number", 11, 5);
            this.addKeyWord("rUni", "(3.0) Random variable - Uniform continuous distribution U(a,b), usage example: 2*rUni(2,10)", 12, 5);
            this.addKeyWord("rUnid", "(3.0) Random variable - Uniform discrete distribution U{a,b}, usage example: 2*rUnid(2,100)", 13, 5);
            this.addKeyWord("round", "(3.0) Half-up rounding, usage examples: round(2.2, 0) = 2, round(2.6, 0) = 3, round(2.66,1) = 2.7", 14, 5);
            this.addKeyWord("rNor", "(3.0) Random variable - Normal distribution N(m,s) m - mean, s - stddev, usage example: 3*rNor(0,1)", 15, 5);
            this.addKeyWord("if", "if function ( if(con, if_true, if_false) )", 1, 6);
            this.addKeyWord("chi", "Characteristic function for x in (a,b) - chi(x, a, b)", 3, 6);
            this.addKeyWord("CHi", "Characteristic function for x in [a,b] - CHi(x, a, b)", 4, 6);
            this.addKeyWord("Chi", "Characteristic function for x in [a,b) - Chi(x, a, b)", 5, 6);
            this.addKeyWord("cHi", "Characteristic function for x in (a,b] - cHi(x, a, b)", 6, 6);
            this.addKeyWord("pUni", "(3.0) Probability distribution function - Uniform continuous distribution U(a,b), usage example: 2 * pUni(x, 2, 10)", 7, 6);
            this.addKeyWord("cUni", "(3.0) Cumulative distribution function - Uniform continuous distribution U(a,b), usage example: 2 * cUni(x, 2, 10)", 8, 6);
            this.addKeyWord("qUni", "(3.0) Quantile function (inverse cumulative distribution function) - Uniform continuous distribution U(a,b), usage example: 2 * qUni(q, 2, 10)", 9, 6);
            this.addKeyWord("pNor", "(3.0) Probability distribution function - Normal distribution N(m,s) m - mean, s - stddev, usage example: 2 * pNor(x, 1, 2)", 10, 6);
            this.addKeyWord("cNor", "(3.0) Cumulative distribution function - Normal distribution N(m,s) m - mean, s - stddev, usage example: 2 * cNor(x, 1, 2)", 11, 6);
            this.addKeyWord("qNor", "(3.0) Quantile function (inverse cumulative distribution function) - Normal distribution N(m,s) m - mean, s - stddev, usage example: 2 * qNor(q, 1, 2)", 12, 6);
            this.addKeyWord("iff", "if function ( iff(con_1, if_true_1_exp, ..., con_n, if_true_n_exp) )", 1, 7);
            this.addKeyWord("min", "Minimum function: min(a,b,c,...)", 2, 7);
            this.addKeyWord("max", "Maximum function: max(a,b,c,...)", 3, 7);
            this.addKeyWord("ConFrac", "Continued fraction: ConFrac(a,b,c,...)", 4, 7);
            this.addKeyWord("ConPol", "Continued polynomial: ConPol(a,b,c,...)", 5, 7);
            this.addKeyWord("gcd", "Greatest common divisor: gcd(a,b,c,...)", 6, 7);
            this.addKeyWord("lcm", "Least common multiple: lcm(a,b,c,...)", 7, 7);
            this.addKeyWord("add", "(2.4) Summation operator add(a1,a2,a3,...,an)", 8, 7);
            this.addKeyWord("multi", "(2.4) Multiplication multi(a1,a2,a3,...,an)", 9, 7);
            this.addKeyWord("mean", "(2.4) Mean / average value mean(a1,a2,a3,...,an)", 10, 7);
            this.addKeyWord("var", "(2.4) Bias-corrected sample variance var(a1,a2,a3,...,an)", 11, 7);
            this.addKeyWord("std", "(2.4) Bias-corrected sample standard deviation std(a1,a2,a3,...,an)", 12, 7);
            this.addKeyWord("rList", "(3.0) Random number from given list of numbers rList(a1,a2,a3,...,an)", 13, 7);
            this.addKeyWord("sum", "summation operator (SIGMA) sum(i, from, to, f(i,...))", 1, 8);
            this.addKeyWord("prod", "product operator (PI) prod(i, from, to, f(i,...))", 3, 8);
            this.addKeyWord("int", "definite integral operator ( int(f(x,...), x, a, b) )", 5, 8);
            this.addKeyWord("der", "derivative operator ( der(f(x,...), x) ) ", 6, 8);
            this.addKeyWord("der-", "left derivative operator ( der-(f(x,...), x) ) ", 7, 8);
            this.addKeyWord("der+", "right derivative operator ( der+(f(x,...), x) ) ", 8, 8);
            this.addKeyWord("dern", "n-th derivative operator ( dern(f(x,...), x) ) ", 9, 8);
            this.addKeyWord("diff", "forward difference operator", 10, 8);
            this.addKeyWord("difb", "backward difference operator", 11, 8);
            this.addKeyWord("avg", "(2.4) Average operator avg(i, from, to, f(i,...))", 12, 8);
            this.addKeyWord("vari", "(2.4) Bias-corrected sample variance operator vari(i, from, to, f(i,...))", 13, 8);
            this.addKeyWord("stdi", "(2.4) Bias-corrected sample standard deviation operator stdi(i, from, to, f(i,...))", 14, 8);
            this.addKeyWord("mini", "(2.4) Minimum value mini(i, from, to, f(i,...))", 15, 8);
            this.addKeyWord("maxi", "(2.4) Maximum valu maxi(i, from, to, f(i,...))", 16, 8);
            this.addKeyWord("solve", "(4.0) f(x) = 0 equation solving, function root finding: solve( f(x,...), x, a, b )", 17, 8);
            this.addKeyWord("pi", "Pi, Archimedes' constant or Ludolph's number", 1, 9);
            this.addKeyWord("e", "Napier's constant, or Euler's number, base of Natural logarithm", 2, 9);
            this.addKeyWord("[gam]", "Euler-Mascheroni constant", 3, 9);
            this.addKeyWord("[phi]", "Golden ratio", 4, 9);
            this.addKeyWord("[PN]", "Plastic constant", 5, 9);
            this.addKeyWord("[B*]", "Embree-Trefethen constant", 6, 9);
            this.addKeyWord("[F'd]", "Feigenbaum constant alfa", 7, 9);
            this.addKeyWord("[F'a]", "Feigenbaum constant delta", 8, 9);
            this.addKeyWord("[C2]", "Twin prime constant", 9, 9);
            this.addKeyWord("[M1]", "Meissel-Mertens constant", 10, 9);
            this.addKeyWord("[B2]", "Brun's constant for twin primes", 11, 9);
            this.addKeyWord("[B4]", "Brun's constant for prime quadruplets", 12, 9);
            this.addKeyWord("[BN'L]", "de Bruijn-Newman constant", 13, 9);
            this.addKeyWord("[Kat]", "Catalan's constant", 14, 9);
            this.addKeyWord("[K*]", "Landau-Ramanujan constant", 15, 9);
            this.addKeyWord("[K.]", "Viswanath's constant", 16, 9);
            this.addKeyWord("[B'L]", "Legendre's constant", 17, 9);
            this.addKeyWord("[RS'm]", "Ramanujan-Soldner constant", 18, 9);
            this.addKeyWord("[EB'e]", "Erdos-Borwein constant", 19, 9);
            this.addKeyWord("[Bern]", "Bernstein's constant", 20, 9);
            this.addKeyWord("[GKW'l]", "Gauss-Kuzmin-Wirsing constant", 21, 9);
            this.addKeyWord("[HSM's]", "Hafner-Sarnak-McCurley constant", 22, 9);
            this.addKeyWord("[lm]", "Golomb-Dickman constant", 23, 9);
            this.addKeyWord("[Cah]", "Cahen's constant", 24, 9);
            this.addKeyWord("[Ll]", "Laplace limit", 25, 9);
            this.addKeyWord("[AG]", "Alladi-Grinstead constant", 26, 9);
            this.addKeyWord("[L*]", "Lengyel's constant", 27, 9);
            this.addKeyWord("[L.]", "Levy's constant", 28, 9);
            this.addKeyWord("[Dz3]", "Apery's constant", 29, 9);
            this.addKeyWord("[A3n]", "Mills' constant", 30, 9);
            this.addKeyWord("[Bh]", "Backhouse's constant", 31, 9);
            this.addKeyWord("[Pt]", "Porter's constant", 32, 9);
            this.addKeyWord("[L2]", "Lieb's square ice constant", 33, 9);
            this.addKeyWord("[Nv]", "Niven's constant", 34, 9);
            this.addKeyWord("[Ks]", "Sierpinski's constant", 35, 9);
            this.addKeyWord("[Kh]", "Khinchin's constant", 36, 9);
            this.addKeyWord("[FR]", "Fransen-Robinson constant", 37, 9);
            this.addKeyWord("[La]", "Landau's constant", 38, 9);
            this.addKeyWord("[P2]", "Parabolic constant", 39, 9);
            this.addKeyWord("[Om]", "Omega constant", 40, 9);
            this.addKeyWord("[MRB]", "MRB constant", 41, 9);
            this.addKeyWord("[li2]", "(2.3) li(2) - logarithmic integral function at x=2", 42, 9);
            this.addKeyWord("[EG]", "(2.3) Gompertz constant", 43, 9);
            this.addKeyWord("[c]", "(4.0) <Physical Constant> Light speed in vacuum [m/s] (m=1, s=1)", 101, 9);
            this.addKeyWord("[G.]", "(4.0) <Physical Constant> Gravitational constant (m=1, kg=1, s=1)]", 102, 9);
            this.addKeyWord("[g]", "(4.0) <Physical Constant> Gravitational acceleration on Earth [m/s^2] (m=1, s=1)", 103, 9);
            this.addKeyWord("[hP]", "(4.0) <Physical Constant> Planck constant (m=1, kg=1, s=1)", 104, 9);
            this.addKeyWord("[h-]", "(4.0) <Physical Constant> Reduced Planck constant / Dirac constant (m=1, kg=1, s=1)]", 105, 9);
            this.addKeyWord("[lP]", "(4.0) <Physical Constant> Planck length [m] (m=1)", 106, 9);
            this.addKeyWord("[mP]", "(4.0) <Physical Constant> Planck mass [kg] (kg=1)", 107, 9);
            this.addKeyWord("[tP]", "(4.0) <Physical Constant> Planck time [s] (s=1)", 108, 9);
            this.addKeyWord("[ly]", "(4.0) <Astronomical Constant> Light year [m] (m=1)", 201, 9);
            this.addKeyWord("[au]", "(4.0) <Astronomical Constant> Astronomical unit [m] (m=1)", 202, 9);
            this.addKeyWord("[pc]", "(4.0) <Astronomical Constant> Parsec [m] (m=1)", 203, 9);
            this.addKeyWord("[kpc]", "(4.0) <Astronomical Constant> Kiloparsec [m] (m=1)", 204, 9);
            this.addKeyWord("[Earth-R-eq]", "(4.0) <Astronomical Constant> Earth equatorial radius [m] (m=1)", 205, 9);
            this.addKeyWord("[Earth-R-po]", "(4.0) <Astronomical Constant> Earth polar radius [m] (m=1)", 206, 9);
            this.addKeyWord("[Earth-R]", "(4.0) <Astronomical Constant> Earth mean radius (m=1)", 207, 9);
            this.addKeyWord("[Earth-M]", "(4.0) <Astronomical Constant> Earth mass [kg] (kg=1)", 208, 9);
            this.addKeyWord("[Earth-D]", "(4.0) <Astronomical Constant> Earth-Sun distance - semi major axis [m] (m=1)", 209, 9);
            this.addKeyWord("[Moon-R]", "(4.0) <Astronomical Constant> Moon mean radius [m] (m=1)", 210, 9);
            this.addKeyWord("[Moon-M]", "(4.0) <Astronomical Constant> Moon mass [kg] (kg=1)", 211, 9);
            this.addKeyWord("[Moon-D]", "(4.0) <Astronomical Constant> Moon-Earth distance - semi major axis [m] (m=1)", 212, 9);
            this.addKeyWord("[Solar-R]", "(4.0) <Astronomical Constant> Solar mean radius [m] (m=1)", 213, 9);
            this.addKeyWord("[Solar-M]", "(4.0) <Astronomical Constant> Solar mass [kg] (kg=1)", 214, 9);
            this.addKeyWord("[Mercury-R]", "(4.0) <Astronomical Constant> Mercury mean radius [m] (m=1)", 215, 9);
            this.addKeyWord("[Mercury-M]", "(4.0) <Astronomical Constant> Mercury mass [kg] (kg=1)", 216, 9);
            this.addKeyWord("[Mercury-D]", "(4.0) <Astronomical Constant> Mercury-Sun distance - semi major axis [m] (m=1)", 217, 9);
            this.addKeyWord("[Venus-R]", "(4.0) <Astronomical Constant> Venus mean radius [m] (m=1)", 218, 9);
            this.addKeyWord("[Venus-M]", "(4.0) <Astronomical Constant> Venus mass [kg] (kg=1)", 219, 9);
            this.addKeyWord("[Venus-D]", "(4.0) <Astronomical Constant> Venus-Sun distance - semi major axis [m] (m=1)", 220, 9);
            this.addKeyWord("[Mars-R]", "(4.0) <Astronomical Constant> Mars mean radius [m] (m=1)", 221, 9);
            this.addKeyWord("[Mars-M]", "(4.0) <Astronomical Constant> Mars mass [kg] (kg=1)", 222, 9);
            this.addKeyWord("[Mars-D]", "(4.0) <Astronomical Constant> Mars-Sun distance - semi major axis [m] (m=1)", 223, 9);
            this.addKeyWord("[Jupiter-R]", "(4.0) <Astronomical Constant> Jupiter mean radius [m] (m=1)", 224, 9);
            this.addKeyWord("[Jupiter-M]", "(4.0) <Astronomical Constant> Jupiter mass [kg] (kg=1)", 225, 9);
            this.addKeyWord("[Jupiter-D]", "(4.0) <Astronomical Constant> Jupiter-Sun distance - semi major axis [m] (m=1)", 226, 9);
            this.addKeyWord("[Saturn-R]", "(4.0) <Astronomical Constant> Saturn mean radius [m] (m=1)", 227, 9);
            this.addKeyWord("[Saturn-M]", "(4.0) <Astronomical Constant> Saturn mass [kg] (kg=1)", 228, 9);
            this.addKeyWord("[Saturn-D]", "(4.0) <Astronomical Constant> Saturn-Sun distance - semi major axis [m] (m=1)", 229, 9);
            this.addKeyWord("[Uranus-R]", "(4.0) <Astronomical Constant> Uranus mean radius [m] (m=1)", 230, 9);
            this.addKeyWord("[Uranus-M]", "(4.0) <Astronomical Constant> Uranus mass [kg] (kg=1)", 231, 9);
            this.addKeyWord("[Uranus-D]", "(4.0) <Astronomical Constant> Uranus-Sun distance - semi major axis [m] (m=1)", 232, 9);
            this.addKeyWord("[Neptune-R]", "(4.0) <Astronomical Constant> Neptune mean radius [m] (m=1)", 233, 9);
            this.addKeyWord("[Neptune-M]", "(4.0) <Astronomical Constant> Neptune mass [kg] (kg=1)", 234, 9);
            this.addKeyWord("[Neptune-D]", "(4.0) <Astronomical Constant> Neptune-Sun distance - semi major axis [m] (m=1)", 235, 9);
            this.addKeyWord("[Uni]", "(3.0) Random variable - Uniform continuous distribution U(0,1), usage example: 2*[Uni]", 1, 10);
            this.addKeyWord("[Int]", "(3.0) Random variable - random integer - usage example sin( 3*[Int] )", 2, 10);
            this.addKeyWord("[Int1]", "(3.0) Random variable - random integer - Uniform discrete distribution U{-10^1, 10^1} - usage example sin( 3*[Int1] )", 3, 10);
            this.addKeyWord("[Int2]", "(3.0) Random variable - random integer - Uniform discrete distribution U{-10^2, 10^2} - usage example sin( 3*[Int2] )", 4, 10);
            this.addKeyWord("[Int3]", "(3.0) Random variable - random integer - Uniform discrete distribution U{-10^3, 10^3} - usage example sin( 3*[Int3] )", 5, 10);
            this.addKeyWord("[Int4]", "(3.0) Random variable - random integer - Uniform discrete distribution U{-10^4, 10^4} - usage example sin( 3*[Int4] )", 6, 10);
            this.addKeyWord("[Int5]", "(3.0) Random variable - random integer - Uniform discrete distribution U{-10^5, 10^5} - usage example sin( 3*[Int5] )", 7, 10);
            this.addKeyWord("[Int6]", "(3.0) Random variable - random integer - Uniform discrete distribution U{-10^6, 10^6} - usage example sin( 3*[Int6] )", 8, 10);
            this.addKeyWord("[Int7]", "(3.0) Random variable - random integer - Uniform discrete distribution U{-10^7, 10^7} - usage example sin( 3*[Int7] )", 9, 10);
            this.addKeyWord("[Int8]", "(3.0) Random variable - random integer - Uniform discrete distribution U{-10^8, 10^8} - usage example sin( 3*[Int8] )", 10, 10);
            this.addKeyWord("[Int9]", "(3.0) Random variable - random integer - Uniform discrete distribution U{-10^9, 10^9} - usage example sin( 3*[Int9] )", 11, 10);
            this.addKeyWord("[nat]", "(3.0) Random variable - random natural number including 0 - usage example sin( 3*[nat] )", 12, 10);
            this.addKeyWord("[nat1]", "(3.0) Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^1} - usage example sin( 3*[nat1] )", 13, 10);
            this.addKeyWord("[nat2]", "(3.0) Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^2} - usage example sin( 3*[nat2] )", 14, 10);
            this.addKeyWord("[nat3]", "(3.0) Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^3} - usage example sin( 3*[nat3] )", 15, 10);
            this.addKeyWord("[nat4]", "(3.0) Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^4} - usage example sin( 3*[nat4] )", 16, 10);
            this.addKeyWord("[nat5]", "(3.0) Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^5} - usage example sin( 3*[nat5] )", 17, 10);
            this.addKeyWord("[nat6]", "(3.0) Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^6} - usage example sin( 3*[nat6] )", 18, 10);
            this.addKeyWord("[nat7]", "(3.0) Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^7} - usage example sin( 3*[nat7] )", 19, 10);
            this.addKeyWord("[nat8]", "(3.0) Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^8} - usage example sin( 3*[nat8] )", 20, 10);
            this.addKeyWord("[nat9]", "(3.0) Random variable - random natural number including 0 - Uniform discrete distribution U{0, 10^9} - usage example sin( 3*[nat9] )", 21, 10);
            this.addKeyWord("[Nat]", "(3.0) Random variable - random natural number - usage example sin( 3*[Nat] )", 22, 10);
            this.addKeyWord("[Nat1]", "(3.0) Random variable - random natural number - Uniform discrete distribution U{1, 10^1} - usage example sin( 3*[Nat1] )", 23, 10);
            this.addKeyWord("[Nat2]", "(3.0) Random variable - random natural number - Uniform discrete distribution U{1, 10^2} - usage example sin( 3*[Nat2] )", 24, 10);
            this.addKeyWord("[Nat3]", "(3.0) Random variable - random natural number - Uniform discrete distribution U{1, 10^3} - usage example sin( 3*[Nat3] )", 25, 10);
            this.addKeyWord("[Nat4]", "(3.0) Random variable - random natural number - Uniform discrete distribution U{1, 10^4} - usage example sin( 3*[Nat4] )", 26, 10);
            this.addKeyWord("[Nat5]", "(3.0) Random variable - random natural number - Uniform discrete distribution U{1, 10^5} - usage example sin( 3*[Nat5] )", 27, 10);
            this.addKeyWord("[Nat6]", "(3.0) Random variable - random natural number - Uniform discrete distribution U{1, 10^6} - usage example sin( 3*[Nat6] )", 28, 10);
            this.addKeyWord("[Nat7]", "(3.0) Random variable - random natural number - Uniform discrete distribution U{1, 10^7} - usage example sin( 3*[Nat7] )", 29, 10);
            this.addKeyWord("[Nat8]", "(3.0) Random variable - random natural number - Uniform discrete distribution U{1, 10^8} - usage example sin( 3*[Nat8] )", 30, 10);
            this.addKeyWord("[Nat9]", "(3.0) Random variable - random natural number - Uniform discrete distribution U{1, 10^9} - usage example sin( 3*[Nat9] )", 31, 10);
            this.addKeyWord("[Nor]", "(3.0) Random variable - Normal distribution N(0,1) - usage example cos( 3*[Nor]+1 )", 32, 10);
            this.addKeyWord("@~", "(4.0) Bitwise unary complement", 1, 11);
            this.addKeyWord("@&", "(4.0) Bitwise AND", 2, 11);
            this.addKeyWord("@^", "(4.0) Bitwise exclusive OR", 3, 11);
            this.addKeyWord("@|", "(4.0) Bitwise inclusive OR", 4, 11);
            this.addKeyWord("@<<", "(4.0) Signed left shift", 5, 11);
            this.addKeyWord("@>>", "(4.0) Signed right shift", 6, 11);
            this.addKeyWord("[%]", "(4.0) <Ratio, Fraction> Percentage = 0.01", 1, 12);
            this.addKeyWord("[%%]", "(4.0) <Ratio, Fraction> Promil, Per mille = 0.001", 2, 12);
            this.addKeyWord("[Y]", "(4.0) <Metric prefix> Septillion / Yotta = 10^24", 101, 12);
            this.addKeyWord("[sept]", "(4.0) <Metric prefix> Septillion / Yotta = 10^24", 101, 12);
            this.addKeyWord("[Z]", "(4.0) <Metric prefix> Sextillion / Zetta = 10^21", 102, 12);
            this.addKeyWord("[sext]", "(4.0) <Metric prefix> Sextillion / Zetta = 10^21", 102, 12);
            this.addKeyWord("[E]", "(4.0) <Metric prefix> Quintillion / Exa = 10^18", 103, 12);
            this.addKeyWord("[quint]", "(4.0) <Metric prefix> Quintillion / Exa = 10^18", 103, 12);
            this.addKeyWord("[P]", "(4.0) <Metric prefix> Quadrillion / Peta = 10^15", 104, 12);
            this.addKeyWord("[quad]", "(4.0) <Metric prefix> Quadrillion / Peta = 10^15", 104, 12);
            this.addKeyWord("[T]", "(4.0) <Metric prefix> Trillion / Tera = 10^12", 105, 12);
            this.addKeyWord("[tril]", "(4.0) <Metric prefix> Trillion / Tera = 10^12", 105, 12);
            this.addKeyWord("[G]", "(4.0) <Metric prefix> Billion / Giga = 10^9", 106, 12);
            this.addKeyWord("[bil]", "(4.0) <Metric prefix> Billion / Giga = 10^9", 106, 12);
            this.addKeyWord("[M]", "(4.0) <Metric prefix> Million / Mega = 10^6", 107, 12);
            this.addKeyWord("[mil]", "(4.0) <Metric prefix> Million / Mega = 10^6", 107, 12);
            this.addKeyWord("[k]", "(4.0) <Metric prefix> Thousand / Kilo = 10^3", 108, 12);
            this.addKeyWord("[th]", "(4.0) <Metric prefix> Thousand / Kilo = 10^3", 108, 12);
            this.addKeyWord("[hecto]", "(4.0) <Metric prefix> Hundred / Hecto = 10^2", 109, 12);
            this.addKeyWord("[hund]", "(4.0) <Metric prefix> Hundred / Hecto = 10^2", 109, 12);
            this.addKeyWord("[deca]", "(4.0) <Metric prefix> Ten / Deca = 10", 110, 12);
            this.addKeyWord("[ten]", "(4.0) <Metric prefix> Ten / Deca = 10", 110, 12);
            this.addKeyWord("[deci]", "(4.0) <Metric prefix> Tenth / Deci = 0.1", 111, 12);
            this.addKeyWord("[centi]", "(4.0) <Metric prefix> Hundredth / Centi = 0.01", 112, 12);
            this.addKeyWord("[milli]", "(4.0) <Metric prefix> Thousandth / Milli = 0.001", 113, 12);
            this.addKeyWord("[mic]", "(4.0) <Metric prefix> Millionth / Micro = 10^-6", 114, 12);
            this.addKeyWord("[n]", "(4.0) <Metric prefix> Billionth / Nano = 10^-9", 115, 12);
            this.addKeyWord("[p]", "(4.0) <Metric prefix> Trillionth / Pico = 10^-12", 116, 12);
            this.addKeyWord("[f]", "(4.0) <Metric prefix> Quadrillionth / Femto = 10^-15", 117, 12);
            this.addKeyWord("[a]", "(4.0) <Metric prefix> Quintillionth / Atoo = 10^-18", 118, 12);
            this.addKeyWord("[z]", "(4.0) <Metric prefix> Sextillionth / Zepto = 10^-21", 119, 12);
            this.addKeyWord("[y]", "(4.0) <Metric prefix> Septillionth / Yocto = 10^-24", 120, 12);
            this.addKeyWord("[m]", "(4.0) <Unit of length> Metre / Meter (m=1)", 201, 12);
            this.addKeyWord("[km]", "(4.0) <Unit of length> Kilometre / Kilometer (m=1)", 202, 12);
            this.addKeyWord("[cm]", "(4.0) <Unit of length> Centimetre / Centimeter (m=1)", 203, 12);
            this.addKeyWord("[mm]", "(4.0) <Unit of length> Millimetre / Millimeter (m=1)", 204, 12);
            this.addKeyWord("[inch]", "(4.0) <Unit of length> Inch (m=1)", 205, 12);
            this.addKeyWord("[yd]", "(4.0) <Unit of length> Yard (m=1)", 206, 12);
            this.addKeyWord("[ft]", "(4.0) <Unit of length> Feet (m=1)", 207, 12);
            this.addKeyWord("[mile]", "(4.0) <Unit of length> Mile (m=1)", 208, 12);
            this.addKeyWord("[nmi]", "(4.0) <Unit of length> Nautical mile (m=1)", 209, 12);
            this.addKeyWord("[m2]", "(4.0) <Unit of area> Square metre / Square meter (m=1)", 301, 12);
            this.addKeyWord("[cm2]", "(4.0) <Unit of area> Square centimetre / Square centimeter (m=1)", 302, 12);
            this.addKeyWord("[mm2]", "(4.0) <Unit of area> Square millimetre / Square millimeter (m=1)", 303, 12);
            this.addKeyWord("[are]", "(4.0) <Unit of area> Are (m=1)", 304, 12);
            this.addKeyWord("[ha]", "(4.0) <Unit of area> Hectare (m=1)", 305, 12);
            this.addKeyWord("[acre]", "(4.0) <Unit of area> Acre (m=1)", 306, 12);
            this.addKeyWord("[km2]", "(4.0) <Unit of area> Square kilometre / Square kilometer (m=1)", 307, 12);
            this.addKeyWord("[mm3]", "(4.0) <Unit of volume> Cubic millimetre / Cubic millimeter (m=1)", 401, 12);
            this.addKeyWord("[cm3]", "(4.0) <Unit of volume> Cubic centimetre / Cubic centimeter (m=1)", 402, 12);
            this.addKeyWord("[m3]", "(4.0) <Unit of volume> Cubic metre / Cubic meter (m=1)", 403, 12);
            this.addKeyWord("[km3]", "(4.0) <Unit of volume> Cubic kilometre / Cubic kilometer (m=1)", 404, 12);
            this.addKeyWord("[ml]", "(4.0) <Unit of volume> Millilitre / Milliliter (m=1)", 405, 12);
            this.addKeyWord("[l]", "(4.0) <Unit of volume> Litre / Liter (m=1)", 406, 12);
            this.addKeyWord("[gall]", "(4.0) <Unit of volume> Gallon (m=1)", 407, 12);
            this.addKeyWord("[pint]", "(4.0) <Unit of volume> Pint (m=1)", 408, 12);
            this.addKeyWord("[s]", "(4.0) <Unit of time> Second (s=1)", 501, 12);
            this.addKeyWord("[ms]", "(4.0) <Unit of time> Millisecond (s=1)", 502, 12);
            this.addKeyWord("[min]", "(4.0) <Unit of time> Minute (s=1)", 503, 12);
            this.addKeyWord("[h]", "(4.0) <Unit of time> Hour (s=1)", 504, 12);
            this.addKeyWord("[day]", "(4.0) <Unit of time> Day (s=1)", 505, 12);
            this.addKeyWord("[week]", "(4.0) <Unit of time> Week (s=1)", 506, 12);
            this.addKeyWord("[yearj]", "(4.0) <Unit of time> Julian year = 365.25 days (s=1)", 507, 12);
            this.addKeyWord("[kg]", "(4.0) <Unit of mass> Kilogram (kg=1)", 508, 12);
            this.addKeyWord("[gr]", "(4.0) <Unit of mass> Gram (kg=1)", 509, 12);
            this.addKeyWord("[mg]", "(4.0) <Unit of mass> Milligram (kg=1)", 510, 12);
            this.addKeyWord("[dag]", "(4.0) <Unit of mass> Decagram (kg=1)", 511, 12);
            this.addKeyWord("[t]", "(4.0) <Unit of mass> Tonne (kg=1)", 512, 12);
            this.addKeyWord("[oz]", "(4.0) <Unit of mass> Ounce (kg=1)", 513, 12);
            this.addKeyWord("[lb]", "(4.0) <Unit of mass> Pound (kg=1)", 514, 12);
            this.addKeyWord("[b]", "(4.0) <Unit of information> Bit (bit=1)", 601, 12);
            this.addKeyWord("[kb]", "(4.0) <Unit of information> Kilobit (bit=1)", 602, 12);
            this.addKeyWord("[Mb]", "(4.0) <Unit of information> Megabit (bit=1)", 603, 12);
            this.addKeyWord("[Gb]", "(4.0) <Unit of information> Gigabit (bit=1)", 604, 12);
            this.addKeyWord("[Tb]", "(4.0) <Unit of information> Terabit (bit=1)", 605, 12);
            this.addKeyWord("[Pb]", "(4.0) <Unit of information> Petabit (bit=1)", 606, 12);
            this.addKeyWord("[Eb]", "(4.0) <Unit of information> Exabit (bit=1)", 607, 12);
            this.addKeyWord("[Zb]", "(4.0) <Unit of information> Zettabit (bit=1)", 608, 12);
            this.addKeyWord("[Yb]", "(4.0) <Unit of information> Yottabit (bit=1)", 609, 12);
            this.addKeyWord("[B]", "(4.0) <Unit of information> Byte (bit=1)", 610, 12);
            this.addKeyWord("[kB]", "(4.0) <Unit of information> Kilobyte (bit=1)", 611, 12);
            this.addKeyWord("[MB]", "(4.0) <Unit of information> Megabyte (bit=1)", 612, 12);
            this.addKeyWord("[GB]", "(4.0) <Unit of information> Gigabyte (bit=1)", 613, 12);
            this.addKeyWord("[TB]", "(4.0) <Unit of information> Terabyte (bit=1)", 614, 12);
            this.addKeyWord("[PB]", "(4.0) <Unit of information> Petabyte (bit=1)", 615, 12);
            this.addKeyWord("[EB]", "(4.0) <Unit of information> Exabyte (bit=1)", 616, 12);
            this.addKeyWord("[ZB]", "(4.0) <Unit of information> Zettabyte (bit=1)", 617, 12);
            this.addKeyWord("[YB]", "(4.0) <Unit of information> Yottabyte (bit=1)", 618, 12);
            this.addKeyWord("[J]", "(4.0) <Unit of energy> Joule (m=1, kg=1, s=1)", 701, 12);
            this.addKeyWord("[eV]", "(4.0) <Unit of energy> Electronovolt (m=1, kg=1, s=1)", 702, 12);
            this.addKeyWord("[keV]", "(4.0) <Unit of energy> Kiloelectronovolt (m=1, kg=1, s=1)", 703, 12);
            this.addKeyWord("[MeV]", "(4.0) <Unit of energy> Megaelectronovolt (m=1, kg=1, s=1)", 704, 12);
            this.addKeyWord("[GeV]", "(4.0) <Unit of energy> Gigaelectronovolt (m=1, kg=1, s=1)", 705, 12);
            this.addKeyWord("[TeV]", "(4.0) <Unit of energy> Teraelectronovolt (m=1, kg=1, s=1)", 706, 12);
            this.addKeyWord("[m/s]", "(4.0) <Unit of speed> Metre / Meter per second (m=1, s=1)", 801, 12);
            this.addKeyWord("[km/h]", "(4.0) <Unit of speed> Kilometre / Kilometer per hour (m=1, s=1)", 802, 12);
            this.addKeyWord("[mi/h]", "(4.0) <Unit of speed> Mile per hour (m=1, s=1)", 803, 12);
            this.addKeyWord("[knot]", "(4.0) <Unit of speed> Knot (m=1, s=1)", 804, 12);
            this.addKeyWord("[m/s2]", "(4.0) <Unit of acceleration> Metre / Meter per square second (m=1, s=1)", 901, 12);
            this.addKeyWord("[km/h2]", "(4.0) <Unit of acceleration> Kilometre / Kilometer per square hour (m=1, s=1)", 902, 12);
            this.addKeyWord("[mi/h2]", "(4.0) <Unit of acceleration> Mile per square hour (m=1, s=1)", 903, 12);
            this.addKeyWord("[rad]", "(4.0) <Unit of angle> Radian (rad=1)", 1001, 12);
            this.addKeyWord("[deg]", "(4.0) <Unit of angle> Degree of arc (rad=1)", 1002, 12);
            this.addKeyWord("[']", "(4.0) <Unit of angle> Minute of arc (rad=1)", 1003, 12);
            this.addKeyWord("['']", "(4.0) <Unit of angle> Second of arc (rad=1)", 1004, 12);
        }
        this.addKeyWord("(", "left parentheses", 1, 20);
        this.addKeyWord(")", "right parentheses", 2, 20);
        this.addKeyWord(",", "comma (function parameters)", 3, 20);
        this.addKeyWord(";", "semicolon (function parameters)", 3, 20);
        this.addKeyWord("[+-]?((0\\.[0-9]([0-9])*|(0|[1-9]([0-9])*)\\.[0-9]([0-9])*)|(0|[1-9]([0-9])*))([eE][+-]?(0|[1-9]([0-9])*))?", "regullar expression for decimal numbers", 1, 0);
    }

    private void addArgumentsKeyWords() {
        int argumentsNumber = this.argumentsList.size();
        for (int argumentIndex = 0; argumentIndex < argumentsNumber; ++argumentIndex) {
            Argument arg = this.argumentsList.get(argumentIndex);
            if (arg.getArgumentType() != 3) {
                this.addKeyWord(arg.getArgumentName(), arg.getDescription(), argumentIndex, 101);
                continue;
            }
            this.addKeyWord(arg.getArgumentName(), arg.getDescription(), argumentIndex, 102);
        }
    }

    private void addFunctionsKeyWords() {
        int functionsNumber = this.functionsList.size();
        for (int functionIndex = 0; functionIndex < functionsNumber; ++functionIndex) {
            Function fun = this.functionsList.get(functionIndex);
            this.addKeyWord(fun.getFunctionName(), fun.getDescription(), functionIndex, 103);
        }
    }

    private void addConstantsKeyWords() {
        int constantsNumber = this.constantsList.size();
        for (int constantIndex = 0; constantIndex < constantsNumber; ++constantIndex) {
            Constant c = this.constantsList.get(constantIndex);
            this.addKeyWord(c.getConstantName(), c.getDescription(), constantIndex, 104);
        }
    }

    private void addKeyWord(String wordString, String wordDescription, int wordId, int wordTypeId) {
        this.keyWordsList.add(new KeyWord(wordString, wordDescription, wordId, wordTypeId));
    }

    private void addToken(String tokenStr, KeyWord keyWord) {
        Token token = new Token();
        this.initialTokens.add(token);
        token.tokenStr = tokenStr;
        token.keyWord = keyWord.wordString;
        token.tokenId = keyWord.wordId;
        token.tokenTypeId = keyWord.wordTypeId;
        if (token.tokenTypeId == 101) {
            token.tokenValue = this.argumentsList.get((int)token.tokenId).argumentValue;
        } else if (token.tokenTypeId == 0) {
            token.tokenValue = Double.valueOf(token.tokenStr);
            token.keyWord = "_num_";
        }
    }

    private void tokenizeExpressionString() {
        char c;
        this.keyWordsList = new ArrayList();
        this.addParserKeyWords();
        if (!this.parserKeyWordsOnly) {
            this.addArgumentsKeyWords();
            this.addFunctionsKeyWords();
            this.addConstantsKeyWords();
        }
        Collections.sort(this.keyWordsList, new DescKwLenComparator());
        int numberKwId = -1;
        int plusKwId = -1;
        int minusKwId = -1;
        for (int kwId = 0; kwId < this.keyWordsList.size(); ++kwId) {
            if (this.keyWordsList.get((int)kwId).wordTypeId == 0) {
                numberKwId = kwId;
            }
            if (this.keyWordsList.get((int)kwId).wordTypeId != 1) continue;
            if (this.keyWordsList.get((int)kwId).wordId == 1) {
                plusKwId = kwId;
            }
            if (this.keyWordsList.get((int)kwId).wordId != 2) continue;
            minusKwId = kwId;
        }
        String newExpressionString = "";
        if (this.expressionString.length() > 0) {
            for (int i = 0; i < this.expressionString.length(); ++i) {
                c = this.expressionString.charAt(i);
                if (c == ' ' || c == '\n' || c == '\r' || c == '\t' || c == '\f') continue;
                newExpressionString = newExpressionString + c;
            }
        }
        this.initialTokens = new ArrayList();
        int lastPos = 0;
        int pos = 0;
        String tokenStr = "";
        int matchStatusPrev = -1;
        int matchStatus = -1;
        KeyWord kw = null;
        String sub = "";
        String kwStr = "";
        do {
            char followingChar;
            char precedingChar;
            int numEnd = -1;
            c = newExpressionString.charAt(pos);
            if (c == '+' || c == '-' || c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9') {
                for (int i = pos; i < newExpressionString.length() && (i <= pos || (c = newExpressionString.charAt(i)) == '+' || c == '-' || c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9' || c == '.' || c == 'e' || c == 'E'); ++i) {
                    String str = newExpressionString.substring(pos, i + 1);
                    if (!mXparser.regexMatch(str, "[+-]?((0\\.[0-9]([0-9])*|(0|[1-9]([0-9])*)\\.[0-9]([0-9])*)|(0|[1-9]([0-9])*))([eE][+-]?(0|[1-9]([0-9])*))?")) continue;
                    numEnd = i;
                }
            }
            if (numEnd >= 0 && pos > 0 && (precedingChar = newExpressionString.charAt(pos - 1)) != ',' && precedingChar != ';' && precedingChar != '|' && precedingChar != '&' && precedingChar != '+' && precedingChar != '-' && precedingChar != '*' && precedingChar != '\\' && precedingChar != '/' && precedingChar != '(' && precedingChar != ')' && precedingChar != '=' && precedingChar != '>' && precedingChar != '<' && precedingChar != '~' && precedingChar != '^' && precedingChar != '#' && precedingChar != '%' && precedingChar != '@' && precedingChar != '!') {
                numEnd = -1;
            }
            if (numEnd >= 0 && numEnd < newExpressionString.length() - 1 && (followingChar = newExpressionString.charAt(numEnd + 1)) != ',' && followingChar != ';' && followingChar != '|' && followingChar != '&' && followingChar != '+' && followingChar != '-' && followingChar != '*' && followingChar != '\\' && followingChar != '/' && followingChar != '(' && followingChar != ')' && followingChar != '=' && followingChar != '>' && followingChar != '<' && followingChar != '~' && followingChar != '^' && followingChar != '#' && followingChar != '%' && followingChar != '@' && followingChar != '!') {
                numEnd = -1;
            }
            if (numEnd >= 0) {
                if (matchStatusPrev == -1 && pos > 0) {
                    tokenStr = newExpressionString.substring(lastPos, pos);
                    this.addToken(tokenStr, new KeyWord());
                }
                char firstChar = newExpressionString.charAt(pos);
                boolean leadingOp = true;
                if (firstChar == '-' || firstChar == '+') {
                    if (this.initialTokens.size() > 0) {
                        Token lastToken = this.initialTokens.get(this.initialTokens.size() - 1);
                        leadingOp = !(lastToken.tokenTypeId == 1 && lastToken.tokenId != 6 || lastToken.tokenTypeId == 3 || lastToken.tokenTypeId == 2 || lastToken.tokenTypeId == 11 || lastToken.tokenTypeId == 20 && lastToken.tokenId == 1);
                    } else {
                        leadingOp = false;
                    }
                } else {
                    leadingOp = false;
                }
                if (leadingOp) {
                    if (firstChar == '-') {
                        this.addToken("-", this.keyWordsList.get(minusKwId));
                    }
                    if (firstChar == '+') {
                        this.addToken("+", this.keyWordsList.get(plusKwId));
                    }
                    ++pos;
                }
                tokenStr = newExpressionString.substring(pos, numEnd + 1);
                this.addToken(tokenStr, this.keyWordsList.get(numberKwId));
                lastPos = pos = numEnd + 1;
                matchStatus = 0;
                matchStatusPrev = 0;
                continue;
            }
            int kwId = -1;
            matchStatus = -1;
            do {
                kw = this.keyWordsList.get(++kwId);
                kwStr = kw.wordString;
                if (pos + kwStr.length() > newExpressionString.length()) continue;
                sub = newExpressionString.substring(pos, pos + kwStr.length());
                if (sub.equals(kwStr)) {
                    matchStatus = 0;
                }
                if (matchStatus != 0 || kw.wordTypeId != 101 && kw.wordTypeId != 102 && kw.wordTypeId != 4 && kw.wordTypeId != 5 && kw.wordTypeId != 6 && kw.wordTypeId != 7 && kw.wordTypeId != 9 && kw.wordTypeId != 104 && kw.wordTypeId != 10 && kw.wordTypeId != 12 && kw.wordTypeId != 103 && kw.wordTypeId != 8) continue;
                if (pos > 0 && (precedingChar = newExpressionString.charAt(pos - 1)) != ',' && precedingChar != ';' && precedingChar != '|' && precedingChar != '&' && precedingChar != '+' && precedingChar != '-' && precedingChar != '*' && precedingChar != '\\' && precedingChar != '/' && precedingChar != '(' && precedingChar != ')' && precedingChar != '=' && precedingChar != '>' && precedingChar != '<' && precedingChar != '~' && precedingChar != '^' && precedingChar != '#' && precedingChar != '%' && precedingChar != '@' && precedingChar != '!') {
                    matchStatus = -1;
                }
                if (matchStatus != 0 || pos + kwStr.length() >= newExpressionString.length() || (followingChar = newExpressionString.charAt(pos + kwStr.length())) == ',' || followingChar == ';' || followingChar == '|' || followingChar == '&' || followingChar == '+' || followingChar == '-' || followingChar == '*' || followingChar == '\\' || followingChar == '/' || followingChar == '(' || followingChar == ')' || followingChar == '=' || followingChar == '>' || followingChar == '<' || followingChar == '~' || followingChar == '^' || followingChar == '#' || followingChar == '%' || followingChar == '@' || followingChar == '!') continue;
                matchStatus = -1;
            } while (kwId < this.keyWordsList.size() - 1 && matchStatus == -1);
            if (matchStatus == 0) {
                if (matchStatusPrev == -1 && pos > 0) {
                    tokenStr = newExpressionString.substring(lastPos, pos);
                    this.addToken(tokenStr, new KeyWord());
                }
                matchStatusPrev = 0;
                tokenStr = newExpressionString.substring(pos, pos + kwStr.length());
                this.addToken(tokenStr, kw);
                lastPos = pos + kwStr.length();
                pos += kwStr.length();
                continue;
            }
            matchStatusPrev = -1;
            if (pos >= newExpressionString.length()) continue;
            ++pos;
        } while (pos < newExpressionString.length());
        if (matchStatus == -1) {
            tokenStr = newExpressionString.substring(lastPos, pos);
            this.addToken(tokenStr, new KeyWord());
        }
        this.evaluateTokensLevels();
    }

    private void evaluateTokensLevels() {
        int tokenLevel = 0;
        Stack<TokenStackElement> tokenStack = new Stack<TokenStackElement>();
        boolean precedingFunction = false;
        if (this.initialTokens.size() > 0) {
            for (int tokenIndex = 0; tokenIndex < this.initialTokens.size(); ++tokenIndex) {
                TokenStackElement stackEl;
                Token token = this.initialTokens.get(tokenIndex);
                if (token.tokenTypeId == 4 || token.tokenTypeId == 5 || token.tokenTypeId == 6 || token.tokenTypeId == 103 || token.tokenTypeId == 8 || token.tokenTypeId == 102 || token.tokenTypeId == 7) {
                    precedingFunction = true;
                } else if (token.tokenTypeId == 20 && token.tokenId == 1) {
                    stackEl = new TokenStackElement();
                    stackEl.tokenId = token.tokenId;
                    stackEl.tokenIndex = tokenIndex;
                    stackEl.tokenLevel = ++tokenLevel;
                    stackEl.tokenTypeId = token.tokenTypeId;
                    stackEl.precedingFunction = precedingFunction;
                    tokenStack.push(stackEl);
                    precedingFunction = false;
                } else {
                    precedingFunction = false;
                }
                token.tokenLevel = ++tokenLevel;
                if (token.tokenTypeId != 20 || token.tokenId != 2) continue;
                --tokenLevel;
                if (tokenStack.isEmpty()) continue;
                stackEl = (TokenStackElement)tokenStack.pop();
                if (!stackEl.precedingFunction) continue;
                --tokenLevel;
            }
        }
    }

    private void copyInitialTokens() {
        this.tokensList = new ArrayList();
        for (Token token : this.initialTokens) {
            this.tokensList.add(token.clone());
        }
    }

    public ArrayList<Token> getCopyOfInitialTokens() {
        String FUNCTION = "function";
        String ARGUMENT = "argument";
        String ERROR = "error";
        this.tokenizeExpressionString();
        ArrayList<Token> tokensListCopy = new ArrayList<Token>();
        for (int i = 0; i < this.initialTokens.size(); ++i) {
            Token token = this.initialTokens.get(i);
            if (token.tokenTypeId == -1) {
                if (mXparser.regexMatch(token.tokenStr, "([a-zA-Z_])+([a-zA-Z0-9_])*")) {
                    token.looksLike = "argument";
                    if (i < this.initialTokens.size() - 1) {
                        Token tokenNext = this.initialTokens.get(i + 1);
                        if (tokenNext.tokenTypeId == 20 && tokenNext.tokenId == 1) {
                            token.looksLike = "function";
                        }
                    }
                } else {
                    token.looksLike = "error";
                }
            }
            tokensListCopy.add(token.clone());
        }
        return tokensListCopy;
    }

    ArrayList<Token> getInitialTokens() {
        return this.initialTokens;
    }

    private static final String getLeftSpaces(String maxStr, String str) {
        String spc = "";
        for (int i = 0; i < maxStr.length() - str.length(); ++i) {
            spc = spc + " ";
        }
        return spc + str;
    }

    private static final String getRightSpaces(String maxStr, String str) {
        String spc = "";
        for (int i = 0; i < maxStr.length() - str.length(); ++i) {
            spc = " " + spc;
        }
        return str + spc;
    }

    private void showParsing(int lPos, int rPos) {
        mXparser.consolePrint(" ---> ");
        for (int i = lPos; i <= rPos; ++i) {
            Token token = this.tokensList.get(i);
            if (token.tokenTypeId == 0) {
                mXparser.consolePrint(token.tokenValue + " ");
                continue;
            }
            mXparser.consolePrint(token.tokenStr + " ");
        }
        mXparser.consolePrint(" ... ");
    }

    void showKeyWords() {
        int keyWordsNumber = this.keyWordsList.size();
        String maxStr = "KEY_WORD";
        mXparser.consolePrintln("KEY WORDS:");
        mXparser.consolePrintln(" -------------------------------------------");
        mXparser.consolePrintln("|      IDX | KEY_WORD |       ID |  TYPE_ID |");
        mXparser.consolePrintln(" -------------------------------------------");
        for (int keyWordIndex = 0; keyWordIndex < keyWordsNumber; ++keyWordIndex) {
            KeyWord keyWord = this.keyWordsList.get(keyWordIndex);
            String idxStr = Expression.getLeftSpaces(maxStr, Integer.toString(keyWordIndex));
            String wordStr = Expression.getLeftSpaces(maxStr, keyWord.wordString);
            String idStr = Expression.getLeftSpaces(maxStr, Integer.toString(keyWord.wordId));
            String typeIdStr = Expression.getLeftSpaces(maxStr, Integer.toString(keyWord.wordTypeId));
            mXparser.consolePrintln("| " + idxStr + " | " + wordStr + " | " + idStr + " | " + typeIdStr + " |");
        }
        mXparser.consolePrintln(" -------------------------------------------");
    }

    public String getHelp() {
        return this.getHelp("");
    }

    public String getHelp(String word) {
        this.keyWordsList = new ArrayList();
        String helpStr = "Help content: \n\n";
        this.addParserKeyWords();
        if (!this.parserKeyWordsOnly) {
            this.addArgumentsKeyWords();
            this.addFunctionsKeyWords();
            this.addConstantsKeyWords();
        }
        Collections.sort(this.keyWordsList, new KwTypeComparator());
        int keyWordsNumber = this.keyWordsList.size();
        for (int keyWordIndex = 0; keyWordIndex < keyWordsNumber; ++keyWordIndex) {
            KeyWord keyWord = this.keyWordsList.get(keyWordIndex);
            String type = "";
            String kw = keyWord.wordString;
            switch (keyWord.wordTypeId) {
                case 20: {
                    type = "Parser Symbol";
                    break;
                }
                case 0: {
                    type = "number";
                    kw = "_number_";
                    break;
                }
                case 1: {
                    type = "Operator";
                    break;
                }
                case 2: {
                    type = "Boolean Operator";
                    break;
                }
                case 3: {
                    type = "Binary Relation";
                    break;
                }
                case 4: {
                    type = "Unary Function";
                    break;
                }
                case 5: {
                    type = "Binary Function";
                    break;
                }
                case 6: {
                    type = "3-args Function";
                    break;
                }
                case 7: {
                    type = "Variadic Function";
                    break;
                }
                case 8: {
                    type = "Calculus Operator";
                    break;
                }
                case 10: {
                    type = "Random Variable";
                    break;
                }
                case 9: {
                    type = "Constant Value";
                    break;
                }
                case 101: {
                    type = "User defined argument";
                    break;
                }
                case 102: {
                    type = "User defined recursive argument";
                    break;
                }
                case 103: {
                    type = "User defined function";
                    break;
                }
                case 104: {
                    type = "User defined constant";
                    break;
                }
                case 12: {
                    type = "Unit";
                    break;
                }
                case 11: {
                    type = "Bitwise Operator";
                }
            }
            String line = Expression.getLeftSpaces("12345", Integer.toString(keyWordIndex + 1)) + ". " + Expression.getRightSpaces("01234567890123456789", kw) + Expression.getRightSpaces("                        ", "<" + type + ">") + keyWord.description + "\n";
            if (line.toLowerCase().indexOf(word.toLowerCase()) < 0) continue;
            helpStr = helpStr + line;
        }
        return helpStr;
    }

    void showTokens() {
        Expression.showTokens(this.tokensList);
    }

    static final void showTokens(ArrayList<Token> tokensList) {
        String maxStr = "TokenTypeId";
        mXparser.consolePrintln(" --------------------");
        mXparser.consolePrintln("| Expression tokens: |");
        mXparser.consolePrintln(" ---------------------------------------------------------------------------------------------------------------");
        mXparser.consolePrintln("|    TokenIdx |       Token |        KeyW |     TokenId | TokenTypeId |  TokenLevel |  TokenValue |   LooksLike |");
        mXparser.consolePrintln(" ---------------------------------------------------------------------------------------------------------------");
        if (tokensList == null) {
            mXparser.consolePrintln("NULL tokens list");
            return;
        }
        int tokensNumber = tokensList.size();
        for (int tokenIndex = 0; tokenIndex < tokensNumber; ++tokenIndex) {
            String tokenIndexStr = Expression.getLeftSpaces(maxStr, Integer.toString(tokenIndex));
            String tokenStr = Expression.getLeftSpaces(maxStr, tokensList.get((int)tokenIndex).tokenStr);
            String keyWordStr = Expression.getLeftSpaces(maxStr, tokensList.get((int)tokenIndex).keyWord);
            String tokenIdStr = Expression.getLeftSpaces(maxStr, Integer.toString(tokensList.get((int)tokenIndex).tokenId));
            String tokenTypeIdStr = Expression.getLeftSpaces(maxStr, Integer.toString(tokensList.get((int)tokenIndex).tokenTypeId));
            String tokenLevelStr = Expression.getLeftSpaces(maxStr, Integer.toString(tokensList.get((int)tokenIndex).tokenLevel));
            String tokenValueStr = Expression.getLeftSpaces(maxStr, Double.toString(tokensList.get((int)tokenIndex).tokenValue));
            String tokenLooksLikeStr = Expression.getLeftSpaces(maxStr, tokensList.get((int)tokenIndex).looksLike);
            mXparser.consolePrintln("| " + tokenIndexStr + " | " + tokenStr + " | " + keyWordStr + " | " + tokenIdStr + " | " + tokenTypeIdStr + " | " + tokenLevelStr + " | " + tokenValueStr + " | " + tokenLooksLikeStr + " |");
        }
        mXparser.consolePrintln(" ---------------------------------------------------------------------------------------------------------------");
    }

    void showInitialTokens() {
        Expression.showTokens(this.initialTokens);
    }

    private void showArguments() {
        for (Argument a : this.argumentsList) {
            boolean vMode = a.getVerboseMode();
            a.setSilentMode();
            this.printSystemInfo(a.getArgumentName() + " = " + a.getArgumentValue() + "\n", true);
            if (!vMode) continue;
            a.setVerboseMode();
        }
    }

    private void printSystemInfo(String info, boolean withExpressionString) {
        if (withExpressionString) {
            mXparser.consolePrint("[" + this.description + "]" + "[" + this.expressionString + "] " + info);
        } else {
            mXparser.consolePrint(info);
        }
    }

    protected Expression clone() {
        Expression newExp = new Expression(this);
        if (this.initialTokens != null && this.initialTokens.size() > 0) {
            newExp.initialTokens = this.createInitialTokens(0, this.initialTokens.size() - 1, this.initialTokens);
        }
        return newExp;
    }
}

