/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockout.Log;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.TextField;
import com.ldtteam.blockout.views.View;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.client.gui.AbstractWindowSkeleton;
import com.ldtteam.structurize.network.messages.MultiBlockChangeMessage;
import com.ldtteam.structurize.tileentities.TileEntityMultiBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.Nullable;

public class WindowMultiBlock
extends AbstractWindowSkeleton {
    private static final String RES_STRING = "textures/gui/buildtool/%s.png";
    private static final String GREEN_POS = "_green";
    private static final String RED_POS = "_red";
    private final BlockPos pos;
    private Direction facing = Direction.UP;
    private Direction output = Direction.DOWN;
    private final TextField inputRange;
    private final TextField inputSpeed;

    public WindowMultiBlock(@Nullable BlockPos pos) {
        super("structurize:gui/windowmultiblock.xml");
        this.pos = pos;
        this.inputRange = this.findPaneOfTypeByID("range", TextField.class);
        this.inputSpeed = this.findPaneOfTypeByID("speed", TextField.class);
        this.init();
    }

    private void init() {
        this.registerButton("confirm", this::confirmClicked);
        this.registerButton("cancel", this::cancelClicked);
        this.registerButton("left", this::moveLeftClicked);
        this.registerButton("right", this::moveRightClicked);
        this.registerButton("plus", this::moveUpClicked);
        this.registerButton("minus", this::moveDownClicked);
        this.registerButton("down", this::moveBackClicked);
        this.registerButton("up", this::moveForwardClicked);
    }

    @Override
    public void onOpened() {
        TileEntity block = Minecraft.func_71410_x().field_71441_e.func_175625_s(this.pos);
        if (block instanceof TileEntityMultiBlock) {
            this.inputRange.setText(Integer.toString(((TileEntityMultiBlock)block).getRange()));
            this.inputSpeed.setText(Integer.toString(((TileEntityMultiBlock)block).getSpeed()));
            Direction dir = ((TileEntityMultiBlock)block).getDirection();
            Direction out = ((TileEntityMultiBlock)block).getOutput();
            this.enable(dir, dir, false);
            this.enable(out, out, true);
            return;
        }
        this.close();
    }

    private void enable(Direction oldFacing, Direction newFacing, boolean rightClick) {
        switch (oldFacing) {
            case DOWN: {
                this.findPaneOfTypeByID("minus", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "minus")));
                break;
            }
            case NORTH: {
                this.findPaneOfTypeByID("up", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "up")));
                break;
            }
            case SOUTH: {
                this.findPaneOfTypeByID("down", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "down")));
                break;
            }
            case EAST: {
                this.findPaneOfTypeByID("right", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "right")));
                break;
            }
            case WEST: {
                this.findPaneOfTypeByID("left", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "left")));
                break;
            }
            default: {
                this.findPaneOfTypeByID("plus", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "plus")));
            }
        }
        String color = rightClick ? RED_POS : GREEN_POS;
        switch (newFacing) {
            case DOWN: {
                this.findPaneOfTypeByID("minus", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "minus" + color)));
                break;
            }
            case NORTH: {
                this.findPaneOfTypeByID("up", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "up" + color)));
                break;
            }
            case SOUTH: {
                this.findPaneOfTypeByID("down", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "down" + color)));
                break;
            }
            case EAST: {
                this.findPaneOfTypeByID("right", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "right" + color)));
                break;
            }
            case WEST: {
                this.findPaneOfTypeByID("left", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "left" + color)));
                break;
            }
            default: {
                this.findPaneOfTypeByID("plus", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "plus" + color)));
            }
        }
        if (rightClick) {
            this.output = newFacing;
        } else {
            this.facing = newFacing;
        }
    }

    private void moveUpClicked() {
        this.enable(this.facing, Direction.UP, false);
    }

    private void moveDownClicked() {
        this.enable(this.facing, Direction.DOWN, false);
    }

    private void moveLeftClicked() {
        this.enable(this.facing, Direction.WEST, false);
    }

    private void moveForwardClicked() {
        this.enable(this.facing, Direction.NORTH, false);
    }

    private void moveBackClicked() {
        this.enable(this.facing, Direction.SOUTH, false);
    }

    private void moveRightClicked() {
        this.enable(this.facing, Direction.EAST, false);
    }

    private void confirmClicked() {
        int range = 3;
        int speed = 2;
        try {
            range = Integer.valueOf(this.inputRange.getText());
            speed = Integer.valueOf(this.inputSpeed.getText());
        }
        catch (NumberFormatException e) {
            Log.getLogger().warn("Unable to parse number for MultiBlock range or speed, considering default range/speed!", (Throwable)e);
        }
        TileEntity block = Minecraft.func_71410_x().field_71441_e.func_175625_s(this.pos);
        if (block instanceof TileEntityMultiBlock) {
            ((TileEntityMultiBlock)block).setSpeed(speed);
            ((TileEntityMultiBlock)block).setRange(range);
            ((TileEntityMultiBlock)block).setOutput(this.output);
            ((TileEntityMultiBlock)block).setDirection(this.facing);
        }
        Network.getNetwork().sendToServer(new MultiBlockChangeMessage(this.pos, this.facing, this.output, range, speed));
        this.close();
    }

    @Override
    public boolean rightClick(double mx, double my) {
        Pane pane = this.findPaneForClick(mx, my);
        if (pane instanceof View) {
            pane = ((View)pane).findPaneForClick(mx, my);
        }
        if (pane instanceof ButtonImage && pane.isEnabled()) {
            Direction newFacing;
            switch (pane.getID()) {
                case "plus": {
                    newFacing = Direction.UP;
                    break;
                }
                case "minus": {
                    newFacing = Direction.DOWN;
                    break;
                }
                case "up": {
                    newFacing = Direction.NORTH;
                    break;
                }
                case "down": {
                    newFacing = Direction.SOUTH;
                    break;
                }
                case "right": {
                    newFacing = Direction.EAST;
                    break;
                }
                case "left": {
                    newFacing = Direction.WEST;
                    break;
                }
                default: {
                    newFacing = Direction.UP;
                }
            }
            this.enable(this.output, newFacing, true);
            return true;
        }
        return false;
    }

    private void cancelClicked() {
        this.close();
    }
}

