/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.commands;

import com.ldtteam.structurize.util.LanguageHandler;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandSource;

public abstract class AbstractCommand {
    protected static LiteralArgumentBuilder<CommandSource> build() {
        throw new RuntimeException("Missing command builder!");
    }

    protected static LiteralArgumentBuilder<CommandSource> newLiteral(String name) {
        return LiteralArgumentBuilder.literal((String)name);
    }

    protected static <T> RequiredArgumentBuilder<CommandSource, T> newArgument(String name, ArgumentType<T> type) {
        return RequiredArgumentBuilder.argument((String)name, type);
    }

    public static void throwSyntaxException(String key) throws CommandSyntaxException {
        throw new CommandSyntaxException((CommandExceptionType)new StructurizeCommandExceptionType(), (Message)new LiteralMessage(LanguageHandler.translateKey(key)));
    }

    public static void throwSyntaxException(String key, Object ... format) throws CommandSyntaxException {
        throw new CommandSyntaxException((CommandExceptionType)new StructurizeCommandExceptionType(), (Message)new LiteralMessage(LanguageHandler.translateKeyWithFormat(key, format)));
    }

    protected static class CommandTree {
        private final LiteralArgumentBuilder<CommandSource> rootNode;
        private final List<CommandTree> childNodes;

        protected CommandTree(String commandName) {
            this.rootNode = AbstractCommand.newLiteral(commandName);
            this.childNodes = new ArrayList<CommandTree>();
        }

        protected CommandTree addNode(CommandTree tree) {
            this.childNodes.add(tree);
            return this;
        }

        protected CommandTree addNode(LiteralArgumentBuilder<CommandSource> command) {
            this.rootNode.then((CommandNode)command.build());
            return this;
        }

        protected LiteralArgumentBuilder<CommandSource> build() {
            for (CommandTree ct : this.childNodes) {
                this.addNode(ct.build());
            }
            return this.rootNode;
        }
    }

    public static class StructurizeCommandExceptionType
    implements CommandExceptionType {
    }
}

