/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.items;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.blueprints.v1.BlueprintUtil;
import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.api.util.Utils;
import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.ldtteam.structurize.client.gui.WindowScan;
import com.ldtteam.structurize.items.AbstractItemWithPosSelector;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.network.messages.SaveScanMessage;
import com.ldtteam.structurize.util.LanguageHandler;
import com.ldtteam.structurize.util.StructureLoadingUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ItemScanTool
extends AbstractItemWithPosSelector {
    private static final String ANCHOR_POS_TKEY = "item.possetter.anchorpos";
    private static final String NBT_ANCHOR_POS = "structurize:anchor_pos";

    public ItemScanTool(ItemGroup itemGroup) {
        this(new Item.Properties().func_200918_c(0).setNoRepair().func_208103_a(Rarity.UNCOMMON).func_200916_a(itemGroup));
    }

    public ItemScanTool(Item.Properties properties) {
        super(properties);
        this.setRegistryName("sceptersteel");
    }

    @Override
    public ActionResultType onAirRightClick(BlockPos start, BlockPos end, World worldIn, PlayerEntity playerIn, ItemStack itemStack) {
        Optional<BlockPos> anchorPos;
        Optional<BlockPos> optional = anchorPos = itemStack.func_196082_o().func_74764_b(NBT_ANCHOR_POS) ? Optional.of(NBTUtil.func_186861_c((CompoundNBT)itemStack.func_196082_o().func_74775_l(NBT_ANCHOR_POS))) : Optional.empty();
        if (!worldIn.field_72995_K) {
            if (playerIn.func_225608_bj_()) {
                ItemScanTool.saveStructure(worldIn, start, end, playerIn, null, true, anchorPos);
            }
        } else if (!playerIn.func_225608_bj_()) {
            WindowScan window = new WindowScan(start, end, anchorPos);
            window.open();
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public AbstractItemWithPosSelector getRegisteredItemInstance() {
        return ModItems.scanTool;
    }

    public static void saveStructure(@NotNull World world, @NotNull BlockPos from, @NotNull BlockPos to, @NotNull PlayerEntity player, String name) {
        ItemScanTool.saveStructure(world, from, to, player, name, true, Optional.empty());
    }

    public static void saveStructure(@NotNull World world, @NotNull BlockPos from, @NotNull BlockPos to, @NotNull PlayerEntity player, String name, boolean saveEntities, Optional<BlockPos> anchorPos) {
        TileEntity te;
        if (anchorPos.isPresent()) {
            boolean isWithinZ;
            double minX = Math.min(to.func_177958_n(), from.func_177958_n());
            double minY = Math.min(to.func_177956_o(), from.func_177956_o());
            double minZ = Math.min(to.func_177952_p(), from.func_177952_p());
            double maxX = Math.max(to.func_177958_n(), from.func_177958_n());
            double maxY = Math.max(to.func_177956_o(), from.func_177956_o());
            double maxZ = Math.max(to.func_177952_p(), from.func_177952_p());
            double anchorPosX = anchorPos.get().func_177958_n();
            double anchorPosY = anchorPos.get().func_177956_o();
            double anchorPosZ = anchorPos.get().func_177952_p();
            boolean isWithinX = anchorPosX >= minX && anchorPosX <= maxX;
            boolean isWithinY = anchorPosY >= minY && anchorPosY <= maxY;
            boolean bl = isWithinZ = anchorPosZ >= minZ && anchorPosZ <= maxZ;
            if (!(isWithinX && isWithinY && isWithinZ)) {
                LanguageHandler.sendPlayerMessage(player, "item.sceptersteel.badanchorpos", new Object[0]);
                return;
            }
        }
        BlockPos blockpos = new BlockPos(Math.min(from.func_177958_n(), to.func_177958_n()), Math.min(from.func_177956_o(), to.func_177956_o()), Math.min(from.func_177952_p(), to.func_177952_p()));
        BlockPos blockpos1 = new BlockPos(Math.max(from.func_177958_n(), to.func_177958_n()), Math.max(from.func_177956_o(), to.func_177956_o()), Math.max(from.func_177952_p(), to.func_177952_p()));
        BlockPos size = blockpos1.func_177973_b((Vec3i)blockpos).func_177982_a(1, 1, 1);
        if (size.func_177958_n() * size.func_177956_o() * size.func_177952_p() > 100000) {
            LanguageHandler.sendPlayerMessage(player, "item.sceptersteel.toobig", 100000);
            return;
        }
        long currentMillis = System.currentTimeMillis();
        String currentMillisString = Long.toString(currentMillis);
        String fileName = name == null || name.isEmpty() ? LanguageHandler.format("item.sceptersteel.scanformat", "", currentMillisString) : name;
        if (anchorPos.isPresent() && (te = world.func_175625_s(anchorPos.get())) instanceof IBlueprintDataProvider) {
            ((IBlueprintDataProvider)te).setSchematicName(fileName);
            ((IBlueprintDataProvider)te).setCorners(from.func_177973_b((Vec3i)anchorPos.get()), to.func_177973_b((Vec3i)anchorPos.get()));
        }
        Blueprint bp = BlueprintUtil.createBlueprint(world, blockpos, saveEntities, (short)size.func_177958_n(), (short)size.func_177956_o(), (short)size.func_177952_p(), name, anchorPos);
        Network.getNetwork().sendToPlayer(new SaveScanMessage(BlueprintUtil.writeBlueprintToNBT(bp), fileName), (ServerPlayerEntity)player);
    }

    public static boolean saveStructureOnServer(@NotNull World world, @NotNull BlockPos from, @NotNull BlockPos to, String name) {
        return ItemScanTool.saveStructureOnServer(world, from, to, name, true);
    }

    public static boolean saveStructureOnServer(@NotNull World world, @NotNull BlockPos from, @NotNull BlockPos to, String name, boolean saveEntities) {
        BlockPos blockpos = new BlockPos(Math.min(from.func_177958_n(), to.func_177958_n()), Math.min(from.func_177956_o(), to.func_177956_o()), Math.min(from.func_177952_p(), to.func_177952_p()));
        BlockPos blockpos1 = new BlockPos(Math.max(from.func_177958_n(), to.func_177958_n()), Math.max(from.func_177956_o(), to.func_177956_o()), Math.max(from.func_177952_p(), to.func_177952_p()));
        BlockPos size = blockpos1.func_177973_b((Vec3i)blockpos).func_177982_a(1, 1, 1);
        if (size.func_177958_n() * size.func_177956_o() * size.func_177952_p() > 100000) {
            Log.getLogger().warn("Saving too large schematic for:" + name);
        }
        String prefix = "cache";
        String fileName = name == null || name.isEmpty() ? LanguageHandler.format("item.sceptersteel.scanformat", new Object[0]) : name;
        StructureName structureName = new StructureName("cache", "backup", fileName);
        List<File> folder = StructureLoadingUtils.getCachedSchematicsFolders();
        if (folder == null || folder.isEmpty()) {
            Log.getLogger().warn("Unable to save schematic in cache since no folder was found.");
            return false;
        }
        Blueprint bp = BlueprintUtil.createBlueprint(world, blockpos, saveEntities, (short)size.func_177958_n(), (short)size.func_177956_o(), (short)size.func_177952_p(), name, Optional.empty());
        File file = new File(folder.get(0), structureName.toString() + ".blueprint");
        Utils.checkDirectory(file.getParentFile());
        try (FileOutputStream outputstream = new FileOutputStream(file);){
            CompressedStreamTools.func_74799_a((CompoundNBT)BlueprintUtil.writeBlueprintToNBT(bp), (OutputStream)outputstream);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public ActionResultType onSpecialUse(ItemUseContext context) {
        TileEntity te;
        BlockPos pos = context.func_195995_a();
        if (context.func_195991_k().func_201670_d() && context.func_195999_j() != null) {
            LanguageHandler.sendMessageToPlayer(context.func_195999_j(), ANCHOR_POS_TKEY, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        if ((te = context.func_195991_k().func_175625_s(context.func_195995_a())) instanceof IBlueprintDataProvider) {
            Settings.instance.setStructureName(((IBlueprintDataProvider)te).getSchematicName());
            Settings.instance.setBox(((IBlueprintDataProvider)te).getCornerPositions());
            context.func_195996_i().func_196082_o().func_218657_a("structurize:start_pos", (INBT)NBTUtil.func_186859_a((BlockPos)((BlockPos)((IBlueprintDataProvider)te).getCornerPositions().func_76341_a()).func_177971_a((Vec3i)pos)));
            context.func_195996_i().func_196082_o().func_218657_a("structurize:end_pos", (INBT)NBTUtil.func_186859_a((BlockPos)((BlockPos)((IBlueprintDataProvider)te).getCornerPositions().func_76340_b()).func_177971_a((Vec3i)pos)));
        }
        context.func_195996_i().func_196082_o().func_218657_a(NBT_ANCHOR_POS, (INBT)NBTUtil.func_186859_a((BlockPos)pos));
        return ActionResultType.SUCCESS;
    }
}

