/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.management;

import com.ldtteam.structurize.util.LanguageHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class StructureName {
    public static List<String> HUTS = new ArrayList<String>();
    private static final Pattern levelPattern = Pattern.compile("[^0-9]+([0-9]+)$");
    private static final String LOCALIZED_SCHEMATIC_LEVEL = "com.ldtteam.structurize.gui.buildtool.hut.level";
    private String section = "";
    private String prefix = "";
    private String style = "";
    private String schematic = "";
    private String hut = "";

    public StructureName(@NotNull String structureName) {
        this.init(structureName);
    }

    public StructureName(@NotNull String prefix, String style, @NotNull String schematic) {
        StringBuilder name = new StringBuilder(prefix);
        if (style != null && !style.isEmpty()) {
            name.append("/").append(style);
        }
        name.append("/").append(schematic);
        this.init(name.toString());
    }

    private void init(@NotNull String structureName) {
        if (structureName.isEmpty()) {
            return;
        }
        String name = structureName;
        if (name.startsWith("scans/")) {
            this.prefix = "scans";
        } else if (name.startsWith("cache/")) {
            this.prefix = "cache";
        } else {
            if (!name.startsWith("schematics/")) {
                name = "schematics/" + name;
            }
            this.prefix = "schematics";
        }
        name = name.substring(this.prefix.length() + 1);
        int lastSeparator = name.lastIndexOf("/");
        if (lastSeparator == -1) {
            this.schematic = name;
        } else {
            this.style = name.substring(0, lastSeparator);
            this.schematic = name.substring(lastSeparator + 1);
        }
        this.section = this.prefix;
        if (this.prefix.equals("schematics")) {
            this.hut = this.schematic.split("\\d+")[0];
            this.section = "schematics";
            if (ForgeRegistries.BLOCKS.getValue(new ResourceLocation("minecolonies", "blockhut" + this.hut)) != Blocks.field_150350_a || HUTS.contains(this.hut)) {
                this.section = this.hut;
            } else {
                this.hut = "";
            }
        }
    }

    public String getHutName() {
        return this.hut;
    }

    public String getSection() {
        return this.section;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getStyle() {
        return this.style;
    }

    public String getSchematic() {
        return this.schematic;
    }

    public String getLocalizedName() {
        Matcher matcher;
        if (this.isHut() && (matcher = levelPattern.matcher(this.schematic)).find()) {
            int level = Integer.parseInt(matcher.group(1));
            return LanguageHandler.format(LOCALIZED_SCHEMATIC_LEVEL, level);
        }
        return this.schematic;
    }

    public boolean isHut() {
        return !this.hut.isEmpty();
    }

    public String toString() {
        if (this.style == null || this.style.isEmpty()) {
            return this.prefix + "/" + this.schematic;
        }
        return this.prefix + "/" + this.style + "/" + this.schematic;
    }
}

