/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.management.linksession.LinkSessionManager;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BackUpHelper {
    private static final String FILENAME_EXT_OLD = ".old";
    private static final String FILENAME_EXT_DAT = ".dat";
    private static final String FILENAME_STRUCTURIZE_PATH = "structurize";
    private static final String FILENAME_LINKSESSION = "_linksession";
    private static final DateTimeFormatter BACKUP_TIMESTAMP = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH.mm.ss");

    private BackUpHelper() {
    }

    public static void saveLinkSessionManager() {
        CompoundNBT data = LinkSessionManager.INSTANCE.serializeNBT();
        File file = BackUpHelper.getSaveLocation(FILENAME_LINKSESSION);
        BackUpHelper.cycleNewBackup(FILENAME_LINKSESSION, 2);
        BackUpHelper.saveNBTToPath(file, data);
    }

    public static void loadLinkSessionManager() {
        File file = BackUpHelper.getSaveLocation(FILENAME_LINKSESSION);
        CompoundNBT data = BackUpHelper.loadNBTFromPath(file);
        if (data != null) {
            LinkSessionManager.INSTANCE.deserializeNBT(data);
        }
    }

    private static void cycleNewBackup(@NotNull String additionalPath, @NotNull int cycleUpToNFiles) {
        File current = BackUpHelper.getSaveLocation(additionalPath);
        File newBackup = BackUpHelper.getBackupSaveLocation(additionalPath, LocalDateTime.now());
        if (!current.exists() || BackUpHelper.getSaveDir().list() == null) {
            return;
        }
        current.renameTo(newBackup);
        Supplier<Stream> allBackups = () -> Stream.of(BackUpHelper.getSaveDir().list()).filter(fileName -> fileName.contains(FILENAME_EXT_OLD) && fileName.contains(FILENAME_STRUCTURIZE_PATH + additionalPath));
        if (allBackups.get().count() > (long)cycleUpToNFiles) {
            AtomicInteger toRemove = new AtomicInteger((int)allBackups.get().count() - cycleUpToNFiles);
            allBackups.get().map(fileName -> BackUpHelper.getTimestampFromBackup(additionalPath, fileName)).sorted().filter(a -> toRemove.getAndDecrement() > 0).map(datetime -> BackUpHelper.getBackupSaveLocation(additionalPath, datetime)).forEach(fileToRemove -> fileToRemove.delete());
        }
    }

    @NotNull
    private static File getSaveDir() {
        return new File(ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.field_223227_a_).func_217485_w().func_75765_b(), FILENAME_STRUCTURIZE_PATH);
    }

    @NotNull
    private static File getSaveLocation(@NotNull String additionalPath) {
        return new File(BackUpHelper.getSaveDir(), FILENAME_STRUCTURIZE_PATH + additionalPath + FILENAME_EXT_DAT);
    }

    @NotNull
    private static File getBackupSaveLocation(@NotNull String additionalPath, @NotNull LocalDateTime date) {
        return new File(BackUpHelper.getSaveDir(), String.format(FILENAME_STRUCTURIZE_PATH + additionalPath + "-%s" + FILENAME_EXT_DAT + FILENAME_EXT_OLD, BACKUP_TIMESTAMP.format(date)));
    }

    @NotNull
    private static LocalDateTime getTimestampFromBackup(@NotNull String additionalPath, @NotNull String fileName) {
        return LocalDateTime.parse(fileName.replace(FILENAME_STRUCTURIZE_PATH + additionalPath + "-", "").replace(".dat.old", ""), BACKUP_TIMESTAMP);
    }

    public static void saveNBTToPath(@Nullable File file, @NotNull CompoundNBT compound) {
        try {
            if (file != null) {
                file.getParentFile().mkdir();
                CompressedStreamTools.func_74793_a((CompoundNBT)compound, (File)file);
            }
        }
        catch (IOException exception) {
            Log.getLogger().error("Exception when saving data into external file!", (Throwable)exception);
        }
    }

    public static CompoundNBT loadNBTFromPath(@Nullable File file) {
        try {
            if (file != null && file.exists()) {
                return CompressedStreamTools.func_74797_a((File)file);
            }
        }
        catch (IOException exception) {
            Log.getLogger().error("Exception when loading data from external file!", (Throwable)exception);
        }
        return null;
    }
}

