/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.mgui.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;

public class GuiString
extends GuiElement {
    protected String string;
    protected FontRenderer fontRenderer;
    protected int color = -1;
    protected boolean drawShadow = true;
    protected boolean fixedWidth = false;

    public GuiString(int x, int y, String string) {
        super(x, y, 0, 9);
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.string = string;
        this.width = this.fontRenderer.func_78256_a(string);
    }

    public GuiString(int x, int y, int width, String string) {
        super(x, y, width, 9);
        this.fixedWidth = true;
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.string = this.fontRenderer.func_78269_a(string, width);
    }

    public GuiString(int x, int y, String string, GuiAttachment attachment) {
        this(x, y, string);
        this.attachmentPoint = attachment;
    }

    public GuiString(int x, int y, String string, int color) {
        this(x, y, string);
        this.color = color;
    }

    public GuiString(int x, int y, String string, int color, GuiAttachment attachment) {
        this(x, y, string, attachment);
        this.color = color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setString(String string) {
        if (string != null && !string.equals(this.string)) {
            if (this.fixedWidth) {
                this.string = this.fontRenderer.func_78269_a(string, this.width);
            } else {
                this.string = string;
                this.width = this.fontRenderer.func_78256_a(string);
            }
        }
    }

    public GuiString setShadow(boolean shadow) {
        this.drawShadow = shadow;
        return this;
    }

    @Override
    public void draw(MatrixStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        this.activeAnimations.removeIf(keyframeAnimation -> !keyframeAnimation.isActive());
        this.activeAnimations.forEach(KeyframeAnimation::preDraw);
        RenderSystem.enableBlend();
        this.drawString(matrixStack, this.string, refX + this.x, refY + this.y, this.color, opacity * this.getOpacity(), this.drawShadow);
    }

    protected void drawString(MatrixStack matrixStack, String text, int x, int y, int color, float opacity, boolean drawShadow) {
        if (((color = GuiString.colorWithOpacity(color, opacity)) & 0xFC000000) != 0) {
            IRenderTypeBuffer.Impl renderTypeBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            this.fontRenderer.func_228079_a_(text, (float)x, (float)y, color, drawShadow, matrixStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)renderTypeBuffer, false, 0, 0xF000F0);
            renderTypeBuffer.func_228461_a_();
        }
    }
}

