/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.api.material;

import com.terraforged.mod.Log;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;

public class WGTags {
    public static final Tag<Block> STONE = WGTags.tag("forge:wg_stone");
    public static final Tag<Block> DIRT = WGTags.tag("forge:wg_dirt");
    public static final Tag<Block> CLAY = WGTags.tag("forge:wg_clay");
    public static final Tag<Block> SEDIMENT = WGTags.tag("forge:wg_sediment");
    public static final Tag<Block> ERODIBLE = WGTags.tag("forge:wg_erodible");
    private static final List<Tag<Block>> WG_TAGS = Collections.unmodifiableList(Arrays.asList(STONE, DIRT, CLAY, SEDIMENT, ERODIBLE));

    public static void init() {
    }

    private static Tag<Block> tag(String name) {
        return new BlockTags.Wrapper(new ResourceLocation(name));
    }

    public static Predicate<BlockState> stone() {
        return WGTags.toStatePredicate(STONE);
    }

    private static Predicate<BlockState> toStatePredicate(Tag<Block> tag) {
        return state -> tag.func_199685_a_((Object)state.func_177230_c());
    }

    public static void printTags() {
        for (Tag<Block> tag : WG_TAGS) {
            Log.debug("World-Gen Tag: {}", tag.func_199886_b());
            for (Block block : tag.func_199885_a()) {
                Log.debug(" - {}", block.getRegistryName());
            }
        }
    }
}

