/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class LazyCallable<T>
implements Callable<T>,
Future<T> {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private T value = null;

    @Override
    public final T call() {
        this.lock.readLock().lock();
        T result = this.value;
        this.lock.readLock().unlock();
        if (result == null) {
            this.lock.writeLock().lock();
            result = this.value;
            if (result == null) {
                this.value = result = this.create();
            }
            this.lock.writeLock().unlock();
        }
        return result;
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public final boolean isCancelled() {
        return false;
    }

    @Override
    public final boolean isDone() {
        this.lock.readLock().lock();
        T result = this.value;
        this.lock.readLock().unlock();
        return result != null;
    }

    @Override
    public final T get() {
        return this.call();
    }

    @Override
    public final T get(long timeout, TimeUnit unit) {
        return this.call();
    }

    protected abstract T create();
}

