/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.render;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.concurrent.cache.CacheEntry;
import com.terraforged.core.concurrent.thread.ThreadPool;
import com.terraforged.core.render.RegionRenderer;
import com.terraforged.core.render.RenderAPI;
import com.terraforged.core.render.RenderRegion;
import com.terraforged.core.render.RenderSettings;
import com.terraforged.core.tile.Size;
import com.terraforged.core.tile.Tile;
import com.terraforged.core.tile.gen.TileGenerator;

public class RenderWorld {
    private final int regionCount;
    private final Size regionSize;
    private final RenderAPI context;
    private final ThreadPool threadPool;
    private final RegionRenderer renderer;
    private final TileGenerator generator;
    private final RenderRegion[] view;
    private final CacheEntry<RenderRegion>[] queue;

    public RenderWorld(ThreadPool threadPool, TileGenerator generator, RenderAPI context, RenderSettings settings, int regionCount, int regionSize) {
        this.threadPool = threadPool;
        this.context = context;
        this.generator = generator;
        this.regionCount = regionCount;
        this.renderer = new RegionRenderer(context, settings);
        this.regionSize = Size.blocks(regionSize, 0);
        this.queue = new CacheEntry[regionCount * regionCount];
        this.view = new RenderRegion[regionCount * regionCount];
    }

    public int getResolution() {
        return this.regionSize.total;
    }

    public int getSize() {
        return this.regionSize.total * this.regionCount;
    }

    public boolean isRendering() {
        for (CacheEntry<RenderRegion> entry : this.queue) {
            if (entry == null) continue;
            return true;
        }
        return false;
    }

    public Cell getCenter() {
        float cx = (float)this.regionCount / 2.0f;
        int rx = (int)cx;
        float cz = (float)this.regionCount / 2.0f;
        int rz = (int)cz;
        int index = rx + this.regionCount * rz;
        RenderRegion renderRegion = this.view[index];
        if (renderRegion == null) {
            return Cell.empty();
        }
        float ox = cx - (float)rx;
        float oz = cz - (float)rz;
        Tile tile = renderRegion.getTile();
        int dx = (int)((float)tile.getBlockSize().size * ox);
        int dz = (int)((float)tile.getBlockSize().size * oz);
        return tile.getCell(dx, dz);
    }

    public void redraw() {
        for (RenderRegion region : this.view) {
            if (region == null) continue;
            this.renderer.render(region);
        }
    }

    public void refresh() {
        for (CacheEntry<RenderRegion> entry : this.queue) {
            if (entry == null || entry.isDone()) continue;
            return;
        }
        for (int i = 0; i < this.queue.length; ++i) {
            CacheEntry<RenderRegion> entry = this.queue[i];
            if (entry == null || !entry.isDone()) continue;
            this.queue[i] = null;
            this.view[i] = entry.get();
        }
    }

    public void update(float x, float y, float zoom, boolean filters) {
        this.renderer.getSettings().zoom = zoom;
        this.renderer.getSettings().resolution = this.getResolution();
        float factor = this.regionCount > 1 ? ((float)this.regionCount - 1.0f) / (float)this.regionCount : 0.0f;
        float offset = (float)this.regionSize.size * zoom * factor;
        for (int rz = 0; rz < this.regionCount; ++rz) {
            for (int rx = 0; rx < this.regionCount; ++rx) {
                int index = rx + rz * this.regionCount;
                float px = x + (float)(rx * this.regionSize.size) * zoom - offset;
                float py = y + (float)(rz * this.regionSize.size) * zoom - offset;
                this.queue[index] = this.generator.getAsync(px, py, zoom, filters).then(this.threadPool, this.renderer::render);
            }
        }
    }

    public void render() {
        int resolution = this.getResolution();
        float w = (float)this.renderer.getSettings().width / (float)(resolution - 1);
        float h = (float)this.renderer.getSettings().width / (float)(resolution - 1);
        float offsetX = (float)(this.regionSize.size * this.regionCount) * w / 2.0f;
        float offsetY = (float)(this.regionSize.size * this.regionCount) * w / 2.0f;
        this.context.pushMatrix();
        this.context.translate(-offsetX, -offsetY, 0.0f);
        for (int rz = 0; rz < this.regionCount; ++rz) {
            for (int rx = 0; rx < this.regionCount; ++rx) {
                int index = rx + rz * this.regionCount;
                RenderRegion region = this.view[index];
                if (region == null) continue;
                this.context.pushMatrix();
                float x = (float)(rx * this.regionSize.size) * w;
                float z = (float)(rz * this.regionSize.size) * h;
                this.context.translate(x, z, 0.0f);
                region.getMesh().draw();
                this.context.popMatrix();
            }
        }
        this.context.popMatrix();
    }
}

