/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.settings;

import com.terraforged.core.serialization.annotation.Comment;
import com.terraforged.core.serialization.annotation.Range;
import com.terraforged.core.serialization.annotation.Serializable;

@Serializable
public class FilterSettings {
    public Erosion erosion = new Erosion();
    public Smoothing smoothing = new Smoothing();

    @Serializable
    public static class Smoothing {
        @Range(min=0.0f, max=5.0f)
        @Comment(value={"Controls the number of smoothing iterations"})
        public int iterations = 1;
        @Range(min=0.0f, max=5.0f)
        @Comment(value={"Controls the smoothing radius"})
        public float smoothingRadius = 1.75f;
        @Range(min=0.0f, max=1.0f)
        @Comment(value={"Controls how strongly smoothing is applied"})
        public float smoothingRate = 0.85f;
    }

    @Serializable
    public static class Erosion {
        @Range(min=1000.0f, max=50000.0f)
        @Comment(value={"Controls the number of erosion iterations"})
        public int iterations = 15000;
        @Range(min=0.0f, max=1.0f)
        @Comment(value={"Controls how quickly material dissolves (during erosion)"})
        public float erosionRate = 0.5f;
        @Range(min=0.0f, max=1.0f)
        @Comment(value={"Controls how quickly material is deposited (during erosion)"})
        public float depositeRate = 0.5f;
        @Range(min=1.0f, max=50.0f)
        @Comment(value={"Controls the number of iterations that a single water droplet is simulated for"})
        public int dropletLifetime = 25;
        @Range(min=0.0f, max=1.0f)
        @Comment(value={"Controls the starting volume of water that a simulated water droplet carries"})
        public float dropletVolume = 0.7f;
        @Range(min=0.1f, max=1.0f)
        @Comment(value={"Controls the starting velocity of the simulated water droplet"})
        public float dropletVelocity = 0.7f;

        public Erosion copy() {
            Erosion erosion = new Erosion();
            erosion.iterations = this.iterations;
            erosion.erosionRate = this.erosionRate;
            erosion.depositeRate = this.depositeRate;
            erosion.dropletLifetime = this.dropletLifetime;
            erosion.dropletVolume = this.dropletVolume;
            erosion.dropletVelocity = this.dropletVelocity;
            return erosion;
        }
    }
}

