/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.fm.matcher.biome;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.terraforged.fm.matcher.biome.BiomeMatcher;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeMatcherParser {
    public static Optional<BiomeMatcher> parse(JsonObject root) {
        if (root.has("biomes")) {
            return BiomeMatcherParser.parse(root.get("biomes"));
        }
        return Optional.of(BiomeMatcher.ANY);
    }

    public static Optional<BiomeMatcher> parse(JsonElement element) {
        Collector collector = new Collector();
        if (element.isJsonPrimitive()) {
            String biome = element.getAsString();
            if (biome.equals("*")) {
                return Optional.of(BiomeMatcher.ANY);
            }
            BiomeMatcherParser.collectBiomes(biome, collector);
        } else if (element.isJsonArray()) {
            for (JsonElement e : element.getAsJsonArray()) {
                BiomeMatcherParser.collectBiomes(e.getAsString(), collector);
            }
        }
        if (collector.first == null) {
            return Optional.empty();
        }
        if (collector.all.size() == 1) {
            return Optional.of(BiomeMatcher.of(collector.first));
        }
        return Optional.of(BiomeMatcher.of(collector.all));
    }

    private static void collectBiomes(String biome, Collector collector) {
        if (biome.endsWith("*")) {
            biome = biome.substring(0, biome.length() - 1);
            for (Biome b : ForgeRegistries.BIOMES) {
                String name = b.getRegistryName() + "";
                if (!name.startsWith(biome)) continue;
                collector.add(b);
            }
        } else if (biome.contains("*")) {
            String[] parts = biome.split("\\*");
            if (parts.length == 2) {
                for (Biome b : ForgeRegistries.BIOMES) {
                    String name = b.getRegistryName() + "";
                    if (!name.startsWith(parts[0]) || !name.endsWith(parts[1])) continue;
                    collector.add(b);
                }
            }
        } else {
            ResourceLocation name = new ResourceLocation(biome);
            if (ForgeRegistries.BIOMES.containsKey(name)) {
                collector.add((Biome)ForgeRegistries.BIOMES.getValue(name));
            }
        }
    }

    private static class Collector {
        private Biome first = null;
        private Set<Biome> all = Collections.emptySet();

        private Collector() {
        }

        private void add(Biome biome) {
            if (this.first == null) {
                this.first = biome;
            }
            if (this.all.isEmpty()) {
                this.all = new HashSet<Biome>();
            }
            this.all.add(biome);
        }
    }
}

