/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.fm.modifier;

import com.google.gson.JsonElement;
import com.terraforged.fm.FeatureManager;
import com.terraforged.fm.FeatureSerializer;
import com.terraforged.fm.biome.BiomeFeature;
import com.terraforged.fm.matcher.dynamic.DynamicList;
import com.terraforged.fm.matcher.dynamic.DynamicPredicate;
import com.terraforged.fm.modifier.Modifier;
import com.terraforged.fm.modifier.ModifierList;
import com.terraforged.fm.modifier.ModifierSet;
import com.terraforged.fm.predicate.BiomePredicate;
import com.terraforged.fm.predicate.FeaturePredicate;
import com.terraforged.fm.transformer.FeatureAppender;
import com.terraforged.fm.transformer.FeatureInjector;
import com.terraforged.fm.transformer.FeatureReplacer;
import com.terraforged.fm.transformer.FeatureTransformer;
import com.terraforged.fm.transformer.InjectionPosition;
import com.terraforged.fm.util.FeatureDebugger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraftforge.eventbus.api.Event;

public class FeatureModifiers
extends Event {
    private final DynamicList dynamics = new DynamicList();
    private final ModifierList<FeatureReplacer> replacers = new ModifierList();
    private final ModifierList<FeatureInjector> injectors = new ModifierList();
    private final ModifierList<FeatureAppender> appenders = new ModifierList();
    private final ModifierList<FeaturePredicate> predicates = new ModifierList();
    private final ModifierList<FeatureTransformer> transformers = new ModifierList();

    public DynamicList getDynamic() {
        return this.dynamics;
    }

    public ModifierList<FeatureReplacer> getReplacers() {
        return this.replacers;
    }

    public ModifierList<FeatureInjector> getInjectors() {
        return this.injectors;
    }

    public ModifierList<FeatureAppender> getAppenders() {
        return this.appenders;
    }

    public ModifierList<FeaturePredicate> getPredicates() {
        return this.predicates;
    }

    public ModifierList<FeatureTransformer> getTransformers() {
        return this.transformers;
    }

    public void sort() {
        this.replacers.sort();
        this.predicates.sort();
        this.transformers.sort();
    }

    public List<BiomeFeature> getAppenders(GenerationStage.Decoration stage, Biome biome, InjectionPosition position) {
        return this.getAppenders(stage, position, biome);
    }

    public ModifierSet getFeature(GenerationStage.Decoration stage, Biome biome, ConfiguredFeature<?, ?> feature) {
        try {
            FeaturePredicate predicate;
            JsonElement element = FeatureSerializer.serialize(feature);
            ConfiguredFeature<?, ?> result = this.getFeature(biome, feature, element);
            if (result != feature) {
                element = FeatureSerializer.serialize(result);
            }
            if ((predicate = this.getPredicate(result)) == null) {
                predicate = this.getPredicate(biome, element);
            }
            List<BiomeFeature> before = this.getInjectors(biome, predicate, element, InjectionPosition.BEFORE);
            List<BiomeFeature> after = this.getInjectors(biome, predicate, element, InjectionPosition.AFTER);
            return new ModifierSet(new BiomeFeature(predicate, result), before, after);
        }
        catch (Throwable t) {
            String name = biome.getRegistryName() + "";
            List<String> errors = FeatureDebugger.getErrors(feature);
            FeatureManager.LOG.debug(FeatureSerializer.MARKER, "Unable to serialize feature in biome: {}", (Object)name);
            if (errors.isEmpty()) {
                FeatureManager.LOG.debug("Unable to determine issues. See stacktrace:", t);
            } else {
                for (String error : errors) {
                    FeatureManager.LOG.debug(FeatureSerializer.MARKER, " - {}", (Object)error);
                }
            }
            return new ModifierSet(new BiomeFeature(FeaturePredicate.ALLOW, feature));
        }
    }

    private ConfiguredFeature<?, ?> getFeature(Biome biome, ConfiguredFeature<?, ?> feature, JsonElement element) {
        for (Modifier<FeatureReplacer> modifier : this.replacers) {
            if (!modifier.getMatcher().test(biome, element)) continue;
            return modifier.getModifier().get();
        }
        boolean modified = false;
        for (Modifier<FeatureTransformer> modifier : this.transformers) {
            if (!modifier.getMatcher().test(biome, element)) continue;
            modified = true;
            element = modifier.getModifier().apply(element);
        }
        if (!modified) {
            return feature;
        }
        try {
            return FeatureSerializer.deserializeUnchecked(element);
        }
        catch (Throwable throwable) {
            FeatureManager.LOG.warn(FeatureSerializer.MARKER, "Unable to deserialize biome feature: {}", (Object)biome);
            throwable.printStackTrace();
            return feature;
        }
    }

    private List<BiomeFeature> getInjectors(Biome biome, FeaturePredicate predicate, JsonElement element, InjectionPosition type) {
        List<BiomeFeature> result = Collections.emptyList();
        for (Modifier<FeatureInjector> modifier : this.getInjectors()) {
            if (modifier.getModifier().getPosition() != type || !modifier.getMatcher().test(biome, element)) continue;
            if (result.isEmpty()) {
                result = new ArrayList<BiomeFeature>();
            }
            result.add(new BiomeFeature(predicate, modifier.getModifier().getFeature()));
        }
        return result;
    }

    private List<BiomeFeature> getAppenders(GenerationStage.Decoration stage, InjectionPosition position, Biome biome) {
        List<BiomeFeature> result = Collections.emptyList();
        for (Modifier<FeatureAppender> modifier : this.getAppenders()) {
            if (modifier.getModifier().getPosition() != position || modifier.getModifier().getStage() != stage || !modifier.getMatcher().getBiomeMatcher().test(biome)) continue;
            if (result.isEmpty()) {
                result = new ArrayList<BiomeFeature>();
            }
            result.add(new BiomeFeature(BiomePredicate.ALLOW, modifier.getModifier().getFeature()));
        }
        return result;
    }

    private FeaturePredicate getPredicate(ConfiguredFeature<?, ?> feature) {
        for (DynamicPredicate predicate : this.dynamics) {
            if (!predicate.getMatcher().test(feature)) continue;
            return predicate.getPredicate();
        }
        return null;
    }

    private FeaturePredicate getPredicate(Biome biome, JsonElement element) {
        for (Modifier<FeaturePredicate> modifier : this.predicates) {
            if (!modifier.getMatcher().test(biome, element)) continue;
            return modifier.getModifier();
        }
        return FeaturePredicate.ALLOW;
    }
}

