/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.fm.template.feature;

import com.terraforged.fm.FeatureManager;
import com.terraforged.fm.template.Template;
import com.terraforged.fm.template.decorator.Decorator;
import com.terraforged.fm.template.decorator.DecoratorConfig;
import com.terraforged.fm.template.feature.TemplateFeatureConfig;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;

public class TemplateFeature
extends Feature<TemplateFeatureConfig> {
    public TemplateFeature(String namespace) {
        super(TemplateFeatureConfig::deserialize);
        this.setRegistryName(namespace, "template");
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, TemplateFeatureConfig config) {
        if (config.type.getPlacement().canPlaceAt(world, pos)) {
            return TemplateFeature.paste(world, rand, pos, config, config.decorator);
        }
        return false;
    }

    public static <T extends IWorld> boolean paste(IWorld world, Random rand, BlockPos pos, TemplateFeatureConfig config, DecoratorConfig<T> decorator) {
        Mirror mirror = TemplateFeature.nextMirror(rand);
        Rotation rotation = TemplateFeature.nextRotation(rand);
        return TemplateFeature.paste(world, rand, pos, mirror, rotation, config, decorator);
    }

    public static <T extends IWorld> boolean paste(IWorld world, Random rand, BlockPos pos, Mirror mirror, Rotation rotation, TemplateFeatureConfig config, DecoratorConfig<T> decorator) {
        T buffer;
        if (config.templates.isEmpty()) {
            FeatureManager.LOG.warn("Empty template list for config: {}", (Object)config.name);
            return false;
        }
        Template template = TemplateFeature.nextTemplate(config.templates, rand);
        if (template.paste((IWorld)(buffer = decorator.createBuffer(world)), pos, mirror, rotation, config.paste)) {
            Biome biome = world.func_226691_t_(pos);
            for (Decorator<T> d : decorator.getDecorators(biome.getRegistryName())) {
                d.apply(buffer, rand);
            }
            return true;
        }
        return false;
    }

    public static <T extends IWorld> boolean pasteChecked(IWorld world, Random rand, BlockPos pos, Mirror mirror, Rotation rotation, TemplateFeatureConfig config, DecoratorConfig<T> decorator) {
        T buffer;
        if (config.templates.isEmpty()) {
            FeatureManager.LOG.warn("Empty template list for config: {}", (Object)config.name);
            return false;
        }
        Template template = TemplateFeature.nextTemplate(config.templates, rand);
        if (template.pasteWithBoundsCheck((IWorld)(buffer = decorator.createBuffer(world)), pos, mirror, rotation, config.paste)) {
            Biome biome = world.func_226691_t_(pos);
            for (Decorator<T> d : decorator.getDecorators(biome.getRegistryName())) {
                d.apply(buffer, rand);
            }
            return true;
        }
        return false;
    }

    public static Template nextTemplate(List<Template> templates, Random random) {
        return templates.get(random.nextInt(templates.size()));
    }

    public static Mirror nextMirror(Random random) {
        return Mirror.values()[random.nextInt(Mirror.values().length)];
    }

    public static Rotation nextRotation(Random random) {
        return Rotation.values()[random.nextInt(Rotation.values().length)];
    }
}

