/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.map;

import com.terraforged.mod.biome.provider.BiomeHelper;
import com.terraforged.world.biome.BiomeData;
import java.util.function.BiPredicate;
import net.minecraft.world.biome.Biome;

public interface BiomePredicate {
    public static final BiomePredicate BEACH = BiomePredicate.type(Biome.Category.BEACH).or(BiomePredicate.name("beach"));
    public static final BiomePredicate COAST = BiomePredicate.type(Biome.Category.MUSHROOM).or(BiomePredicate.name("coast"));
    public static final BiomePredicate COLD_STEPPE = BiomePredicate.name("steppe").and(BiomePredicate.temp(-1.0, 0.3));
    public static final BiomePredicate DESERT = BiomePredicate.type(Biome.Category.DESERT).or(BiomePredicate.temp(0.9, 2.0).and(BiomePredicate.rain(-1.0, 0.2)));
    public static final BiomePredicate GRASSLAND = BiomePredicate.type(Biome.Category.PLAINS);
    public static final BiomePredicate LAKE = BiomePredicate.type(Biome.Category.RIVER).and(BiomePredicate.name("lake"));
    public static final BiomePredicate MESA = BiomePredicate.type(Biome.Category.MESA);
    public static final BiomePredicate MOUNTAIN = BiomePredicate.type(Biome.Category.EXTREME_HILLS).or(BiomePredicate.name("mountain"));
    public static final BiomePredicate RIVER = BiomePredicate.type(Biome.Category.RIVER).not(BiomePredicate.name("lake"));
    public static final BiomePredicate SAVANNA = BiomePredicate.type(Biome.Category.SAVANNA).or(BiomePredicate.temp(0.8, 2.0).and(BiomePredicate.rain(-1.0, 0.4)));
    public static final BiomePredicate STEPPE = BiomePredicate.name("steppe").and(BiomePredicate.temp(0.3, 1.0));
    public static final BiomePredicate TAIGA = BiomePredicate.type(Biome.Category.TAIGA).or(BiomePredicate.temp(0.19, 0.35)).not(BiomePredicate.rainType(Biome.RainType.SNOW));
    public static final BiomePredicate TEMPERATE_FOREST = BiomePredicate.type(Biome.Category.FOREST).and(BiomePredicate.rain(-1.0, 0.81));
    public static final BiomePredicate TEMPERATE_RAINFOREST = BiomePredicate.type(Biome.Category.FOREST).and(BiomePredicate.rain(0.8, 2.0));
    public static final BiomePredicate TROPICAL_RAINFOREST = BiomePredicate.type(Biome.Category.JUNGLE);
    public static final BiomePredicate TUNDRA = BiomePredicate.type(Biome.Category.ICY).or(BiomePredicate.temp(-1.0, 0.21).and(BiomePredicate.rainType(Biome.RainType.SNOW)));
    public static final BiomePredicate WETLAND = BiomePredicate.type(Biome.Category.SWAMP);

    public boolean test(BiomeData var1, Biome var2);

    default public boolean test(BiomeData data) {
        return this.test(data, (Biome)data.reference);
    }

    default public BiomePredicate and(BiomePredicate other) {
        return (d, b) -> this.test(d, b) && other.test(d, b);
    }

    default public BiomePredicate not(BiomePredicate other) {
        return (d, b) -> this.test(d, b) && !other.test(d, b);
    }

    default public BiomePredicate or(BiomePredicate other) {
        return (d, b) -> this.test(d, b) || other.test(d, b);
    }

    public static BiomePredicate name(String ... name) {
        return (d, b) -> BiomePredicate.anyMatch(BiomeHelper.getId(b), name, String::contains);
    }

    public static BiomePredicate type(Biome.Category ... categories) {
        return (d, b) -> BiomePredicate.anyMatch(b.func_201856_r(), categories, (c1, c2) -> c1 == c2);
    }

    public static BiomePredicate rain(double min, double max) {
        return (d, b) -> (double)d.rainfall >= min && (double)d.rainfall <= max;
    }

    public static BiomePredicate rainType(Biome.RainType ... rainTypes) {
        return (d, b) -> BiomePredicate.anyMatch(b.func_201851_b(), rainTypes, (c1, c2) -> c1 == c2);
    }

    public static BiomePredicate temp(double min, double max) {
        return (d, b) -> (double)d.temperature >= min && (double)d.temperature <= max;
    }

    public static BiomePredicate depth(double min, double max) {
        return (d, b) -> (double)b.func_185355_j() >= min && (double)b.func_185355_j() <= max;
    }

    public static <T> boolean anyMatch(T value, T[] test, BiPredicate<T, T> tester) {
        for (T t : test) {
            if (!tester.test(value, t)) continue;
            return true;
        }
        return false;
    }
}

