/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.modifier;

import com.terraforged.core.Seed;
import com.terraforged.core.cell.Cell;
import com.terraforged.mod.biome.modifier.AbstractOffsetModifier;
import com.terraforged.n2d.Module;
import com.terraforged.n2d.Source;
import com.terraforged.world.climate.Climate;
import net.minecraft.world.biome.Biome;

public abstract class AbstractMaxHeightModifier
extends AbstractOffsetModifier {
    private final float minHeight;
    private final float maxHeight;
    private final float range;
    private final Module variance;

    public AbstractMaxHeightModifier(Seed seed, Climate climate, int scale, int octaves, float variance, float minHeight, float maxHeight) {
        super(climate);
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.range = maxHeight - minHeight;
        this.variance = Source.perlin(seed.next(), scale, octaves).scale(variance);
    }

    @Override
    protected final Biome modify(Biome in, Cell cell, int x, int z, float ox, float oz) {
        float var = this.variance.getValue(x, z);
        float value = cell.value + var;
        if (value < this.minHeight) {
            return in;
        }
        if (value > this.maxHeight) {
            return this.getModifiedBiome(in, cell, x, z, ox, oz);
        }
        float alpha = (value - this.minHeight) / this.range;
        cell.biomeEdge *= alpha;
        return in;
    }

    protected abstract Biome getModifiedBiome(Biome var1, Cell var2, int var3, int var4, float var5, float var6);
}

