/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.terraforged.api.biome.surface.ChunkSurfaceBuffer;
import com.terraforged.api.biome.surface.SurfaceContext;
import com.terraforged.api.chunk.column.DecoratorContext;
import com.terraforged.core.concurrent.thread.ThreadPools;
import com.terraforged.core.tile.gen.TileCache;
import com.terraforged.core.tile.gen.TileGenerator;
import com.terraforged.mod.chunk.TerraTerrainProvider;
import com.terraforged.mod.chunk.settings.TerraSettings;
import com.terraforged.mod.config.PerfDefaults;
import com.terraforged.mod.material.Materials;
import com.terraforged.world.GeneratorContext;
import com.terraforged.world.WorldGeneratorFactory;
import com.terraforged.world.heightmap.Heightmap;
import com.terraforged.world.terrain.Terrains;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.GenerationSettings;

public class TerraContext
extends GeneratorContext {
    public final IWorld world;
    public final Heightmap heightmap;
    public final Materials materials;
    public final TerraSettings terraSettings;

    public TerraContext(TerraContext other) {
        super(other.terrain, other.settings, other.terrainFactory, TerraContext::createCache);
        this.world = other.world;
        this.materials = other.materials;
        this.terraSettings = other.terraSettings;
        this.heightmap = this.factory.getHeightmap();
    }

    public TerraContext(IWorld world, Terrains terrain, TerraSettings settings) {
        super(terrain, settings, TerraTerrainProvider::new, TerraContext::createCache);
        this.world = world;
        this.materials = new Materials();
        this.terraSettings = settings;
        this.heightmap = this.factory.getHeightmap();
    }

    public DecoratorContext decorator(IChunk chunk) {
        return new DecoratorContext(chunk, this.levels, this.terrain, this.factory.getClimate(), false);
    }

    public SurfaceContext surface(ChunkSurfaceBuffer buffer, GenerationSettings settings) {
        return new SurfaceContext(buffer, this.levels, this.terrain, this.factory.getClimate(), settings, this.world.func_72905_C());
    }

    public static TileCache createCache(WorldGeneratorFactory factory) {
        CommentedConfig config = PerfDefaults.getAndPrintPerfSettings();
        boolean batching = (Boolean)config.getOrElse("batching", (Object)false);
        int tileSize = Math.min(8, Math.max(2, config.getInt("tile_size")));
        int batchCount = Math.min(20, Math.max(1, config.getInt("batch_count")));
        int threadCount = Math.min(PerfDefaults.MAX_THREAD_COUNT, Math.max(1, config.getInt("thread_count")));
        return TileGenerator.builder().pool(ThreadPools.create(threadCount, batching)).size(tileSize, 2).batch(batchCount).factory(factory).build().toCache();
    }
}

