/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.settings.preset;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.terraforged.mod.Log;
import com.terraforged.mod.chunk.settings.SettingsHelper;
import com.terraforged.mod.chunk.settings.TerraSettings;
import com.terraforged.mod.chunk.settings.preset.Preset;
import com.terraforged.mod.util.function.IOFunction;
import com.terraforged.mod.util.function.IOSupplier;
import com.terraforged.mod.util.nbt.NBTHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fml.ModList;

public class PresetManager
implements Iterable<Preset> {
    public static final File PRESETS_DIR = new File(SettingsHelper.SETTINGS_DIR, "presets");
    private final List<Preset> presets;
    private final List<Preset> deleted = new ArrayList<Preset>();

    private PresetManager(List<Preset> presets) {
        this.presets = presets;
        Collections.sort(presets);
    }

    public Optional<Preset> get(String name) {
        for (Preset preset : this.presets) {
            if (!preset.getName().equalsIgnoreCase(name)) continue;
            return Optional.of(preset);
        }
        return Optional.empty();
    }

    public void add(Preset preset) {
        for (int i = 0; i < this.presets.size(); ++i) {
            Preset current = this.presets.get(i);
            if (current.internal() || !current.getId().equalsIgnoreCase(preset.getId())) continue;
            this.presets.set(i, preset);
            return;
        }
        this.presets.add(preset);
        Collections.sort(this.presets);
    }

    public void remove(String name) {
        this.get(name).ifPresent(preset -> {
            this.presets.remove(preset);
            this.deleted.add((Preset)preset);
        });
    }

    public void saveAll() {
        if (!PresetManager.ensureDir()) {
            Log.err("Unable to save presets to disk", new Object[0]);
            return;
        }
        for (Preset preset : this.deleted) {
            if (preset.getFile().exists() && preset.getFile().delete()) {
                Log.debug("Deleted preset: {}", preset.getName());
                continue;
            }
            Log.debug("Unable to delete file: {}", preset.getFile());
        }
        Log.info("Saving presets", new Object[0]);
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
        for (Preset preset : this.presets) {
            if (!preset.changed() || preset.internal()) continue;
            Log.debug("Saving preset: {}", preset.getName());
            CompoundNBT nbt = NBTHelper.serializeCompact(preset.getSettings());
            JsonElement json = NBTHelper.toJson(nbt);
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(preset.getFile()));
                Throwable throwable = null;
                try {
                    gson.toJson(json, (Appendable)writer);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Writer)writer).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Iterator<Preset> iterator() {
        return this.presets.iterator();
    }

    private static boolean ensureDir() {
        if (!PRESETS_DIR.exists() && !PRESETS_DIR.mkdirs()) {
            Log.err("Unable to create presets directory: {}", PRESETS_DIR);
            return false;
        }
        return true;
    }

    public static PresetManager load() {
        if (!PresetManager.ensureDir()) {
            return new PresetManager(new ArrayList<Preset>());
        }
        File[] files = PRESETS_DIR.listFiles();
        if (files == null) {
            return new PresetManager(new ArrayList<Preset>());
        }
        ArrayList<Preset> presets = new ArrayList<Preset>(files.length);
        for (File file : files) {
            if (!file.getName().endsWith(".json")) continue;
            String name = file.getName().substring(0, file.getName().length() - 5);
            TerraSettings settings = SettingsHelper.loadSettings(file);
            presets.add(new Preset(name, file, settings));
        }
        PresetManager.loadInternalPresets(presets);
        return new PresetManager(presets);
    }

    private static String getDescription(JsonElement json) {
        JsonElement description;
        if (json.isJsonObject() && (description = json.getAsJsonObject().get("#description")) != null) {
            return description.getAsString();
        }
        return "";
    }

    private static void setDescription(JsonElement json, String description) {
        if (json.isJsonObject()) {
            json.getAsJsonObject().addProperty("#description", description);
        }
    }

    private static void loadInternalPresets(List<Preset> presets) {
        Path path = ModList.get().getModFileById("terraforged").getFile().getFilePath();
        if (Files.isDirectory(path, new LinkOption[0])) {
            PresetManager.loadAll(() -> Files.walk(path, new FileVisitOption[0]), p -> PresetManager.toString(path.relativize((Path)p)), x$0 -> Files.newInputStream(x$0, new OpenOption[0]), presets::add);
        } else {
            try (ZipFile zipFile = new ZipFile(path.toFile());){
                PresetManager.loadAll(zipFile::stream, PresetManager::toString, zipFile::getInputStream, presets::add);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static <E> void loadAll(IOSupplier<Stream<E>> supplier, Function<E, String> name, IOFunction<E, InputStream> data, Consumer<Preset> consumer) {
        try {
            supplier.get().filter(e -> PresetManager.filter((String)name.apply(e))).forEach(e -> {
                try (InputStream in = (InputStream)data.apply(e);){
                    PresetManager.loadPreset((String)name.apply(e), in, consumer);
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            });
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private static String toString(Path path) {
        StringBuilder sb = new StringBuilder(32);
        for (int i = 0; i < path.getNameCount(); ++i) {
            if (i > 0) {
                sb.append('/');
            }
            sb.append(path.getName(i));
        }
        return sb.toString();
    }

    private static String toString(ZipEntry entry) {
        return entry.getName();
    }

    private static boolean filter(String path) {
        return path.startsWith("presets/") && path.endsWith(".json");
    }

    private static String parseName(String path) {
        int start = path.lastIndexOf(47) + 1;
        int end = Math.max(start + 1, path.lastIndexOf(46));
        return path.substring(start, end);
    }

    private static void loadPreset(String path, InputStream in, Consumer<Preset> presets) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            TerraSettings settings = new TerraSettings();
            JsonElement data = new JsonParser().parse((Reader)reader);
            CompoundNBT nbt = NBTHelper.fromJson(data);
            if (NBTHelper.deserialize(nbt, settings)) {
                String name = PresetManager.parseName(path);
                String description = PresetManager.getDescription(data);
                Preset preset = new Preset(name, description, settings, true);
                presets.accept(preset);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

