/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.util;

import com.terraforged.api.biome.BiomeVariant;
import com.terraforged.core.cell.Cell;
import com.terraforged.core.tile.chunk.ChunkReader;
import com.terraforged.core.util.PosIterator;
import com.terraforged.mod.biome.provider.TerraBiomeProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;

public class TerraContainer
extends BiomeContainer {
    private static final int BITS_WIDTH = (int)Math.round(Math.log(16.0) / Math.log(2.0)) - 2;
    private static final int ZOOM_VERT = (int)Math.round(Math.log(256.0) / Math.log(2.0)) - 2;
    public static final int BIOMES_3D_SIZE = 1 << BITS_WIDTH + BITS_WIDTH + ZOOM_VERT;
    public static final int BIOMES_2D_SIZE = 256;
    public static final int MASK_HORIZ = (1 << BITS_WIDTH) - 1;
    public static final int MASK_VERT = (1 << ZOOM_VERT) - 1;
    private final Biome[] biomes;
    private final Biome[] surface;

    public TerraContainer(Biome[] biomes, Biome[] surface) {
        super(biomes);
        this.biomes = biomes;
        this.surface = surface;
    }

    public Biome getBiome(int x, int z) {
        return this.surface[(z &= 0xF) * 16 + (x &= 0xF)];
    }

    public Biome getFeatureBiome(ChunkReader chunkReader) {
        PosIterator iterator = PosIterator.area(0, 0, 16, 16);
        while (iterator.next()) {
            Cell cell = chunkReader.getCell(iterator.x(), iterator.z());
            if (!cell.biomeType.isExtreme()) continue;
            return this.getBiome(iterator.x(), iterator.z());
        }
        return this.getBiome(8, 8);
    }

    public BiomeContainer bakeBiomes(boolean convertToVanilla) {
        if (convertToVanilla) {
            Biome[] biomeArray = new Biome[this.biomes.length];
            for (int i = 0; i < this.biomes.length; ++i) {
                Biome biome = this.biomes[i];
                if (biome instanceof BiomeVariant) {
                    biome = ((BiomeVariant)biome).getBase();
                }
                biomeArray[i] = biome;
            }
            return new BiomeContainer(biomeArray);
        }
        return new BiomeContainer(this.biomes);
    }

    public static TerraContainer getOrCreate(IChunk chunk, ChunkReader reader, TerraBiomeProvider biomeProvider) {
        BiomeContainer biomes = chunk.func_225549_i_();
        if (biomes instanceof TerraContainer) {
            return (TerraContainer)biomes;
        }
        TerraContainer container = TerraContainer.create(reader, biomeProvider);
        ((ChunkPrimer)chunk).func_225548_a_((BiomeContainer)container);
        return container;
    }

    public static TerraContainer create(ChunkReader chunkReader, TerraBiomeProvider biomeProvider) {
        Biome[] biomes2D = new Biome[256];
        Biome[] biomes3D = new Biome[BIOMES_3D_SIZE];
        PosIterator iterator = PosIterator.area(0, 0, 16, 16);
        while (iterator.next()) {
            Biome biome;
            int dx = iterator.x();
            int dz = iterator.z();
            int x = chunkReader.getBlockX() + dx;
            int z = chunkReader.getBlockZ() + dz;
            biomes2D[TerraContainer.indexOf((int)dx, (int)dz)] = biome = biomeProvider.getBiome(chunkReader.getCell(dx, dz), x, z);
            if ((dx & 3) != 0 || (dz & 3) != 0) continue;
            for (int dy = 0; dy < 64; ++dy) {
                biomes3D[TerraContainer.indexOf((int)(dx >> 2), (int)dy, (int)(dz >> 2))] = biome;
            }
        }
        return new TerraContainer(biomes3D, biomes2D);
    }

    private static int indexOf(int x, int z) {
        return (z << 4) + x;
    }

    public static int indexOf(int x, int y, int z) {
        y = MathHelper.func_76125_a((int)y, (int)0, (int)MASK_VERT);
        return y << BITS_WIDTH + BITS_WIDTH | (z &= MASK_HORIZ) << BITS_WIDTH | (x &= MASK_HORIZ);
    }
}

