/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.client.gui.page;

import com.terraforged.mod.TerraWorld;
import com.terraforged.mod.client.gui.GuiKeys;
import com.terraforged.mod.client.gui.Instance;
import com.terraforged.mod.client.gui.OverlayScreen;
import com.terraforged.mod.client.gui.element.TerraTextInput;
import com.terraforged.mod.client.gui.page.BasePage;
import com.terraforged.mod.client.gui.page.Page;
import com.terraforged.mod.client.gui.page.UpdatablePage;
import com.terraforged.mod.util.nbt.NBTHelper;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldType;
import net.minecraftforge.registries.ForgeRegistries;

public class WorldPage
extends BasePage {
    private final UpdatablePage preview;
    private final Instance instance;
    private CompoundNBT worldSettings = null;
    private CompoundNBT dimSettings = null;

    public WorldPage(Instance instance, UpdatablePage preview) {
        this.instance = instance;
        this.preview = preview;
    }

    @Override
    public String getTitle() {
        return GuiKeys.WORLD_SETTINGS.get();
    }

    @Override
    public void save() {
    }

    @Override
    public void init(OverlayScreen parent) {
        this.worldSettings = this.getWorldSettings();
        this.dimSettings = this.getDimSettings();
        Page.Column left = this.getColumn(0);
        this.addElements(left.left, left.top, left, this.worldSettings, true, left.scrollPane::addButton, this::update);
        this.addElements(left.left, left.top, left, this.dimSettings, true, left.scrollPane::addButton, this::update);
    }

    @Override
    public void onAddWidget(Widget widget) {
        if (widget instanceof TerraTextInput) {
            TerraTextInput input = (TerraTextInput)widget;
            input.setColorValidator(string -> ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(string)));
        }
    }

    @Override
    protected void update() {
        super.update();
        this.preview.apply(settings -> {
            NBTHelper.deserialize(this.worldSettings, settings.world);
            NBTHelper.deserialize(this.dimSettings, settings.dimensions);
        });
    }

    private CompoundNBT getWorldSettings() {
        return this.instance.settingsData.func_74775_l("world");
    }

    private CompoundNBT getDimSettings() {
        CompoundNBT dimSettings = this.instance.settingsData.func_74775_l("dimensions");
        CompoundNBT generators = dimSettings.func_74775_l("dimensions");
        for (String name : generators.func_150296_c()) {
            if (!name.startsWith("#")) continue;
            CompoundNBT metadata = generators.func_74775_l(name);
            metadata.func_218657_a("options", (INBT)WorldPage.getWorldTypes());
        }
        return dimSettings;
    }

    private static ListNBT getWorldTypes() {
        ListNBT options = new ListNBT();
        for (WorldType type : WorldType.field_77139_a) {
            if (type == null || type.func_82747_f() >= 1 && type.func_82747_f() <= 6 || type.func_82747_f() == 8 || TerraWorld.isTerraType(type)) continue;
            options.add((Object)StringNBT.func_229705_a_((String)type.func_211888_a()));
        }
        return options;
    }
}

