/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.client.gui.preview;

import com.terraforged.mod.chunk.settings.TerraSettings;
import com.terraforged.mod.client.gui.GuiKeys;
import com.terraforged.mod.client.gui.OverlayScreen;
import com.terraforged.mod.client.gui.element.TerraButton;
import com.terraforged.mod.client.gui.page.Page;
import com.terraforged.mod.client.gui.page.UpdatablePage;
import com.terraforged.mod.client.gui.preview.Preview;
import com.terraforged.mod.client.gui.preview.PreviewSettings;
import com.terraforged.mod.util.nbt.NBTHelper;
import java.util.function.Consumer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.nbt.CompoundNBT;

public class PreviewPage
extends UpdatablePage {
    private final Preview preview;
    private final TerraSettings settings;
    private final CompoundNBT previewerSettings = NBTHelper.serialize("preview", new PreviewSettings());

    public PreviewPage(TerraSettings settings, int seed) {
        this.preview = new Preview(seed);
        this.settings = settings;
    }

    public Preview getPreviewWidget() {
        return this.preview;
    }

    public int getSeed() {
        return this.preview.getSeed();
    }

    @Override
    public void apply(Consumer<TerraSettings> consumer) {
        consumer.accept(this.settings);
        this.preview.update(this.settings, this.previewerSettings);
    }

    @Override
    public void close() {
        this.preview.close();
    }

    @Override
    public void init(OverlayScreen parent) {
        Page.Column right = this.getColumn(1);
        this.preview.x = 0;
        this.preview.y = 0;
        this.preview.setWidth(Preview.SIZE);
        this.preview.setHeight(Preview.SIZE);
        this.addElements(right.left, right.top, right, this.previewerSettings, right.scrollPane::addButton, this::update);
        right.scrollPane.addButton((Widget)new TerraButton(GuiKeys.PREVIEW_SEED.get()){

            public void onPress() {
                PreviewPage.this.preview.regenerate();
                PreviewPage.this.update();
            }
        });
        right.scrollPane.addButton((Widget)this.preview);
        TerraButton spacer = PreviewPage.createSpacer();
        for (int i = 0; i < 10; ++i) {
            right.scrollPane.addButton((Widget)spacer);
        }
        this.update();
    }

    @Override
    public void update() {
        this.preview.update(this.settings, this.previewerSettings);
    }

    private static TerraButton createSpacer() {
        return new TerraButton(""){

            public void render(int x, int y, float tick) {
            }
        };
    }
}

