/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.client.gui.preview2;

import com.mojang.blaze3d.systems.RenderSystem;
import com.terraforged.core.concurrent.thread.ThreadPool;
import com.terraforged.core.concurrent.thread.ThreadPools;
import com.terraforged.core.render.RenderSettings;
import com.terraforged.core.render.RenderWorld;
import com.terraforged.core.tile.gen.TileGenerator;
import com.terraforged.mod.chunk.settings.TerraSettings;
import com.terraforged.mod.client.gui.preview2.MCRenderAPI;
import com.terraforged.mod.client.gui.preview2.PreviewSettings;
import com.terraforged.world.GeneratorContext;
import com.terraforged.world.continent.MutableVeci;
import com.terraforged.world.continent.SpawnType;
import com.terraforged.world.terrain.Terrains;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;

public class Preview
extends Widget {
    private static final float ZOOM_SCALE = 200.0f;
    private final ThreadPool threadPool = ThreadPools.createDefault();
    private final TerraSettings settings;
    private int seed;
    private float zoom = 50.0f;
    private float offsetX = 0.0f;
    private float offsetZ = 0.0f;
    private float angle = 45.0f;
    private RenderWorld world;
    private PreviewSettings previewSettings = new PreviewSettings();

    public Preview(TerraSettings settings, int seed) {
        super(0, 0, "preview");
        this.seed = seed;
        this.settings = settings;
        this.world = this.createWorld(settings);
        this.world.update(this.offsetX, this.offsetZ, this.zoom, true);
    }

    public int getSeed() {
        return this.seed;
    }

    public void nextSeed() {
        ++this.seed;
        this.world = this.createWorld(this.settings);
        this.world.update(this.offsetX, this.offsetZ, this.zoom, true);
    }

    public void close() {
        this.threadPool.shutdown();
    }

    public void render(int mx, int my, float ticks) {
        try {
            float scale = 0.75f;
            this.angle += 0.35f;
            if (this.angle >= 360.0f) {
                this.angle = 0.0f;
            }
            RenderSystem.pushMatrix();
            RenderSystem.enableLighting();
            RenderHelper.func_227780_a_();
            RenderHelper.func_227784_d_();
            RenderSystem.translatef((float)this.x, (float)this.y, (float)0.0f);
            RenderSystem.translatef((float)((float)this.width / 2.0f), (float)((float)this.width / 2.0f), (float)0.0f);
            RenderSystem.rotatef((float)70.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            RenderSystem.rotatef((float)this.angle, (float)0.0f, (float)0.0f, (float)1.0f);
            RenderSystem.scalef((float)scale, (float)scale, (float)scale);
            this.world.refresh();
            this.world.render();
            RenderHelper.func_74518_a();
            RenderSystem.popMatrix();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void update(PreviewSettings settings, TerraSettings genSettings) {
        this.previewSettings = settings;
        this.world = this.createWorld(genSettings);
        this.world.update(this.offsetX, this.offsetZ, this.previewSettings.getZoom(200.0f), true);
    }

    private RenderWorld createWorld(TerraSettings settings) {
        int size = 4;
        int regions = 1;
        settings.world.seed = this.seed;
        GeneratorContext context = GeneratorContext.createNoCache(Terrains.create(settings), settings);
        MutableVeci center = new MutableVeci();
        if (settings.world.properties.spawnType == SpawnType.CONTINENT_CENTER) {
            context.factory.getHeightmap().getContinent().getNearestCenter(0.0f, 0.0f, center);
        }
        this.offsetX = center.x;
        this.offsetZ = center.z;
        TileGenerator generator = TileGenerator.builder().pool(this.threadPool).size(size, 0).factory(context.factory).batch(6).build();
        MCRenderAPI renderAPI = new MCRenderAPI();
        RenderSettings renderSettings = new RenderSettings(context);
        renderSettings.width = this.width;
        renderSettings.height = this.height;
        renderSettings.zoom = this.previewSettings.getZoom(200.0f);
        renderSettings.renderMode = this.previewSettings.display;
        return new RenderWorld(this.threadPool, generator, renderAPI, renderSettings, regions, size);
    }
}

