/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.context;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.concurrent.Resource;
import com.terraforged.core.concurrent.cache.SafeCloseable;
import com.terraforged.core.concurrent.pool.ObjectPool;
import com.terraforged.core.tile.chunk.ChunkReader;
import com.terraforged.mod.chunk.TerraChunkGenerator;
import com.terraforged.mod.chunk.fix.RegionDelegate;
import com.terraforged.world.heightmap.Levels;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;

public class ChanceContext
implements SafeCloseable {
    private static final ObjectPool<ChanceContext> pool = new ObjectPool<ChanceContext>(10, ChanceContext::new);
    public IChunk chunk;
    public Levels levels;
    public ChunkReader reader;
    public Cell cell = Cell.empty();
    private int length;
    private float total = 0.0f;
    private float[] buffer;

    @Override
    public void close() {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    void setPos(BlockPos pos) {
        this.cell = this.reader.getCell(pos.func_177958_n(), pos.func_177952_p());
    }

    void init(int size) {
        this.total = 0.0f;
        this.length = 0;
        if (this.buffer == null || this.buffer.length < size) {
            this.buffer = new float[size];
        }
    }

    void record(int index, float chance) {
        this.buffer[index] = chance;
        this.total += chance;
        ++this.length;
    }

    int nextIndex(Random random) {
        if (this.total == 0.0f) {
            return -1;
        }
        float value = 0.0f;
        float chance = this.total * random.nextFloat();
        for (int i = 0; i < this.length; ++i) {
            if (!((value += this.buffer[i]) >= chance)) continue;
            return i;
        }
        return -1;
    }

    public static Resource<ChanceContext> pooled(IWorld world, ChunkGenerator<?> generator) {
        if (generator instanceof TerraChunkGenerator && world instanceof RegionDelegate) {
            TerraChunkGenerator terraGenerator = (TerraChunkGenerator)generator;
            Levels levels = terraGenerator.getContext().levels;
            WorldGenRegion region = ((RegionDelegate)world).getRegion();
            IChunk chunk = region.func_212866_a_(region.func_201679_a(), region.func_201680_b());
            Resource<ChanceContext> item = pool.get();
            item.get().chunk = chunk;
            item.get().levels = levels;
            item.get().reader = terraGenerator.getChunkReader(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);
            return item;
        }
        return null;
    }
}

