/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.material.geology;

import com.terraforged.api.material.geology.GeologyManager;
import com.terraforged.api.material.geology.StrataConfig;
import com.terraforged.core.Seed;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.mod.material.Materials;
import com.terraforged.mod.material.geology.GeoGenerator;
import com.terraforged.n2d.Module;
import com.terraforged.n2d.Source;
import com.terraforged.world.geology.Geology;
import com.terraforged.world.geology.Strata;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.world.biome.Biome;

public class GeoManager
implements GeologyManager {
    private final Module selector;
    private final Materials materials;
    private final GeoGenerator builder;
    private final Geology<BlockState> general;
    private final Map<Biome, Geology<BlockState>> specific = new HashMap<Biome, Geology<BlockState>>();

    public GeoManager(TerraContext context) {
        int scale = context.settings.terrain.general.terrainRegionSize / 2;
        this.selector = Source.cell(context.seed.next(), scale).warp(context.seed.next(), scale / 4, 2, (double)scale / 2.0).warp(context.seed.next(), 15, 2, 30.0);
        this.builder = new GeoGenerator(context.materials);
        this.general = new Geology(this.selector);
        this.materials = context.materials;
        this.init(context.seed);
    }

    @Override
    public GeoGenerator getStrataGenerator() {
        return this.builder;
    }

    @Override
    public void register(Strata<BlockState> strata) {
        this.general.add(strata);
    }

    @Override
    public void register(Biome biome, Strata<BlockState> strata) {
        this.register(biome, strata, false);
    }

    @Override
    public void register(Biome biome, Strata<BlockState> strata, boolean inheritGlobal) {
        Geology<Object> geology = this.specific.get(biome);
        if (geology == null) {
            geology = new Geology(this.selector);
            this.specific.put(biome, geology);
            if (inheritGlobal) {
                geology.add(this.general);
            }
        }
        geology.add(strata);
    }

    @Override
    public void register(Biome biome, Geology<BlockState> geology) {
        this.specific.put(biome, geology);
    }

    public Geology<BlockState> getGeology(Biome biome) {
        return this.specific.getOrDefault(biome, this.general);
    }

    public Strata<BlockState> getStrata(Biome biome, float value) {
        return this.getGeology(biome).getStrata(value);
    }

    private void init(Seed seed) {
        StrataConfig config = new StrataConfig();
        GeoGenerator generator = new GeoGenerator(this.materials);
        for (int i = 0; i < 10; ++i) {
            Strata<BlockState> strata = generator.generate(seed.next(), 128, config);
            this.general.add(strata);
        }
    }
}

