/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.n2d.modifier;

import com.terraforged.cereal.spec.DataFactory;
import com.terraforged.cereal.spec.DataSpec;
import com.terraforged.n2d.Module;
import com.terraforged.n2d.modifier.Modifier;
import com.terraforged.n2d.util.NoiseUtil;

public class VariableCurve
extends Modifier {
    private final Module midpoint;
    private final Module gradient;
    private static final DataFactory<VariableCurve> factory = (data, spec, context) -> new VariableCurve(spec.get("source", data, Module.class, context), spec.get("midpoint", data, Module.class, context), spec.get("gradient", data, Module.class, context));

    public VariableCurve(Module source, Module mid, Module gradient) {
        super(source);
        this.midpoint = mid;
        this.gradient = gradient;
    }

    @Override
    public String getSpecName() {
        return "VariCurve";
    }

    @Override
    public float modify(float x, float y, float noiseValue) {
        float mid = this.midpoint.getValue(x, y);
        float curve = this.gradient.getValue(x, y);
        return NoiseUtil.curve(noiseValue, mid, curve);
    }

    public static DataSpec<VariableCurve> spec() {
        return Modifier.sourceBuilder("VariCurve", VariableCurve.class, factory).addObj("midpoint", Module.class, v -> v.midpoint).addObj("gradient", Module.class, v -> v.gradient).build();
    }
}

