/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.world.climate;

import com.terraforged.core.Seed;
import com.terraforged.core.cell.Cell;
import com.terraforged.core.settings.Settings;
import com.terraforged.n2d.Module;
import com.terraforged.n2d.Source;
import com.terraforged.n2d.func.DistanceFunc;
import com.terraforged.n2d.func.EdgeFunc;
import com.terraforged.n2d.util.NoiseUtil;
import com.terraforged.n2d.util.Vec2f;
import com.terraforged.world.GeneratorContext;
import com.terraforged.world.biome.BiomeType;
import com.terraforged.world.climate.Moisture;
import com.terraforged.world.climate.Temperature;
import com.terraforged.world.continent.Continent;
import com.terraforged.world.heightmap.ControlPoints;
import com.terraforged.world.terrain.Terrains;

public class ClimateModule {
    private static final float MOISTURE_SIZE = 2.5f;
    private final int seed;
    private final float edgeClamp;
    private final float edgeScale;
    private final float biomeFreq;
    private final float warpStrength;
    private final Module warpX;
    private final Module warpZ;
    private final Module moisture;
    private final Module temperature;
    private final Module macroBiomeNoise;
    private final Continent continent;
    private final Terrains terrains;
    private final ControlPoints controlPoints;

    public ClimateModule(Continent continent, GeneratorContext context) {
        Seed seed = context.seed;
        Settings settings = context.settings;
        int biomeSize = settings.climate.biomeShape.biomeSize;
        float tempScaler = settings.climate.temperature.scale;
        float moistScaler = (float)settings.climate.moisture.scale * 2.5f;
        float biomeFreq = 1.0f / (float)biomeSize;
        float moistureSize = moistScaler * (float)biomeSize;
        float temperatureSize = tempScaler * (float)biomeSize;
        int moistScale = NoiseUtil.round(moistureSize * biomeFreq);
        int tempScale = NoiseUtil.round(temperatureSize * biomeFreq);
        int warpScale = settings.climate.biomeShape.biomeWarpScale;
        this.terrains = context.terrain;
        this.continent = continent;
        this.seed = seed.next();
        this.edgeClamp = 1.0f;
        this.edgeScale = 1.0f / this.edgeClamp;
        this.biomeFreq = 1.0f / (float)biomeSize;
        this.controlPoints = new ControlPoints(context.settings.world.controlPoints);
        this.warpStrength = settings.climate.biomeShape.biomeWarpStrength;
        this.warpX = Source.simplex(seed.next(), warpScale, 2).bias(-0.5);
        this.warpZ = Source.simplex(seed.next(), warpScale, 2).bias(-0.5);
        Moisture moisture = new Moisture(seed.next(), moistScale, settings.climate.moisture.falloff);
        this.moisture = settings.climate.moisture.apply(moisture).warp(seed.next(), moistScale / 2, 1, (double)moistScale / 4.0).warp(seed.next(), moistScale / 6, 2, (double)moistScale / 12.0);
        Temperature temperature = new Temperature(1.0f / (float)tempScale, settings.climate.temperature.falloff);
        this.temperature = settings.climate.temperature.apply(temperature).warp(seed.next(), tempScale * 4, 2, tempScale * 4).warp(seed.next(), tempScale, 1, tempScale);
        this.macroBiomeNoise = Source.cell(seed.next(), context.settings.climate.biomeShape.macroNoiseSize);
    }

    public void apply(Cell cell, float x, float y) {
        this.apply(cell, x, y, true);
    }

    public void apply(Cell cell, float x, float y, boolean mask) {
        float ox = this.warpX.getValue(x, y) * this.warpStrength;
        float oz = this.warpZ.getValue(x, y) * this.warpStrength;
        x += ox;
        y += oz;
        int cellX = 0;
        int cellY = 0;
        int xr = NoiseUtil.round(x *= this.biomeFreq);
        int yr = NoiseUtil.round(y *= this.biomeFreq);
        Vec2f center = null;
        float edgeDistance = 999999.0f;
        float edgeDistance2 = 999999.0f;
        float valueDistance = 999999.0f;
        DistanceFunc dist = DistanceFunc.EUCLIDEAN;
        for (int dy = -1; dy <= 1; ++dy) {
            for (int dx = -1; dx <= 1; ++dx) {
                int xi = xr + dx;
                int yi = yr + dy;
                Vec2f vec = NoiseUtil.CELL_2D[NoiseUtil.hash2D(this.seed, xi, yi) & 0xFF];
                float vecX = (float)xi - x + vec.x;
                float vecY = (float)yi - y + vec.y;
                float distance = dist.apply(vecX, vecY);
                if (distance < valueDistance || center == null && dx == 0 && dy == 0) {
                    valueDistance = distance;
                    center = vec;
                    cellX = xi;
                    cellY = yi;
                }
                edgeDistance2 = distance < edgeDistance2 ? Math.max(edgeDistance, distance) : Math.max(edgeDistance, edgeDistance2);
                edgeDistance = Math.min(edgeDistance, distance);
            }
        }
        float biomeX = (float)cellX + center.x;
        float biomeY = (float)cellY + center.y;
        cell.biomeIdentity = this.cellValue(this.seed, cellX, cellY);
        cell.moisture = this.moisture.getValue(biomeX, biomeY);
        cell.temperature = this.temperature.getValue(biomeX, biomeY);
        cell.macroNoise = this.macroBiomeNoise.getValue(biomeX, biomeY);
        int posX = (int)(biomeX / this.biomeFreq);
        int posZ = (int)(biomeY / this.biomeFreq);
        float continentEdge = this.continent.getEdgeNoise(posX, posZ);
        if (mask) {
            cell.biomeEdge = this.edgeValue(edgeDistance, edgeDistance2);
            this.modifyTerrain(cell, continentEdge);
        }
        this.modifyMoisture(cell, continentEdge);
        cell.biomeType = BiomeType.get(cell.temperature, cell.moisture);
    }

    private void modifyMoisture(Cell cell, float continentEdge) {
        float limit = 0.75f;
        float range = 1.0f - limit;
        if (continentEdge < limit) {
            float alpha = (limit - continentEdge) / range;
            float multiplier = 1.0f + alpha * range;
            cell.moisture = NoiseUtil.clamp(cell.moisture * multiplier, 0.0f, 1.0f);
        } else {
            float alpha = (continentEdge - limit) / range;
            float multiplier = 1.0f - alpha * range;
            cell.moisture *= multiplier;
        }
    }

    private void modifyTerrain(Cell cell, float continentEdge) {
        if (cell.terrain.isOverground() && continentEdge <= this.controlPoints.coastMarker) {
            cell.terrain = this.terrains.coast;
        }
    }

    private float cellValue(int seed, int cellX, int cellY) {
        float value = NoiseUtil.valCoord2D(seed, cellX, cellY);
        return NoiseUtil.map(value, -1.0f, 1.0f, 2.0f);
    }

    private float edgeValue(float distance, float distance2) {
        EdgeFunc edge = EdgeFunc.DISTANCE_2_DIV;
        float value = edge.apply(distance, distance2);
        value = 1.0f - NoiseUtil.map(value, edge.min(), edge.max(), edge.range());
        return value;
    }
}

