/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.world.terrain;

import com.terraforged.world.terrain.TerrainType;

public interface ITerrain {
    default public float erosionModifier() {
        return 1.0f;
    }

    default public boolean isFlat() {
        return false;
    }

    default public boolean isRiver() {
        return false;
    }

    default public boolean isShallowOcean() {
        return false;
    }

    default public boolean isDeepOcean() {
        return false;
    }

    default public boolean isCoast() {
        return false;
    }

    default public boolean isSubmerged() {
        return this.isDeepOcean() || this.isShallowOcean() || this.isRiver() || this.isLake();
    }

    default public boolean isOverground() {
        return false;
    }

    default public boolean overridesRiver() {
        return this.isDeepOcean() || this.isShallowOcean() || this.isCoast();
    }

    default public boolean isLake() {
        return false;
    }

    default public boolean isWetland() {
        return false;
    }

    default public boolean isMountain() {
        return false;
    }

    public static interface Delegate
    extends ITerrain {
        public TerrainType getType();

        @Override
        default public float erosionModifier() {
            return this.getType().erosionModifier();
        }

        @Override
        default public boolean isFlat() {
            return this.getType().isFlat();
        }

        @Override
        default public boolean isRiver() {
            return this.getType().isRiver();
        }

        @Override
        default public boolean isShallowOcean() {
            return this.getType().isShallowOcean();
        }

        @Override
        default public boolean isDeepOcean() {
            return this.getType().isDeepOcean();
        }

        @Override
        default public boolean isCoast() {
            return this.getType().isCoast();
        }

        @Override
        default public boolean overridesRiver() {
            return this.getType().overridesRiver();
        }

        @Override
        default public boolean isLake() {
            return this.getType().isLake();
        }

        @Override
        default public boolean isWetland() {
            return this.getType().isWetland();
        }

        @Override
        default public boolean isOverground() {
            return this.getType().isOverground();
        }

        @Override
        default public boolean isSubmerged() {
            return this.getType().isSubmerged();
        }

        @Override
        default public boolean isMountain() {
            return this.getType().isMountain();
        }
    }
}

