/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.wood;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;

public class DeadwoodBranchBlock
extends Block {
    public static final EnumProperty<Direction> FACING = EnumProperty.func_177709_a((String)"facing", Direction.class);
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    public static final BooleanProperty UP = BooleanProperty.func_177716_a((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.func_177716_a((String)"down");
    private static final Map<Direction, VoxelShape> bounds;
    private static final Map<Direction, VoxelShape> connectedBounds;
    private static final VoxelShape EAST_AABB;
    private static final VoxelShape WEST_AABB;
    private static final VoxelShape NORTH_AABB;
    private static final VoxelShape SOUTH_AABB;
    private static final VoxelShape UP_AABB;
    private static final VoxelShape DOWN_AABB;

    public DeadwoodBranchBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(0.8f, 5.0f).func_200947_a(SoundType.field_185848_a).func_200944_c().harvestTool(ToolType.AXE).harvestLevel(0).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public int func_200011_d(@Nonnull BlockState state, @Nonnull IBlockReader reader, @Nonnull BlockPos pos) {
        return 1;
    }

    public void func_225534_a_(@Nonnull BlockState state, @Nonnull ServerWorld world, @Nonnull BlockPos pos, @Nonnull Random rand) {
        if (!this.canSurviveAt((World)world, pos)) {
            world.func_175655_b(pos, true);
        }
    }

    public void func_220069_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean isMoving) {
        if (!this.canSurviveAt(world, pos)) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, 1);
        }
    }

    private boolean canSurviveAt(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Direction facing = (Direction)state.func_177229_b(FACING);
        BlockState neighbor = world.func_180495_p(pos.func_177971_a(facing.func_176730_m()));
        return neighbor.func_185904_a() == Material.field_151575_d;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, @Nonnull ISelectionContext context) {
        Direction facing = (Direction)state.func_177229_b(FACING);
        BlockState neighbor = reader.func_180495_p(pos.func_177971_a(facing.func_176730_m()));
        if (neighbor.func_177230_c() == this) {
            AxisAlignedBB box = connectedBounds.get(facing).func_197752_a();
            AxisAlignedBB expandedBox = new AxisAlignedBB(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f);
            return VoxelShapes.func_197881_a((AxisAlignedBB)expandedBox.func_72321_a(0.3125 * (double)facing.func_82601_c(), 0.3125 * (double)facing.func_96559_d(), 0.3125 * (double)facing.func_82599_e()));
        }
        return bounds.get(facing);
    }

    @Nullable
    public BlockState func_196258_a(@Nonnull BlockItemUseContext context) {
        return this.makeConnections((IWorldReader)context.func_195991_k(), context.func_195995_a(), context.func_196000_l());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new IProperty[]{FACING, NORTH, SOUTH, EAST, WEST, UP, DOWN});
    }

    public BlockState makeConnections(IWorldReader world, BlockPos pos) {
        return this.makeConnections(world, pos, ((Direction)world.func_180495_p(pos).func_177229_b(FACING)).func_176734_d());
    }

    public BlockState makeConnections(IWorldReader world, BlockPos pos, Direction direction) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(FACING, (Comparable)direction.func_176734_d())).func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.shouldCheckDirection(world, pos, direction, Direction.NORTH)))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.shouldCheckDirection(world, pos, direction, Direction.EAST)))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.shouldCheckDirection(world, pos, direction, Direction.SOUTH)))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.shouldCheckDirection(world, pos, direction, Direction.WEST)))).func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(this.shouldCheckDirection(world, pos, direction, Direction.UP)))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.shouldCheckDirection(world, pos, direction, Direction.DOWN)));
    }

    private boolean shouldCheckDirection(IWorldReader world, BlockPos pos, Direction direction, Direction directionToCheck) {
        if (direction != directionToCheck) {
            return this.shouldConnect(world, pos, directionToCheck);
        }
        if (direction != directionToCheck.func_176734_d()) {
            return this.shouldConnect(world, pos, directionToCheck);
        }
        return false;
    }

    public boolean shouldConnect(IWorldReader world, BlockPos pos, Direction direction) {
        BlockState neighborState = world.func_180495_p(pos.func_177971_a(direction.func_176730_m()));
        if (neighborState.func_177230_c() == this) {
            return neighborState.func_177229_b(FACING) == direction.func_176734_d();
        }
        return false;
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH))).func_206870_a((IProperty)EAST, state.func_177229_b((IProperty)WEST))).func_206870_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH))).func_206870_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)NORTH, state.func_177229_b((IProperty)EAST))).func_206870_a((IProperty)EAST, state.func_177229_b((IProperty)SOUTH))).func_206870_a((IProperty)SOUTH, state.func_177229_b((IProperty)WEST))).func_206870_a((IProperty)WEST, state.func_177229_b((IProperty)NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)NORTH, state.func_177229_b((IProperty)WEST))).func_206870_a((IProperty)EAST, state.func_177229_b((IProperty)NORTH))).func_206870_a((IProperty)SOUTH, state.func_177229_b((IProperty)EAST))).func_206870_a((IProperty)WEST, state.func_177229_b((IProperty)SOUTH));
            }
        }
        return state;
    }

    @Nonnull
    public BlockState func_185471_a(@Nonnull BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.func_206870_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH))).func_206870_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.func_206870_a((IProperty)EAST, state.func_177229_b((IProperty)WEST))).func_206870_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
        }
        return super.func_185471_a(state, mirror);
    }

    static {
        EAST_AABB = VoxelShapes.func_197873_a((double)0.3125, (double)0.3125, (double)0.3125, (double)1.0, (double)0.6875, (double)0.6875);
        WEST_AABB = VoxelShapes.func_197873_a((double)0.0, (double)0.3125, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875);
        NORTH_AABB = VoxelShapes.func_197873_a((double)0.3125, (double)0.3125, (double)0.0, (double)0.6875, (double)0.6875, (double)0.6875);
        SOUTH_AABB = VoxelShapes.func_197873_a((double)0.3125, (double)0.3125, (double)0.3125, (double)0.6875, (double)0.6875, (double)1.0);
        UP_AABB = VoxelShapes.func_197873_a((double)0.3125, (double)0.3125, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875);
        DOWN_AABB = VoxelShapes.func_197873_a((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875);
        bounds = new HashMap<Direction, VoxelShape>();
        connectedBounds = new HashMap<Direction, VoxelShape>();
        bounds.put(Direction.EAST, EAST_AABB);
        bounds.put(Direction.WEST, WEST_AABB);
        bounds.put(Direction.NORTH, NORTH_AABB);
        bounds.put(Direction.SOUTH, SOUTH_AABB);
        bounds.put(Direction.UP, UP_AABB);
        bounds.put(Direction.DOWN, DOWN_AABB);
        for (Direction facing : Direction.values()) {
            AxisAlignedBB box = bounds.get(facing).func_197752_a();
            AxisAlignedBB expandedBox = new AxisAlignedBB(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f);
            expandedBox.func_72321_a((double)(5 * facing.func_82601_c()), (double)(5 * facing.func_96559_d()), (double)(5 * facing.func_82599_e()));
            connectedBounds.put(facing, VoxelShapes.func_197881_a((AxisAlignedBB)expandedBox));
        }
    }
}

