/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.model.entity;

import com.google.common.collect.ImmutableList;
import com.teammetallurgy.atum.entity.stone.StonewardenEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StonewardenModel<T extends StonewardenEntity>
extends SegmentedModel<T> {
    private final ModelRenderer stonewardenHead = new ModelRenderer((Model)this).func_78787_b(128, 128);
    private final ModelRenderer stonewardenBody;
    public final ModelRenderer stonewardenRightArm;
    private final ModelRenderer stonewardenLeftArm;
    private final ModelRenderer stonewardenLeftLeg;
    private final ModelRenderer stonewardenRightLeg;

    public StonewardenModel() {
        this(0.0f, -7.0f);
    }

    public StonewardenModel(float yOffset, float yRotation) {
        this.stonewardenHead.func_78793_a(0.0f, 0.0f + yRotation, -2.0f);
        this.stonewardenHead.func_78784_a(0, 0).func_228301_a_(-4.0f, -12.0f, -5.5f, 8.0f, 10.0f, 8.0f, yOffset);
        this.stonewardenHead.func_78784_a(24, 0).func_228301_a_(-1.0f, -5.0f, -7.5f, 2.0f, 4.0f, 2.0f, yOffset);
        this.stonewardenBody = new ModelRenderer((Model)this).func_78787_b(128, 128);
        this.stonewardenBody.func_78793_a(0.0f, 0.0f + yRotation, 0.0f);
        this.stonewardenBody.func_78784_a(0, 40).func_228301_a_(-9.0f, -2.0f, -6.0f, 18.0f, 12.0f, 11.0f, yOffset);
        this.stonewardenBody.func_78784_a(0, 70).func_228301_a_(-4.5f, 10.0f, -3.0f, 9.0f, 5.0f, 6.0f, yOffset + 0.5f);
        this.stonewardenRightArm = new ModelRenderer((Model)this).func_78787_b(128, 128);
        this.stonewardenRightArm.func_78793_a(0.0f, -7.0f, 0.0f);
        this.stonewardenRightArm.func_78784_a(60, 21).func_228301_a_(-13.0f, -2.5f, -3.0f, 4.0f, 30.0f, 6.0f, yOffset);
        this.stonewardenLeftArm = new ModelRenderer((Model)this).func_78787_b(128, 128);
        this.stonewardenLeftArm.func_78793_a(0.0f, -7.0f, 0.0f);
        this.stonewardenLeftArm.func_78784_a(60, 58).func_228301_a_(9.0f, -2.5f, -3.0f, 4.0f, 30.0f, 6.0f, yOffset);
        this.stonewardenLeftLeg = new ModelRenderer((Model)this, 0, 22).func_78787_b(128, 128);
        this.stonewardenLeftLeg.func_78793_a(-4.0f, 18.0f + yRotation, 0.0f);
        this.stonewardenLeftLeg.func_78784_a(37, 0).func_228301_a_(-3.5f, -3.0f, -3.0f, 6.0f, 16.0f, 5.0f, yOffset);
        this.stonewardenRightLeg = new ModelRenderer((Model)this, 0, 22).func_78787_b(128, 128);
        this.stonewardenRightLeg.field_78809_i = true;
        this.stonewardenRightLeg.func_78784_a(60, 0).func_78793_a(5.0f, 18.0f + yRotation, 0.0f);
        this.stonewardenRightLeg.func_228301_a_(-3.5f, -3.0f, -3.0f, 6.0f, 16.0f, 5.0f, yOffset);
    }

    @Nonnull
    public Iterable<ModelRenderer> func_225601_a_() {
        return ImmutableList.of((Object)this.stonewardenHead, (Object)this.stonewardenBody, (Object)this.stonewardenLeftLeg, (Object)this.stonewardenRightLeg, (Object)this.stonewardenRightArm, (Object)this.stonewardenLeftArm);
    }

    public void setRotationAngles(@Nonnull T stonewarden, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.stonewardenHead.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.stonewardenHead.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.stonewardenLeftLeg.field_78795_f = -1.5f * this.triangleWave(limbSwing, 13.0f) * limbSwingAmount;
        this.stonewardenRightLeg.field_78795_f = 1.5f * this.triangleWave(limbSwing, 13.0f) * limbSwingAmount;
        this.stonewardenLeftLeg.field_78796_g = 0.0f;
        this.stonewardenRightLeg.field_78796_g = 0.0f;
    }

    public void setLivingAnimations(T stonewarden, float limbSwing, float limbSwingAmount, float partialTickTime) {
        int attackTimer = ((StonewardenEntity)((Object)stonewarden)).getAttackTimer();
        if (attackTimer > 0) {
            this.stonewardenRightArm.field_78795_f = -2.0f + 1.5f * this.triangleWave((float)attackTimer - partialTickTime, 10.0f);
            this.stonewardenLeftArm.field_78795_f = -2.0f + 1.5f * this.triangleWave((float)attackTimer - partialTickTime, 10.0f);
        } else {
            this.stonewardenRightArm.field_78795_f = (-0.2f + 1.5f * this.triangleWave(limbSwing, 13.0f)) * limbSwingAmount;
            this.stonewardenLeftArm.field_78795_f = (-0.2f - 1.5f * this.triangleWave(limbSwing, 13.0f)) * limbSwingAmount;
        }
    }

    private float triangleWave(float a, float b) {
        return (Math.abs(a % b - b * 0.5f) - b * 0.25f) / (b * 0.25f);
    }
}

