/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.render;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.teammetallurgy.atum.blocks.stone.limestone.chest.ChestSpawnerBlock;
import com.teammetallurgy.atum.blocks.stone.limestone.chest.LimestoneChestBlock;
import com.teammetallurgy.atum.blocks.stone.limestone.chest.SarcophagusBlock;
import com.teammetallurgy.atum.blocks.stone.limestone.chest.tileentity.LimestoneChestTileEntity;
import com.teammetallurgy.atum.blocks.stone.limestone.chest.tileentity.SarcophagusTileEntity;
import com.teammetallurgy.atum.client.ClientHandler;
import com.teammetallurgy.atum.client.model.TefnutsCallModel;
import com.teammetallurgy.atum.client.model.shield.AbstractShieldModel;
import com.teammetallurgy.atum.client.model.shield.AtumsProtectionModel;
import com.teammetallurgy.atum.client.model.shield.BrigandShieldModel;
import com.teammetallurgy.atum.client.model.shield.StoneguardShieldModel;
import com.teammetallurgy.atum.init.AtumItems;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class ItemStackRenderer
extends ItemStackTileEntityRenderer {
    private static final Map<String, ResourceLocation> SHIELD_CACHE = Maps.newHashMap();
    private static final Material ATUMS_PROTECTION_MATERIAL = ItemStackRenderer.getShieldMaterial("atums_protection");
    private static final Material BRIGAND_SHIELD_MATERIAL = ItemStackRenderer.getShieldMaterial("brigand_shield");
    private static final Material STONEGUARD_SHIELD_MATERIAL = ItemStackRenderer.getShieldMaterial("stoneguard_shield");
    private static final AtumsProtectionModel ATUMS_PROTECTION = new AtumsProtectionModel();
    private static final BrigandShieldModel BRIGAND_SHIELD = new BrigandShieldModel();
    private static final StoneguardShieldModel STONEGUARD_SHIELD = new StoneguardShieldModel();
    private final TefnutsCallModel tefnutsCall = new TefnutsCallModel();

    public void func_228364_a_(@Nonnull ItemStack stack, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        Item item = stack.func_77973_b();
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).func_179223_d();
            if (block instanceof LimestoneChestBlock || block instanceof ChestSpawnerBlock) {
                TileEntityRendererDispatcher.field_147556_a.func_228852_a_((TileEntity)new LimestoneChestTileEntity(), matrixStack, buffer, combinedLight, combinedOverlay);
            } else if (block instanceof SarcophagusBlock) {
                TileEntityRendererDispatcher.field_147556_a.func_228852_a_((TileEntity)new SarcophagusTileEntity(), matrixStack, buffer, combinedLight, combinedOverlay);
            }
        } else if (item == AtumItems.BRIGAND_SHIELD) {
            this.renderShield(stack, BRIGAND_SHIELD, BRIGAND_SHIELD_MATERIAL, matrixStack, buffer, combinedLight, combinedOverlay);
        } else if (item == AtumItems.STONEGUARD_SHIELD) {
            this.renderShield(stack, STONEGUARD_SHIELD, STONEGUARD_SHIELD_MATERIAL, matrixStack, buffer, combinedLight, combinedOverlay);
        } else if (item == AtumItems.ATUMS_PROTECTION) {
            this.renderShield(stack, ATUMS_PROTECTION, ATUMS_PROTECTION_MATERIAL, matrixStack, buffer, combinedLight, combinedOverlay);
        } else if (item == AtumItems.TEFNUTS_CALL) {
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(1.0f, -1.0f, -1.0f);
            IVertexBuilder vertexBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)buffer, (RenderType)this.tefnutsCall.func_228282_a_(TefnutsCallModel.TEFNUTS_CALL_TEXTURE), (boolean)false, (boolean)stack.func_77962_s());
            this.tefnutsCall.func_225598_a_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.func_227865_b_();
        }
    }

    private void renderShield(@Nonnull ItemStack stack, AbstractShieldModel shieldModel, Material material, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        IVertexBuilder builder = material.func_229314_c_().func_229230_a_(ItemRenderer.func_229113_a_((IRenderTypeBuffer)buffer, (RenderType)shieldModel.func_228282_a_(material.func_229310_a_()), (boolean)false, (boolean)stack.func_77962_s()));
        shieldModel.func_225598_a_(matrixStack, builder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private static Material getShieldMaterial(String fileName) {
        ResourceLocation shieldTexture = SHIELD_CACHE.get(fileName);
        if (shieldTexture == null) {
            shieldTexture = new ResourceLocation("atum", "shield/" + fileName);
            SHIELD_CACHE.put(fileName, shieldTexture);
        }
        ClientHandler.addToShieldAtlas(shieldTexture);
        return new Material(Atlases.field_228745_d_, shieldTexture);
    }
}

