/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.teammetallurgy.atum.entity.HeartOfRaEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HeartOfRaRender
extends EntityRenderer<HeartOfRaEntity> {
    private static final ResourceLocation HEART_OF_RA_TEXTURE = new ResourceLocation("atum", "textures/entity/heart_of_ra.png");
    private static final RenderType RENDER_TYPE = RenderType.func_228640_c_((ResourceLocation)HEART_OF_RA_TEXTURE);
    private static final float CONSTANT = (float)Math.sin(0.7853981633974483);
    private final ModelRenderer cube;
    private final ModelRenderer glass;
    private final ModelRenderer base;

    public HeartOfRaRender(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
        this.field_76989_e = 0.5f;
        this.glass = new ModelRenderer(64, 32, 0, 0);
        this.glass.func_228300_a_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f);
        this.cube = new ModelRenderer(64, 32, 32, 0);
        this.cube.func_228300_a_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f);
        this.base = new ModelRenderer(64, 32, 0, 16);
        this.base.func_228300_a_(-6.0f, 0.0f, -6.0f, 12.0f, 4.0f, 12.0f);
    }

    public void render(@Nonnull HeartOfRaEntity entity, float entityYaw, float partialTicks, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int i) {
        matrixStack.func_227860_a_();
        float lvt_7_1_ = HeartOfRaRender.rotate(entity, partialTicks);
        float lvt_8_1_ = ((float)entity.innerRotation + partialTicks) * 3.0f;
        IVertexBuilder vertextBuilder = buffer.getBuffer(RENDER_TYPE);
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(2.0f, 2.0f, 2.0f);
        matrixStack.func_227861_a_(0.0, -0.1, 0.0);
        int overlay = OverlayTexture.field_229196_a_;
        this.base.func_228308_a_(matrixStack, vertextBuilder, i, overlay);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(lvt_8_1_));
        matrixStack.func_227861_a_(0.0, (double)(1.5f + lvt_7_1_ / 2.0f), 0.0);
        matrixStack.func_227863_a_(new Quaternion(new Vector3f(CONSTANT, 0.0f, CONSTANT), 60.0f, true));
        this.glass.func_228308_a_(matrixStack, vertextBuilder, i, overlay);
        matrixStack.func_227862_a_(0.875f, 0.875f, 0.875f);
        matrixStack.func_227863_a_(new Quaternion(new Vector3f(CONSTANT, 0.0f, CONSTANT), 60.0f, true));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(lvt_8_1_));
        this.glass.func_228308_a_(matrixStack, vertextBuilder, i, overlay);
        matrixStack.func_227862_a_(0.875f, 0.875f, 0.875f);
        matrixStack.func_227863_a_(new Quaternion(new Vector3f(CONSTANT, 0.0f, CONSTANT), 60.0f, true));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(lvt_8_1_));
        this.cube.func_228308_a_(matrixStack, vertextBuilder, i, overlay);
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
        super.func_225623_a_((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, i);
    }

    public static float rotate(HeartOfRaEntity heartOfRa, float rotationModifier) {
        float rotation = (float)heartOfRa.innerRotation + rotationModifier;
        float rotationModified = MathHelper.func_76126_a((float)(rotation * 0.2f)) / 2.0f + 0.5f;
        rotationModified = (rotationModified * rotationModified + rotationModified) * 0.4f;
        return rotationModified - 1.4f;
    }

    @Nonnull
    public ResourceLocation getEntityTexture(@Nonnull HeartOfRaEntity entity) {
        return HEART_OF_RA_TEXTURE;
    }
}

