/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.render.tileentity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.teammetallurgy.atum.blocks.wood.CrateBlock;
import com.teammetallurgy.atum.blocks.wood.tileentity.crate.CrateTileEntity;
import com.teammetallurgy.atum.init.AtumBlocks;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.DualBrightnessCallback;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CrateRender
extends TileEntityRenderer<CrateTileEntity> {
    private static final Map<String, ResourceLocation> CACHE = Maps.newHashMap();
    private final ModelRenderer crateCore = new ModelRenderer(64, 64, 0, 0);
    private final ModelRenderer crateLid;

    public CrateRender(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.crateCore.func_78793_a(8.0f, 9.0f, 0.0f);
        this.crateCore.func_228301_a_(-16.0f, 0.0f, -8.0f, 16.0f, 15.0f, 16.0f, 0.0f);
        this.crateLid = new ModelRenderer(64, 64, 0, 32);
        this.crateLid.func_78793_a(8.0f, 8.0f, 0.0f);
        this.crateLid.func_228301_a_(-16.0f, 0.0f, -8.0f, 16.0f, 1.0f, 16.0f, 0.0f);
    }

    public void render(@Nonnull CrateTileEntity crate, float partialTicks, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        BlockState state = crate.func_145831_w() != null ? crate.func_195044_w() : (BlockState)AtumBlocks.PALM_CRATE.func_176223_P().func_206870_a((IProperty)CrateBlock.FACING, (Comparable)Direction.SOUTH);
        Block block = state.func_177230_c();
        if (block instanceof CrateBlock) {
            matrixStack.func_227860_a_();
            float facingAngle = ((Direction)state.func_177229_b((IProperty)CrateBlock.FACING)).func_185119_l();
            matrixStack.func_227861_a_(0.5, 0.5, 0.5);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-facingAngle));
            matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
            float lidAngle = crate.func_195480_a(partialTicks);
            lidAngle = 1.0f - lidAngle;
            lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
            IVertexBuilder vertexBuilder = this.getBuilder(crate, buffer);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            matrixStack.func_227861_a_(-0.5, -1.5, 0.5);
            TileEntityMerger.ICallbackWrapper callbackWrapper = TileEntityMerger.ICallback::func_225537_b_;
            int brightness = ((Int2IntFunction)callbackWrapper.apply((TileEntityMerger.ICallback)new DualBrightnessCallback())).applyAsInt(combinedLight);
            this.renderCrate(matrixStack, vertexBuilder, this.crateCore, this.crateLid, lidAngle, brightness, combinedOverlay);
            matrixStack.func_227865_b_();
        }
    }

    private void renderCrate(MatrixStack matrixStack, IVertexBuilder vertexBuilder, ModelRenderer core, ModelRenderer lid, float lidAngle, int light, int combinedOverlay) {
        lid.field_78796_g = lidAngle * 0.8975979f;
        core.func_228308_a_(matrixStack, vertexBuilder, light, combinedOverlay);
        lid.func_228308_a_(matrixStack, vertexBuilder, light, combinedOverlay);
    }

    private IVertexBuilder getBuilder(@Nonnull CrateTileEntity crate, @Nonnull IRenderTypeBuffer buffer) {
        String name = Objects.requireNonNull(crate.func_195044_w().func_177230_c().getRegistryName()).func_110623_a();
        ResourceLocation crateTexture = CACHE.get(name);
        if (crateTexture == null) {
            crateTexture = new ResourceLocation("atum", "textures/entity/chest/" + name + ".png");
            CACHE.put(name, crateTexture);
        }
        return buffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)crateTexture));
    }
}

