/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.teammetallurgy.atum.blocks.machines.QuernBlock;
import com.teammetallurgy.atum.blocks.machines.tileentity.QuernTileEntity;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.misc.RenderUtils;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.DualBrightnessCallback;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class QuernRender
extends TileEntityRenderer<QuernTileEntity> {
    private static final ResourceLocation QUERN_STONE = new ResourceLocation("atum", "textures/block/quern_stone.png");
    private static final RenderType QUERN_RENDER = RenderType.func_228638_b_((ResourceLocation)QUERN_STONE);
    public ModelRenderer core;
    private ModelRenderer coreLeft;
    private ModelRenderer coreFront;
    private ModelRenderer coreBack = new ModelRenderer(64, 64, 0, 34);
    private ModelRenderer coreRight;
    private ModelRenderer handle;

    public QuernRender(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.coreBack.func_78793_a(0.0f, 0.0f, 0.0f);
        this.coreBack.func_228301_a_(-4.0f, -2.0f, 5.0f, 8.0f, 4.0f, 1.0f, 0.0f);
        this.coreLeft = new ModelRenderer(64, 64, 0, 48);
        this.coreLeft.func_78793_a(0.0f, 0.0f, 0.0f);
        this.coreLeft.func_228301_a_(-6.0f, -2.0f, -4.0f, 1.0f, 4.0f, 8.0f, 0.0f);
        this.coreRight = new ModelRenderer(64, 64, 0, 48);
        this.coreRight.func_78793_a(0.0f, 0.0f, 0.0f);
        this.coreRight.func_228301_a_(5.0f, -2.0f, -4.0f, 1.0f, 4.0f, 8.0f, 0.0f);
        this.coreFront = new ModelRenderer(64, 64, 0, 34);
        this.coreFront.func_78793_a(0.0f, 0.0f, 0.0f);
        this.coreFront.func_228301_a_(-4.0f, -2.0f, -6.0f, 8.0f, 4.0f, 1.0f, 0.0f);
        this.core = new ModelRenderer(64, 64, 0, 18);
        this.core.func_78793_a(0.0f, 20.0f, 0.0f);
        this.core.func_228301_a_(-5.0f, -2.0f, -5.0f, 10.0f, 4.0f, 10.0f, 0.0f);
        this.handle = new ModelRenderer(64, 64, 0, 0);
        this.handle.func_78793_a(0.0f, 0.0f, 0.0f);
        this.handle.func_228301_a_(-5.0f, -5.0f, -3.0f, 1.0f, 3.0f, 1.0f, 0.0f);
        this.core.func_78792_a(this.coreBack);
        this.core.func_78792_a(this.coreLeft);
        this.core.func_78792_a(this.coreRight);
        this.core.func_78792_a(this.coreFront);
        this.core.func_78792_a(this.handle);
    }

    public void render(@Nonnull QuernTileEntity quern, float partialTicks, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        World world = quern.func_145831_w();
        boolean hasWorld = world != null;
        BlockState state = hasWorld ? quern.func_195044_w() : (BlockState)AtumBlocks.QUERN.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)Direction.SOUTH);
        Block block = state.func_177230_c();
        if (block instanceof QuernBlock) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 1.5, 0.5);
            matrixStack.func_227862_a_(0.95f, 1.0f, 0.95f);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-180.0f));
            float angle = ((Direction)state.func_177229_b((IProperty)QuernBlock.FACING)).func_185119_l();
            if ((double)Math.abs(angle) > 1.0E-5) {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
            }
            float quernRotation = quern.getRotations();
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-quernRotation));
            IVertexBuilder builder = buffer.getBuffer(QUERN_RENDER);
            TileEntityMerger.ICallbackWrapper callbackWrapper = TileEntityMerger.ICallback::func_225537_b_;
            int brightness = ((Int2IntFunction)callbackWrapper.apply((TileEntityMerger.ICallback)new DualBrightnessCallback())).applyAsInt(combinedLight);
            this.core.func_228308_a_(matrixStack, builder, brightness, combinedOverlay);
            matrixStack.func_227865_b_();
            ItemStack stack = quern.func_70301_a(0);
            if (!stack.func_190926_b()) {
                RenderUtils.renderItem((TileEntity)quern, stack, quernRotation, -0.7, true, matrixStack, buffer, combinedLight, combinedOverlay);
            }
        }
    }
}

