/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.undead;

import com.teammetallurgy.atum.entity.ai.pathfinding.ClimberGroundPathNavigator;
import com.teammetallurgy.atum.entity.undead.UndeadBaseEntity;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WraithEntity
extends UndeadBaseEntity {
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(WraithEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private int cycleHeight;
    private final int cycleTime;

    public WraithEntity(EntityType<? extends WraithEntity> entityType, World world) {
        super(entityType, world);
        this.field_70728_aV = 6;
        this.func_98053_h(false);
        this.cycleTime = (int)(Math.random() * 40.0 + 80.0);
        this.cycleHeight = (int)(Math.random() * (double)this.cycleTime);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new AIWraithAttack(this));
    }

    @Override
    protected void func_175456_n() {
        super.func_175456_n();
        this.field_70715_bh.func_75776_a(1, new AIWraithTarget<PlayerEntity>(this, PlayerEntity.class));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(30.0);
    }

    @Nonnull
    protected PathNavigator func_175447_b(@Nonnull World world) {
        return new ClimberGroundPathNavigator((MobEntity)this, world);
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_190022_cI;
    }

    @Override
    protected SoundEvent func_184601_bQ(@Nonnull DamageSource damageSource) {
        return SoundEvents.field_190024_cK;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190023_cJ;
    }

    protected void func_180429_a(@Nonnull BlockPos pos, @Nonnull BlockState state) {
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    @Override
    public void func_70636_d() {
        this.cycleHeight = (this.cycleHeight + 1) % this.cycleTime;
        super.func_70636_d();
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    private boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    private void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public boolean func_70652_k(@Nonnull Entity entity) {
        LivingEntity livingBase;
        if (!super.func_70652_k(entity)) {
            return false;
        }
        if (this.field_70146_Z.nextDouble() <= 0.175 && entity instanceof LivingEntity && !(livingBase = (LivingEntity)entity).func_70644_a(Effects.field_76421_d)) {
            livingBase.func_195064_c(new EffectInstance(Effects.field_76421_d, 80, 1));
        }
        return true;
    }

    private static class AIWraithTarget<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        AIWraithTarget(WraithEntity wraith, Class<T> classTarget) {
            super((MobEntity)wraith, classTarget, true);
        }

        public boolean func_75250_a() {
            float f = this.field_75299_d.func_70013_c();
            return f < 0.5f && super.func_75250_a();
        }
    }

    private static class AIWraithAttack
    extends MeleeAttackGoal {
        AIWraithAttack(WraithEntity wraith) {
            super((CreatureEntity)wraith, 1.0, true);
        }

        public boolean func_75253_b() {
            float brightness = this.field_75441_b.func_70013_c();
            if (brightness >= 0.5f && this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b(null);
                return false;
            }
            return super.func_75253_b();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 4.0f + attackTarget.func_213311_cf();
        }
    }
}

