/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.integration.jei;

import com.teammetallurgy.atum.api.recipe.IAtumRecipeType;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.integration.jei.categories.KilnRecipeCategory;
import com.teammetallurgy.atum.integration.jei.categories.QuernRecipeCategory;
import com.teammetallurgy.atum.integration.jei.categories.SpinningWheelRecipeCategory;
import com.teammetallurgy.atum.misc.recipe.RecipeHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

@JeiPlugin
public class JEIIntegration
implements IModPlugin {
    public static final ResourceLocation QUERN = new ResourceLocation("atum", "quern");
    public static final ResourceLocation SPINNING_WHEEL = new ResourceLocation("atum", "spinning_wheel");
    public static final ResourceLocation KILN = new ResourceLocation("atum", "kiln");

    @Nonnull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("atum");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AtumBlocks.QUERN), new ResourceLocation[]{QUERN});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AtumBlocks.SPINNING_WHEEL), new ResourceLocation[]{SPINNING_WHEEL});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AtumBlocks.KILN), new ResourceLocation[]{KILN, VanillaRecipeCategoryUid.FUEL});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)AtumBlocks.LIMESTONE_FURNACE), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE, VanillaRecipeCategoryUid.FUEL});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registry) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            this.addRecipes(registry, (World)world, IAtumRecipeType.KILN, KILN);
            registry.addRecipes(RecipeHelper.getKilnRecipesFromFurnace(world.func_199532_z()), KILN);
            this.addRecipes(registry, (World)world, IAtumRecipeType.QUERN, QUERN);
            this.addRecipes(registry, (World)world, IAtumRecipeType.SPINNING_WHEEL, SPINNING_WHEEL);
        }
        this.addInfo(new ItemStack((IItemProvider)AtumItems.EMMER_DOUGH), registry);
    }

    private <C extends IInventory, T extends IRecipe<C>> void addRecipes(@Nonnull IRecipeRegistration registry, World world, IRecipeType<T> recipeType, ResourceLocation name) {
        registry.addRecipes((Collection)RecipeHelper.getRecipes(world.func_199532_z(), recipeType).stream().filter(r -> r.func_192400_c().stream().noneMatch(Ingredient::func_203189_d)).collect(Collectors.toCollection(ArrayList::new)), name);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new QuernRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SpinningWheelRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new KilnRecipeCategory(guiHelper)});
    }

    private void addInfo(ItemStack stack, IRecipeRegistration registry) {
        registry.addIngredientInfo((Object)stack, VanillaTypes.ITEM, new String[]{"jei." + stack.func_77973_b().func_77658_a()});
    }
}

