/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.network.packet;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncHandStackSizePacket {
    private final ItemStack stack;
    private final int hand;

    public SyncHandStackSizePacket(@Nonnull ItemStack stack, int hand) {
        this.stack = stack;
        this.hand = hand;
    }

    public static void encode(SyncHandStackSizePacket packet, PacketBuffer buf) {
        buf.func_150788_a(packet.stack);
        buf.func_150787_b(packet.hand);
    }

    public static SyncHandStackSizePacket decode(PacketBuffer buf) {
        return new SyncHandStackSizePacket(buf.func_150791_c(), buf.func_150792_a());
    }

    public static class Handler {
        public static void handle(SyncHandStackSizePacket message, Supplier<NetworkEvent.Context> ctx) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                Hand hand = message.hand == 1 ? Hand.MAIN_HAND : Hand.OFF_HAND;
                EquipmentSlotType handType = hand == Hand.MAIN_HAND ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND;
                ItemStack heldStack = player.func_184586_b(hand);
                if (heldStack.func_190916_E() == 0) {
                    player.func_184201_a(handType, message.stack);
                } else {
                    player.func_184201_a(handType, new ItemStack((IItemProvider)heldStack.func_77973_b(), heldStack.func_190916_E() + 1));
                }
                ctx.get().setPacketHandled(true);
            }
        }
    }
}

