/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.spawner;

import com.teammetallurgy.atum.entity.bandit.BanditBaseEntity;
import com.teammetallurgy.atum.entity.bandit.SergeantEntity;
import com.teammetallurgy.atum.init.AtumBiomes;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.init.AtumFeatures;
import com.teammetallurgy.atum.misc.AtumConfig;
import com.teammetallurgy.atum.world.gen.structure.StructureHelper;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;

public class BanditPatrolSpawner {
    private int timer;

    public int tick(ServerWorld serverWorld, boolean spawnHostileMobs) {
        if (!spawnHostileMobs) {
            return 0;
        }
        if ((Integer)AtumConfig.MOBS.banditPatrolFrequency.get() < 1) {
            return 0;
        }
        Random rand = serverWorld.field_73012_v;
        --this.timer;
        if (this.timer > 0) {
            return 0;
        }
        this.timer += rand.nextInt((Integer)AtumConfig.MOBS.banditPatrolFrequency.get());
        if (serverWorld.func_72935_r()) {
            int z;
            int playerAmount = serverWorld.func_217369_A().size();
            if (playerAmount < 1) {
                return 0;
            }
            PlayerEntity player = (PlayerEntity)serverWorld.func_217369_A().get(rand.nextInt(playerAmount));
            if (player.func_175149_v()) {
                return 0;
            }
            int x = (20 + rand.nextInt(20)) * (rand.nextBoolean() ? -1 : 1);
            BlockPos.Mutable mutablePos = new BlockPos.Mutable((Entity)player).func_196234_d(x, 0, z = (20 + rand.nextInt(20)) * (rand.nextBoolean() ? -1 : 1));
            if (!serverWorld.isAreaLoaded((BlockPos)mutablePos, 8) || StructureHelper.doesChunkHaveStructure((IWorld)serverWorld, mutablePos.func_177958_n(), mutablePos.func_177952_p(), AtumFeatures.PYRAMID)) {
                return 0;
            }
            Biome biome = serverWorld.func_226691_t_((BlockPos)mutablePos);
            if (biome == AtumBiomes.DRIED_RIVER || biome == AtumBiomes.OASIS) {
                return 0;
            }
            int amount = 0;
            int difficulty = 1 + (int)Math.ceil(serverWorld.func_175649_E((BlockPos)mutablePos).func_180168_b());
            SergeantEntity leadingEntity = null;
            for (int size = 0; size < difficulty; ++size) {
                EntityType<? extends BanditBaseEntity> entityType = this.getEntityType(rand);
                ++amount;
                mutablePos.func_185336_p(serverWorld.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (BlockPos)mutablePos).func_177956_o());
                if (size == 0) {
                    SergeantEntity leader = (SergeantEntity)AtumEntities.SERGEANT.func_200721_a((World)serverWorld);
                    if (leader == null || !this.spawnLeader(leader, (World)serverWorld, (BlockPos)mutablePos, rand)) break;
                    leadingEntity = leader;
                } else {
                    this.spawnPatroller(entityType, (World)serverWorld, (BlockPos)mutablePos, rand, leadingEntity);
                }
                mutablePos.func_223471_o(mutablePos.func_177958_n() + rand.nextInt(5) - rand.nextInt(5));
                mutablePos.func_223472_q(mutablePos.func_177952_p() + rand.nextInt(5) - rand.nextInt(5));
            }
            return amount;
        }
        return 0;
    }

    private boolean spawnPatroller(EntityType<? extends BanditBaseEntity> entityType, World world, BlockPos pos, Random rand, @Nullable BanditBaseEntity leadingEntity) {
        BlockState state = world.func_180495_p(pos);
        if (!WorldEntitySpawner.func_222266_a((IBlockReader)world, (BlockPos)pos, (BlockState)state, (IFluidState)state.func_204520_s())) {
            return false;
        }
        if (!BanditBaseEntity.canSpawn(entityType, (IWorld)world, SpawnReason.PATROL, pos, rand)) {
            return false;
        }
        BanditBaseEntity bandit = (BanditBaseEntity)entityType.func_200721_a(world);
        if (bandit != null) {
            bandit.setCanPatrol(true);
            if (leadingEntity != null) {
                bandit.setLeadingEntity(leadingEntity);
            }
            bandit.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            bandit.func_213386_a((IWorld)world, world.func_175649_E(pos), SpawnReason.PATROL, null, null);
            world.func_217376_c((Entity)bandit);
            return true;
        }
        return false;
    }

    private boolean spawnLeader(BanditBaseEntity leader, World world, BlockPos pos, Random rand) {
        BlockState state = world.func_180495_p(pos);
        if (!WorldEntitySpawner.func_222266_a((IBlockReader)world, (BlockPos)pos, (BlockState)state, (IFluidState)state.func_204520_s())) {
            return false;
        }
        if (!BanditBaseEntity.canSpawn((EntityType<? extends BanditBaseEntity>)leader.func_200600_R(), (IWorld)world, SpawnReason.PATROL, pos, rand)) {
            return false;
        }
        leader.func_213635_r(true);
        leader.func_213636_ee();
        leader.setCanPatrol(true);
        leader.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        leader.func_213386_a((IWorld)world, world.func_175649_E(pos), SpawnReason.PATROL, null, null);
        world.func_217376_c((Entity)leader);
        return true;
    }

    private EntityType<? extends BanditBaseEntity> getEntityType(Random rand) {
        double chance = rand.nextDouble();
        if (chance <= 0.5) {
            return AtumEntities.BRIGAND;
        }
        if (chance > 0.5 && chance < 0.87) {
            return AtumEntities.NOMAD;
        }
        return AtumEntities.BARBARIAN;
    }
}

