/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.function;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.util.RenderingVectorUtils;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nonnull;

public interface VFXColorFunction<T extends EntityVisualFX> {
    public static final Random rand = new Random();
    public static final VFXColorFunction<? extends EntityVisualFX> WHITE = VFXColorFunction.constant(Color.WHITE);
    public static final VFXColorFunction<? extends EntityVisualFX> BLACK = VFXColorFunction.constant(Color.BLACK);

    @Nonnull
    public Color getColor(@Nonnull T var1, float var2);

    public static <T extends EntityVisualFX> VFXColorFunction<T> rainbow(final int tickSpeed) {
        final float fTickSpeed = tickSpeed;
        return new VFXColorFunction<T>(){

            @Override
            @Nonnull
            public Color getColor(@Nonnull T fx, float pTicks) {
                return Color.getHSBColor((float)(ClientScheduler.getClientTick() % (long)tickSpeed) / fTickSpeed, 1.0f, 1.0f);
            }
        };
    }

    public static <T extends EntityVisualFX> VFXColorFunction<T> randomBetween(Color c1, Color c2) {
        final float[] hsb1 = Color.RGBtoHSB(c1.getRed(), c1.getGreen(), c1.getBlue(), null);
        final float[] hsb2 = Color.RGBtoHSB(c2.getRed(), c2.getGreen(), c2.getBlue(), null);
        final float degree = rand.nextFloat();
        return new VFXColorFunction<T>(){

            @Override
            @Nonnull
            public Color getColor(@Nonnull T fx, float pTicks) {
                float h = RenderingVectorUtils.interpolate(hsb1[0], hsb2[0], degree);
                float s = RenderingVectorUtils.interpolate(hsb1[1], hsb2[1], degree);
                float b = RenderingVectorUtils.interpolate(hsb1[2], hsb2[2], degree);
                return Color.getHSBColor(h, s, b);
            }
        };
    }

    public static <T extends EntityVisualFX> VFXColorFunction<T> random() {
        final Color c = Color.getHSBColor(rand.nextFloat(), 1.0f, 1.0f);
        return new VFXColorFunction<T>(){

            @Override
            @Nonnull
            public Color getColor(@Nonnull T fx, float pTicks) {
                return c;
            }
        };
    }

    public static <T extends EntityVisualFX> VFXColorFunction<T> constant(final Color c) {
        return new VFXColorFunction<T>(){

            @Override
            @Nonnull
            public Color getColor(@Nonnull T fx, float pTicks) {
                return c;
            }
        };
    }
}

