/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.vfx;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.context.base.BatchRenderContext;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.RenderingVectorUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.observerlib.client.util.BufferDecoratorBuilder;
import java.awt.Color;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.Vector3f;

public class FXBlock
extends EntityVisualFX {
    private BlockState blockState = null;
    private Vector3 rotationDegreeAxis = new Vector3();
    private Vector3 prevRotationDegreeAxis = new Vector3();
    private Vector3 rotationChange = new Vector3();

    public FXBlock(Vector3 pos) {
        super(pos);
    }

    public FXBlock setBlockState(BlockState blockState) {
        this.blockState = blockState;
        return this;
    }

    public FXBlock tumble() {
        this.rotationDegreeAxis = Vector3.positiveYRandom().multiply(360);
        this.rotationChange = Vector3.random().multiply(12);
        return this;
    }

    public Vector3 getInterpolatedRotation(float percent) {
        return new Vector3(RenderingVectorUtils.interpolate(this.prevRotationDegreeAxis.getX(), this.rotationDegreeAxis.getX(), percent), RenderingVectorUtils.interpolate(this.prevRotationDegreeAxis.getY(), this.rotationDegreeAxis.getY(), percent), RenderingVectorUtils.interpolate(this.prevRotationDegreeAxis.getZ(), this.rotationDegreeAxis.getZ(), percent));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.rotationChange.lengthSquared() > 0.0) {
            this.prevRotationDegreeAxis = this.rotationDegreeAxis.clone();
            this.rotationDegreeAxis.add(this.rotationChange);
        }
    }

    @Override
    public <T extends EntityVisualFX> void render(BatchRenderContext<T> ctx, MatrixStack renderStack, IVertexBuilder vb, float pTicks) {
        if (this.blockState == null) {
            return;
        }
        int alpha = this.getAlpha(pTicks);
        Color c = this.getColor(pTicks);
        int[] colorOverride = new int[]{c.getRed(), c.getGreen(), c.getBlue(), alpha};
        Vector3 translate = this.getRenderPosition(pTicks).subtract(RenderingVectorUtils.getStandardTranslationRemovalVector(pTicks));
        Vector3 rotation = this.getInterpolatedRotation(pTicks);
        float scale = this.getScale(pTicks);
        renderStack.func_227860_a_();
        renderStack.func_227861_a_(translate.getX(), translate.getY(), translate.getZ());
        renderStack.func_227861_a_(0.5, 0.5, 0.5);
        renderStack.func_227862_a_(scale, scale, scale);
        renderStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)rotation.getX()));
        renderStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)rotation.getY()));
        renderStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)rotation.getZ()));
        renderStack.func_227861_a_(-0.5, -0.5, -0.5);
        new BufferDecoratorBuilder().setColorDecorator((r, g, b, a) -> colorOverride).decorate(vb, decorated -> RenderingUtils.renderSimpleBlockModel(this.blockState, renderStack, decorated));
        renderStack.func_227865_b_();
    }
}

