/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.resource;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.common.util.NameUtil;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;

public class SpriteSheetResource
extends AbstractRenderableTexture {
    protected float uPart;
    protected float vPart;
    protected int frameCount;
    protected int rows;
    protected int columns;
    private final AbstractRenderableTexture resource;

    public SpriteSheetResource(AbstractRenderableTexture resource) {
        this(resource, 1, 1);
    }

    public SpriteSheetResource(AbstractRenderableTexture resource, int rows, int columns) {
        super(NameUtil.suffixPath(resource.getKey(), "_sprite"));
        if (rows <= 0 || columns <= 0) {
            throw new IllegalArgumentException("Can't instantiate a sprite sheet without any rows or columns!");
        }
        this.frameCount = rows * columns;
        this.rows = rows;
        this.columns = columns;
        this.resource = resource;
        this.uPart = 1.0f / (float)columns;
        this.vPart = 1.0f / (float)rows;
    }

    @Override
    public void bindTexture() {
        this.resource.bindTexture();
    }

    @Override
    public RenderState.TextureState asState() {
        return this.resource.asState();
    }

    @Override
    public Tuple<Float, Float> getUVOffset() {
        long timer = ClientScheduler.getClientTick();
        return this.getUVOffset(timer);
    }

    @Override
    public float getUWidth() {
        return this.getULength();
    }

    @Override
    public float getVWidth() {
        return this.getVLength();
    }

    public AbstractRenderableTexture getResource() {
        return this.resource;
    }

    public float getULength() {
        return this.uPart;
    }

    public float getVLength() {
        return this.vPart;
    }

    public Tuple<Float, Float> getUVOffset(long frameTimer) {
        int frame = (int)(frameTimer % (long)this.frameCount);
        return new Tuple((Object)Float.valueOf((float)(frame % this.columns) * this.uPart), (Object)Float.valueOf((float)(frame / this.columns) * this.vPart));
    }

    public Tuple<Float, Float> getUVOffset(EntityComplexFX fx) {
        float perc = (float)fx.getAge() / (float)fx.getMaxAge();
        long timer = MathHelper.func_76141_d((float)((float)this.getFrameCount() * perc));
        return this.getUVOffset(timer);
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }
}

