/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.screen.base.ConstellationDiscoveryScreen;
import hellfirepvp.astralsorcery.client.screen.base.NavigationArrowScreen;
import hellfirepvp.astralsorcery.client.screen.base.SkyScreen;
import hellfirepvp.astralsorcery.client.screen.base.TileConstellationDiscoveryScreen;
import hellfirepvp.astralsorcery.client.screen.telescope.TelescopeRotationDrawArea;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingConstellationUtils;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.star.StarLocation;
import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.client.PktRotateTelescope;
import hellfirepvp.astralsorcery.common.tile.TileTelescope;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Tuple;

public class ScreenTelescope
extends TileConstellationDiscoveryScreen<TileTelescope, TelescopeRotationDrawArea>
implements SkyScreen,
NavigationArrowScreen {
    private TileTelescope.TelescopeRotation rotation;
    private Rectangle rectArrowCW = null;
    private Rectangle rectArrowCCW = null;

    public ScreenTelescope(TileTelescope telescope) {
        super(telescope, 280, 280);
        this.rotation = telescope.getRotation();
    }

    @Override
    @Nonnull
    protected List<TelescopeRotationDrawArea> createDrawAreas() {
        LinkedList<TelescopeRotationDrawArea> areas = new LinkedList<TelescopeRotationDrawArea>();
        for (TileTelescope.TelescopeRotation r : TileTelescope.TelescopeRotation.values()) {
            areas.add(new TelescopeRotationDrawArea(this, r, this.getGuiBox()));
        }
        return areas;
    }

    @Override
    protected void fillConstellations(WorldContext ctx, List<TelescopeRotationDrawArea> drawAreas) {
        Random gen = ctx.getDayRandom();
        PlayerProgress prog = ResearchHelper.getClientProgress();
        List<IWeakConstellation> cst = new ArrayList();
        for (IConstellation active : ctx.getActiveCelestialsHandler().getCurrentRenderPositions().keySet()) {
            if (!(active instanceof IWeakConstellation) || !active.canDiscover((PlayerEntity)Minecraft.func_71410_x().field_71439_g, prog)) continue;
            cst.add((IWeakConstellation)active);
        }
        Collections.shuffle(cst, gen);
        cst = cst.subList(0, Math.min(drawAreas.size(), cst.size()));
        for (IWeakConstellation constellation : cst) {
            TelescopeRotationDrawArea associatedArea;
            Point foundPoint;
            while ((foundPoint = this.findEmptySpace(gen, associatedArea = MiscUtils.getRandomEntry(drawAreas, gen))) == null) {
            }
            associatedArea.addConstellationToArea(constellation, foundPoint, 150.0f);
        }
    }

    private Point findEmptySpace(Random rand, TelescopeRotationDrawArea area) {
        int size = 150;
        int wdh = this.guiWidth - 6 - size;
        int hgt = this.guiHeight - 6 - size;
        int rX = 6 + rand.nextInt(wdh);
        int rY = 6 + rand.nextInt(hgt);
        Rectangle constellationRect = new Rectangle(rX, rY, size, size);
        for (ConstellationDiscoveryScreen.ConstellationDisplayInformation info : area.getDisplayMap().values()) {
            Point offset = info.getRenderPosition();
            Rectangle otherRect = new Rectangle(offset.x, offset.y, size, size);
            if (!otherRect.intersects(constellationRect)) continue;
            return null;
        }
        return new Point(rX, rY);
    }

    @Override
    public void render(int mouseX, int mouseY, float pTicks) {
        RenderSystem.enableDepthTest();
        super.render(mouseX, mouseY, pTicks);
        this.drawWHRect(TexturesAS.TEX_GUI_TELESCOPE);
        this.drawConstellationCell(pTicks);
        this.drawNavArrows(mouseX, mouseY, pTicks);
    }

    private void drawNavArrows(int mouseX, int mouseY, float pTicks) {
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        this.rectArrowCCW = this.drawArrow(this.guiLeft - 40, this.guiTop + this.guiHeight / 2, this.getGuiZLevel(), NavigationArrowScreen.Type.LEFT, mouseX, mouseY, pTicks);
        this.rectArrowCW = this.drawArrow(this.guiLeft + this.guiWidth + 10, this.guiTop + this.guiHeight / 2, this.getGuiZLevel(), NavigationArrowScreen.Type.RIGHT, mouseX, mouseY, pTicks);
        RenderSystem.disableBlend();
    }

    private void drawConstellationCell(float pTicks) {
        boolean canSeeSky = this.canObserverSeeSky(((TileTelescope)this.getTile()).func_174877_v(), 1);
        RenderSystem.disableAlphaTest();
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        this.setBlitOffset(-10);
        this.drawSkyBackground(pTicks, canSeeSky);
        if (!this.isInitialized()) {
            this.setBlitOffset(0);
            Blending.DEFAULT.apply();
            RenderSystem.disableBlend();
            RenderSystem.enableAlphaTest();
            return;
        }
        WorldContext ctx = this.getContext();
        if (ctx != null && canSeeSky) {
            Random gen = ctx.getDayRandom();
            PlayerProgress prog = ResearchHelper.getClientProgress();
            for (int i = 0; i < this.rotation.ordinal(); ++i) {
                gen.nextFloat();
            }
            this.setBlitOffset(-9);
            float starSize = 5.0f;
            TexturesAS.TEX_STAR_1.bindTexture();
            RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
                for (int i = 0; i < 72 + gen.nextInt(108); ++i) {
                    float innerOffsetX = starSize + gen.nextFloat() * ((float)this.guiWidth - starSize * 2.0f) + (float)this.getGuiLeft();
                    float innerOffsetY = starSize + gen.nextFloat() * ((float)this.guiHeight - starSize * 2.0f) + (float)this.getGuiTop();
                    float brightness = 0.4f + RenderingConstellationUtils.stdFlicker(ClientScheduler.getClientTick(), pTicks, 10 + gen.nextInt(20)) * 0.5f;
                    brightness = this.multiplyStarBrightness(pTicks, brightness);
                    RenderingGuiUtils.rect(buf, this).at(innerOffsetX, innerOffsetY).dim(starSize, starSize).color(brightness, brightness, brightness, brightness).draw();
                }
            });
            this.setBlitOffset(-7);
            for (TelescopeRotationDrawArea area : this.getVisibleDrawAreas()) {
                for (IConstellation cst : area.getDisplayMap().keySet()) {
                    ConstellationDiscoveryScreen.ConstellationDisplayInformation info = area.getDisplayMap().get(cst);
                    info.getFrameDrawInformation().clear();
                    Point pos = info.getRenderPosition();
                    int size = (int)info.getRenderSize();
                    float rainBr = 1.0f - Minecraft.func_71410_x().field_71441_e.func_72867_j(pTicks);
                    Map<StarLocation, Rectangle> cstRenderInfo = RenderingConstellationUtils.renderConstellationIntoGUI(cst, pos.x + this.guiLeft, pos.y + this.guiTop, this.getGuiZLevel(), size, size, 2.5, () -> Float.valueOf(RenderingConstellationUtils.conCFlicker(ClientScheduler.getClientTick(), pTicks, 5 + gen.nextInt(15)) * rainBr), prog.hasConstellationDiscovered(cst), true);
                    info.getFrameDrawInformation().putAll(cstRenderInfo);
                }
            }
            this.setBlitOffset(-5);
            this.renderDrawnLines(gen, pTicks);
        }
        this.setBlitOffset(0);
        Blending.DEFAULT.apply();
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
    }

    private void drawSkyBackground(float pTicks, boolean canSeeSky) {
        Tuple<Color, Color> rgbFromTo = SkyScreen.getSkyGradient(canSeeSky, 1.0f, pTicks);
        RenderingDrawUtils.drawGradientRect(this.getGuiZLevel(), this.guiLeft + 5, this.guiTop + 5, this.guiLeft + this.guiWidth - 5, this.guiTop + this.guiHeight - 5, ((Color)rgbFromTo.func_76341_a()).getRGB(), ((Color)rgbFromTo.func_76340_b()).getRGB());
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        Point p = new Point((int)mouseX, (int)mouseY);
        if (this.rectArrowCW != null && this.rectArrowCW.contains(p)) {
            PktRotateTelescope pkt = new PktRotateTelescope(true, ((TileTelescope)this.getTile()).func_145831_w().func_201675_m().func_186058_p(), ((TileTelescope)this.getTile()).func_174877_v());
            PacketChannel.CHANNEL.sendToServer(pkt);
            return true;
        }
        if (this.rectArrowCCW != null && this.rectArrowCCW.contains(p)) {
            PktRotateTelescope pkt = new PktRotateTelescope(false, ((TileTelescope)this.getTile()).func_145831_w().func_201675_m().func_186058_p(), ((TileTelescope)this.getTile()).func_174877_v());
            PacketChannel.CHANNEL.sendToServer(pkt);
            return true;
        }
        return false;
    }

    public void handleRotationChange(boolean isClockwise) {
        this.rotation = isClockwise ? this.rotation.nextClockWise() : this.rotation.nextCounterClockWise();
        this.clearDrawing();
    }

    public TileTelescope.TelescopeRotation getRotation() {
        return this.rotation;
    }

    @Override
    protected boolean shouldRightClickCloseScreen(double mouseX, double mouseY) {
        return true;
    }

    @Override
    protected boolean isMouseRotatingGui() {
        return false;
    }
}

