/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.base;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.screen.base.WidthHeightScreen;
import hellfirepvp.astralsorcery.client.util.MouseUtil;
import hellfirepvp.astralsorcery.client.util.RenderingConstellationUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.SkyHandler;
import hellfirepvp.astralsorcery.common.constellation.star.StarConnection;
import hellfirepvp.astralsorcery.common.constellation.star.StarLocation;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.client.PktDiscoverConstellation;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;

public abstract class ConstellationDiscoveryScreen<D extends DrawArea>
extends WidthHeightScreen {
    public static final int DEFAULT_CONSTELLATION_SIZE = 150;
    private List<D> drawAreas = new LinkedList<D>();
    private D currentDrawArea = null;
    private List<DrawnLine> drawnLines = new LinkedList<DrawnLine>();
    private Point dragStart;
    private Point dragEnd;
    private boolean initialized = false;

    protected ConstellationDiscoveryScreen(ITextComponent titleIn, int guiHeight, int guiWidth) {
        super(titleIn, guiHeight, guiWidth);
    }

    @Override
    protected void init() {
        super.init();
        this.drawAreas = this.createDrawAreas();
        if (this.getContext() != null) {
            this.fillConstellations(this.getContext(), this.drawAreas);
            this.initialized = true;
        }
    }

    protected boolean isMouseRotatingGui() {
        return true;
    }

    @Nonnull
    protected abstract List<D> createDrawAreas();

    protected abstract void fillConstellations(WorldContext var1, List<D> var2);

    protected WorldContext getContext() {
        return SkyHandler.getContext((World)Minecraft.func_71410_x().field_71441_e, LogicalSide.CLIENT);
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    @Nullable
    public D getCurrentDrawArea() {
        return this.currentDrawArea;
    }

    public List<D> getVisibleDrawAreas() {
        return this.drawAreas.stream().filter(DrawArea::isVisible).collect(Collectors.toList());
    }

    public List<D> getContainingDrawAreas(double mouseX, double mouseY) {
        return this.drawAreas.stream().filter(area -> area.contains(mouseX, mouseY)).collect(Collectors.toList());
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.initialized && this.getContext() != null) {
            this.fillConstellations(this.getContext(), this.drawAreas);
            this.initialized = true;
        }
    }

    protected float multiplyStarBrightness(float pTicks, float brightnessIn) {
        return MathHelper.func_76131_a((float)((brightnessIn *= Minecraft.func_71410_x().field_71441_e.func_228330_j_(pTicks) * 2.0f) * (1.0f - Minecraft.func_71410_x().field_71441_e.func_72867_j(pTicks))), (float)0.0f, (float)1.0f);
    }

    public void render(int mouseX, int mouseY, float pTicks) {
        if (this.isMouseRotatingGui()) {
            if (ConstellationDiscoveryScreen.hasShiftDown() && Minecraft.func_71410_x().field_71417_B.func_198035_h()) {
                MouseUtil.ungrab();
            }
            if (!ConstellationDiscoveryScreen.hasShiftDown() && !Minecraft.func_71410_x().field_71417_B.func_198035_h()) {
                MouseUtil.grab();
            }
        }
        super.render(mouseX, mouseY, pTicks);
    }

    protected void renderDrawnLines(Random rand, float pTicks) {
        if (!this.canDraw()) {
            this.clearDrawing();
            return;
        }
        float lineBreadth = 2.0f;
        Supplier<Float> brightnessFn = () -> Float.valueOf(RenderingConstellationUtils.conCFlicker(ClientScheduler.getClientTick(), pTicks, 5 + rand.nextInt(10)));
        TexturesAS.TEX_STAR_CONNECTION.bindTexture();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
            for (DrawnLine line : this.drawnLines) {
                this.drawLine((BufferBuilder)buf, pTicks, line.from, line.to, brightnessFn, lineBreadth);
            }
            if (this.dragStart != null && this.dragEnd != null) {
                Point adjStart = new Point(this.dragStart.x - this.guiLeft, this.dragStart.y - this.guiTop);
                Point adjEnd = new Point(this.dragEnd.x - this.guiLeft, this.dragEnd.y - this.guiTop);
                this.drawLine((BufferBuilder)buf, pTicks, adjStart, adjEnd, () -> Float.valueOf(0.8f), lineBreadth);
            }
        });
    }

    private void drawLine(BufferBuilder buf, float pTicks, Point from, Point to, Supplier<Float> brightnessFn, float lineBreadth) {
        float brightness = brightnessFn.get().floatValue();
        float starBr = this.multiplyStarBrightness(pTicks, brightness);
        if (starBr <= 0.0f) {
            return;
        }
        starBr = starBr * 0.75f + 0.25f;
        Vector3 fromStar = new Vector3((double)this.guiLeft + from.getX(), (double)this.guiTop + from.getY(), (double)this.getGuiZLevel());
        Vector3 toStar = new Vector3((double)this.guiLeft + to.getX(), (double)this.guiTop + to.getY(), (double)this.getGuiZLevel());
        Vector3 dir = toStar.clone().subtract(fromStar);
        Vector3 degLot = dir.clone().crossProduct(Vector3.RotAxis.Z_AXIS).normalize().multiply(lineBreadth);
        Vector3 vec00 = fromStar.clone().add(degLot);
        Vector3 vecV = degLot.clone().multiply(-2);
        for (int i = 0; i < 4; ++i) {
            int u = (i + 1 & 2) >> 1;
            int v = (i + 2 & 2) >> 1;
            Vector3 pos = vec00.clone().add(dir.clone().multiply(u)).add(vecV.clone().multiply(v));
            pos.drawPos((IVertexBuilder)buf).func_227885_a_(starBr, starBr, starBr, Math.max(0.0f, starBr)).func_225583_a_((float)u, (float)v).func_181675_d();
        }
    }

    @Override
    protected void mouseDragStart(double mouseX, double mouseY) {
        if (!this.canDraw()) {
            return;
        }
        if (this.currentDrawArea != null && !((DrawArea)this.currentDrawArea).contains(mouseX, mouseY)) {
            this.clearDrawing();
        }
        if (this.currentDrawArea == null) {
            this.currentDrawArea = (DrawArea)Iterables.getFirst(this.getContainingDrawAreas(mouseX, mouseY), null);
        }
        if (this.currentDrawArea == null) {
            this.clearDrawing();
            return;
        }
        this.dragStart = new Point((int)mouseX, (int)mouseY);
        this.dragEnd = new Point((int)mouseX, (int)mouseY);
    }

    @Override
    protected void mouseDragTick(double mouseX, double mouseY, double mouseDiffX, double mouseDiffY, double mouseOffsetX, double mouseOffsetY) {
        if (!this.canDraw() || this.dragStart == null || this.currentDrawArea == null) {
            return;
        }
        if (!((DrawArea)this.currentDrawArea).contains(mouseX, mouseY)) {
            this.clearDrawing();
            return;
        }
        this.dragEnd = new Point((int)mouseX, (int)mouseY);
    }

    @Override
    protected void mouseDragStop(double mouseX, double mouseY, double mouseDiffX, double mouseDiffY) {
        if (!this.canDraw() || this.dragStart == null || this.currentDrawArea == null) {
            return;
        }
        if (!((DrawArea)this.currentDrawArea).contains(mouseX, mouseY)) {
            this.clearDrawing();
            return;
        }
        this.dragEnd = new Point((int)mouseX, (int)mouseY);
        this.finishDrawingLine();
        this.stopCurrentDrawing();
        this.checkConstellationMatch();
    }

    protected void finishDrawingLine() {
        if (Math.abs(this.dragStart.getX() - this.dragEnd.getX()) <= 2.0 && Math.abs(this.dragStart.getY() - this.dragEnd.getY()) <= 2.0) {
            return;
        }
        Point adjStart = new Point(this.dragStart.x - this.guiLeft, this.dragStart.y - this.guiTop);
        Point adjEnd = new Point(this.dragEnd.x - this.guiLeft, this.dragEnd.y - this.guiTop);
        DrawnLine l = new DrawnLine(adjStart, adjEnd);
        this.drawnLines.add(l);
    }

    protected boolean canDraw() {
        return !Minecraft.func_71410_x().field_71417_B.func_198035_h() && DayTimeHelper.isNight((World)Minecraft.func_71410_x().field_71441_e) && Minecraft.func_71410_x().field_71441_e.func_72867_j(1.0f) <= 0.1f;
    }

    protected void clearDrawing() {
        this.currentDrawArea = null;
        this.drawnLines.clear();
        this.stopCurrentDrawing();
    }

    private void stopCurrentDrawing() {
        this.dragStart = null;
        this.dragEnd = null;
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void checkConstellationMatch() {
        if (this.currentDrawArea == null || ((DrawArea)this.currentDrawArea).cstDisplay.isEmpty()) {
            return;
        }
        PlayerProgress progress = ResearchHelper.getClientProgress();
        for (IConstellation cst : ((DrawArea)this.currentDrawArea).cstDisplay.keySet()) {
            ConstellationDisplayInformation info = ((DrawArea)this.currentDrawArea).cstDisplay.get(cst);
            if (progress.hasConstellationDiscovered(cst) || !progress.hasSeenConstellation(cst) || cst.getStarConnections().size() != this.drawnLines.size() || !cst.canDiscover((PlayerEntity)Minecraft.func_71410_x().field_71439_g, progress)) continue;
            boolean didMatch = true;
            for (StarConnection cstConnection : cst.getStarConnections()) {
                Rectangle rctFrom = (Rectangle)info.frameDrawInformation.get(cstConnection.from);
                Rectangle rctTo = (Rectangle)info.frameDrawInformation.get(cstConnection.to);
                if (rctFrom == null || rctTo == null) {
                    didMatch = false;
                    break;
                }
                if (this.hasMatchingDrawnLine(rctFrom, rctTo)) continue;
                didMatch = false;
                break;
            }
            if (!didMatch) continue;
            PacketChannel.CHANNEL.sendToServer(new PktDiscoverConstellation(cst));
            this.clearDrawing();
            return;
        }
    }

    private boolean hasMatchingDrawnLine(Rectangle rctFrom, Rectangle rctTo) {
        for (DrawnLine line : this.drawnLines) {
            Point start = line.from;
            Point end = line.to;
            start = new Point(start.x + this.guiLeft, start.y + this.guiTop);
            end = new Point(end.x + this.guiLeft, end.y + this.guiTop);
            if ((!rctFrom.contains(start) || !rctTo.contains(end)) && (!rctTo.contains(start) || !rctFrom.contains(end))) continue;
            return true;
        }
        return false;
    }

    protected boolean canObserverSeeSky(BlockPos pos, int xzWidth) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return false;
        }
        for (int xx = -xzWidth; xx <= xzWidth; ++xx) {
            for (int zz = -xzWidth; zz <= xzWidth; ++zz) {
                BlockPos other = pos.func_177982_a(xx, 0, zz);
                if (xx == 0 && zz == 0 || MiscUtils.canSeeSky((World)world, other, true, false)) continue;
                return false;
            }
        }
        return MiscUtils.canSeeSky((World)world, pos.func_177984_a(), true, false);
    }

    private static class DrawnLine {
        private final Point from;
        private final Point to;

        private DrawnLine(Point from, Point to) {
            this.from = from;
            this.to = to;
        }

        public Point getFrom() {
            return this.from;
        }

        public Point getTo() {
            return this.to;
        }
    }

    public static class ConstellationDisplayInformation {
        private final Point renderPosition;
        private final float renderSize;
        private final Map<StarLocation, Rectangle> frameDrawInformation = new HashMap<StarLocation, Rectangle>();

        protected ConstellationDisplayInformation(Point renderPosition, float renderSize) {
            this.renderPosition = renderPosition;
            this.renderSize = renderSize;
        }

        public Point getRenderPosition() {
            return this.renderPosition;
        }

        public float getRenderSize() {
            return this.renderSize;
        }

        public Map<StarLocation, Rectangle> getFrameDrawInformation() {
            return this.frameDrawInformation;
        }
    }

    public static class DrawArea {
        protected final Rectangle area;
        protected final Map<IConstellation, ConstellationDisplayInformation> cstDisplay = new HashMap<IConstellation, ConstellationDisplayInformation>();

        public DrawArea(Rectangle area) {
            this.area = area;
        }

        public void addConstellationToArea(IConstellation cst, Point drawPoint, float size) {
            this.addConstellationToArea(cst, new ConstellationDisplayInformation(drawPoint, size));
        }

        public void addConstellationToArea(IConstellation cst, ConstellationDisplayInformation info) {
            this.cstDisplay.put(cst, info);
        }

        public Map<IConstellation, ConstellationDisplayInformation> getDisplayMap() {
            return Collections.unmodifiableMap(this.cstDisplay);
        }

        public boolean contains(double mouseX, double mouseY) {
            return this.isVisible() && this.area.contains(mouseX, mouseY);
        }

        public boolean isVisible() {
            return true;
        }
    }
}

