/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.base;

import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.client.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.screen.base.InputScreen;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.text.ITextComponent;

public class WidthHeightScreen
extends InputScreen {
    protected final int guiHeight;
    protected final int guiWidth;
    protected int guiLeft;
    protected int guiTop;
    protected boolean closeWithInventoryKey = true;

    protected WidthHeightScreen(ITextComponent titleIn, int guiHeight, int guiWidth) {
        super(titleIn);
        this.guiHeight = guiHeight;
        this.guiWidth = guiWidth;
    }

    protected void init() {
        super.init();
        this.initComponents();
    }

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getGuiTop() {
        return this.guiTop;
    }

    public int getGuiZLevel() {
        return this.getBlitOffset();
    }

    public int getGuiWidth() {
        return this.guiWidth;
    }

    public int getGuiHeight() {
        return this.guiHeight;
    }

    public Rectangle getGuiBox() {
        return new Rectangle(this.getGuiLeft(), this.getGuiTop(), this.getGuiWidth(), this.getGuiHeight());
    }

    private void initComponents() {
        this.guiLeft = this.width / 2 - this.guiWidth / 2;
        this.guiTop = this.height / 2 - this.guiHeight / 2;
    }

    protected void drawWHRect(AbstractRenderableTexture resource) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        resource.bindTexture();
        RenderingGuiUtils.drawRect(this.guiLeft, this.guiTop, this.getBlitOffset(), this.guiWidth, this.guiHeight);
        RenderSystem.disableAlphaTest();
    }

    public boolean charTyped(char charCode, int keyModifiers) {
        if (super.charTyped(charCode, keyModifiers)) {
            return true;
        }
        if (this.closeWithInventoryKey && Minecraft.func_71410_x().field_71474_y.field_151445_Q.func_151470_d()) {
            this.onClose();
            if (Minecraft.func_71410_x().field_71462_r == null) {
                Minecraft.func_71410_x().field_71417_B.func_198034_i();
            }
        }
        return false;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 1 && this.shouldRightClickCloseScreen(mouseX, mouseY)) {
            this.onClose();
            if (Minecraft.func_71410_x().field_71462_r == null) {
                Minecraft.func_71410_x().field_71417_B.func_198034_i();
            }
            return true;
        }
        return false;
    }

    protected boolean shouldRightClickCloseScreen(double mouseX, double mouseY) {
        return false;
    }

    protected RenderingGuiUtils.DrawBuilder drawRect(BufferBuilder buf) {
        return RenderingGuiUtils.rect(buf, this);
    }
}

