/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.journal;

import com.mojang.blaze3d.systems.RenderSystem;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.lib.TexturesAS;
import hellfirepvp.astralsorcery.client.screen.base.NavigationArrowScreen;
import hellfirepvp.astralsorcery.client.screen.journal.ScreenJournal;
import hellfirepvp.astralsorcery.client.screen.journal.page.RenderPageAltarRecipe;
import hellfirepvp.astralsorcery.client.screen.journal.page.RenderablePage;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingConstellationUtils;
import hellfirepvp.astralsorcery.client.util.RenderingDrawUtils;
import hellfirepvp.astralsorcery.client.util.RenderingGuiUtils;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.base.MoonPhase;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.SkyHandler;
import hellfirepvp.astralsorcery.common.constellation.world.WorldContext;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.item.ItemConstellationPaper;
import hellfirepvp.astralsorcery.common.item.armor.ItemMantle;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.lib.SoundsAS;
import hellfirepvp.astralsorcery.common.util.RecipeHelper;
import hellfirepvp.astralsorcery.common.util.sound.SoundHelper;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;

public class ScreenJournalConstellationDetail
extends ScreenJournal
implements NavigationArrowScreen {
    private final ScreenJournal origin;
    private final IConstellation constellation;
    private final boolean detailed;
    private int doublePageID = 0;
    private int doublePages = 0;
    private List<MoonPhase> activePhases = null;
    private RenderablePage lastFramePage = null;
    private Rectangle rectBack;
    private Rectangle rectNext;
    private Rectangle rectPrev;
    private final List<String> locTextMain = new LinkedList<String>();
    private final List<String> locTextRitual = new LinkedList<String>();
    private final List<String> locTextRefraction = new LinkedList<String>();
    private final List<String> locTextMantle = new LinkedList<String>();

    public ScreenJournalConstellationDetail(ScreenJournal origin, IConstellation cst) {
        super(cst.getConstellationName(), -1);
        this.origin = origin;
        this.constellation = cst;
        this.font = Minecraft.func_71410_x().field_71466_p;
        this.detailed = ResearchHelper.getClientProgress().hasConstellationDiscovered(cst);
        PlayerProgress playerProgress = ResearchHelper.getClientProgress();
        if (this.detailed) {
            if (playerProgress.getTierReached().isThisLaterOrEqual(ProgressionTier.ATTUNEMENT)) {
                ++this.doublePages;
            }
            if (playerProgress.getTierReached().isThisLaterOrEqual(ProgressionTier.TRAIT_CRAFT)) {
                if (!(this.constellation instanceof IMinorConstellation)) {
                    ++this.doublePages;
                }
                ++this.doublePages;
            }
        }
        this.testActivePhases();
        this.buildMainText();
        this.buildEnchText();
        this.buildRitualText();
        this.buildCapeText();
    }

    public IConstellation getConstellation() {
        return this.constellation;
    }

    private void buildCapeText() {
        if (this.constellation instanceof IWeakConstellation && ResearchHelper.getClientProgress().getTierReached().isThisLaterOrEqual(ProgressionTier.TRAIT_CRAFT)) {
            String textMantle = ((IWeakConstellation)this.constellation).getInfoMantleEffect().func_150254_d();
            String head = I18n.func_135052_a((String)"astralsorcery.journal.constellation.mantle", (Object[])new Object[0]);
            this.locTextMantle.add(head);
            this.locTextMantle.add("");
            LinkedList<String> lines = new LinkedList<String>();
            for (String segment : textMantle.split("<NL>")) {
                lines.addAll(this.font.func_78271_c(segment, 175));
                lines.add("");
            }
            this.locTextMantle.addAll(lines);
            this.locTextMantle.add("");
        }
    }

    private void buildEnchText() {
        if (ResearchHelper.getClientProgress().getTierReached().isThisLaterOrEqual(ProgressionTier.CONSTELLATION_CRAFT)) {
            String textEnchantments = this.constellation.getConstellationEnchantmentDescription().func_150254_d();
            String head = I18n.func_135052_a((String)"astralsorcery.journal.constellation.enchantments", (Object[])new Object[0]);
            this.locTextRefraction.add(head);
            this.locTextRefraction.add("");
            LinkedList<String> lines = new LinkedList<String>();
            for (String segment : textEnchantments.split("<NL>")) {
                lines.addAll(this.font.func_78271_c(segment, 175));
                lines.add("");
            }
            this.locTextRefraction.addAll(lines);
            this.locTextRefraction.add("");
        }
    }

    private void buildRitualText() {
        if (this.constellation instanceof IMinorConstellation) {
            if (ResearchHelper.getClientProgress().getTierReached().isThisLaterOrEqual(ProgressionTier.TRAIT_CRAFT)) {
                String textRitual = ((IMinorConstellation)this.constellation).getInfoTraitEffect().func_150254_d();
                String head = I18n.func_135052_a((String)"astralsorcery.journal.constellation.ritual.trait", (Object[])new Object[0]);
                this.locTextRitual.add(head);
                this.locTextRitual.add("");
                LinkedList<String> lines = new LinkedList<String>();
                for (String segment : textRitual.split("<NL>")) {
                    lines.addAll(this.font.func_78271_c(segment, 175));
                    lines.add("");
                }
                this.locTextRitual.addAll(lines);
            }
        } else if (this.constellation instanceof IWeakConstellation) {
            LinkedList<String> lines;
            String head;
            if (ResearchHelper.getClientProgress().getTierReached().isThisLaterOrEqual(ProgressionTier.ATTUNEMENT)) {
                String textRitual = ((IWeakConstellation)this.constellation).getInfoRitualEffect().func_150254_d();
                head = I18n.func_135052_a((String)"astralsorcery.journal.constellation.ritual", (Object[])new Object[0]);
                this.locTextRitual.add(head);
                this.locTextRitual.add("");
                lines = new LinkedList<String>();
                for (String segment : textRitual.split("<NL>")) {
                    lines.addAll(this.font.func_78271_c(segment, 175));
                    lines.add("");
                }
                this.locTextRitual.addAll(lines);
                this.locTextRitual.add("");
            }
            if (ResearchHelper.getClientProgress().getTierReached().isThisLaterOrEqual(ProgressionTier.TRAIT_CRAFT)) {
                String textCorruptedRitual = ((IWeakConstellation)this.constellation).getInfoCorruptedRitualEffect().func_150254_d();
                head = I18n.func_135052_a((String)"astralsorcery.journal.constellation.corruption", (Object[])new Object[0]);
                this.locTextRitual.add(head);
                this.locTextRitual.add("");
                lines = new LinkedList();
                for (String segment : textCorruptedRitual.split("<NL>")) {
                    lines.addAll(this.font.func_78271_c(segment, 175));
                    lines.add("");
                }
                this.locTextRitual.addAll(lines);
                this.locTextRitual.add("");
            }
        }
    }

    private void buildMainText() {
        String description = this.constellation.getConstellationDescription().func_150254_d();
        LinkedList<String> lines = new LinkedList<String>();
        for (String segment : description.split("<NL>")) {
            lines.addAll(this.font.func_78271_c(segment, 175));
            lines.add("");
        }
        this.locTextMain.addAll(lines);
    }

    private void testActivePhases() {
        WorldContext ctx = SkyHandler.getContext((World)Minecraft.func_71410_x().field_71441_e, LogicalSide.CLIENT);
        if (ctx == null) {
            return;
        }
        this.activePhases = new LinkedList<MoonPhase>();
        for (MoonPhase phase : MoonPhase.values()) {
            if (!ctx.getConstellationHandler().isActiveInPhase(this.constellation, phase)) continue;
            this.activePhases.add(phase);
        }
    }

    public void render(int mouseX, int mouseY, float pTicks) {
        this.lastFramePage = null;
        if (this.doublePageID == 0) {
            this.drawCstBackground();
            this.drawDefault(TexturesAS.TEX_GUI_BOOK_FRAME_LEFT, mouseX, mouseY);
        } else {
            this.drawDefault(TexturesAS.TEX_GUI_BOOK_BLANK, mouseX, mouseY);
        }
        this.drawNavArrows(pTicks, mouseX, mouseY);
        this.setBlitOffset(120);
        switch (this.doublePageID) {
            case 0: {
                this.drawPageConstellation(pTicks);
                this.drawPagePhaseInformation();
                this.drawPageExtendedInformation();
                break;
            }
            case 1: {
                this.drawRitualRefractionTableInformation(mouseX, mouseY, pTicks);
                break;
            }
            case 2: {
                this.drawCapeInformationPages(mouseX, mouseY, pTicks);
                break;
            }
            case 3: {
                this.drawConstellationPaperRecipePage(mouseX, mouseY, pTicks);
                break;
            }
        }
        this.setBlitOffset(0);
    }

    private void drawConstellationPaperRecipePage(int mouseX, int mouseY, float pTicks) {
        SimpleAltarRecipe recipe;
        if (ResearchHelper.getClientProgress().getTierReached().isThisLaterOrEqual(ProgressionTier.TRAIT_CRAFT) && (recipe = RecipeHelper.findAltarRecipeResult(stack -> stack.func_77973_b() instanceof ItemConstellationPaper && this.constellation.equals(ItemsAS.CONSTELLATION_PAPER.getConstellation((ItemStack)stack)))) != null) {
            this.lastFramePage = new RenderPageAltarRecipe(null, -1, recipe);
            this.lastFramePage.render(this.guiLeft + 30, this.guiTop + 20, pTicks, this.getGuiZLevel(), mouseX, mouseY);
            this.lastFramePage.postRender(this.guiLeft + 30, this.guiTop + 20, pTicks, this.getGuiZLevel(), mouseX, mouseY);
        }
    }

    private void drawCapeInformationPages(int mouseX, int mouseY, float partialTicks) {
        SimpleAltarRecipe recipe;
        for (int i = 0; i < this.locTextMantle.size(); ++i) {
            String line = this.locTextMantle.get(i);
            RenderingDrawUtils.renderStringAtPos(this.guiLeft + 30, this.guiTop + 30 + i * 10, this.getGuiZLevel(), this.font, line, -3355444, true);
        }
        if (ResearchHelper.getClientProgress().getTierReached().isThisLaterOrEqual(ProgressionTier.TRAIT_CRAFT) && (recipe = RecipeHelper.findAltarRecipeResult(stack -> stack.func_77973_b() instanceof ItemMantle && this.constellation.equals(ItemsAS.MANTLE.getConstellation((ItemStack)stack)))) != null) {
            this.lastFramePage = new RenderPageAltarRecipe(null, -1, recipe);
            this.lastFramePage.render(this.guiLeft + 220, this.guiTop + 20, partialTicks, this.getGuiZLevel(), mouseX, mouseY);
            this.lastFramePage.postRender(this.guiLeft + 220, this.guiTop + 20, partialTicks, this.getGuiZLevel(), mouseX, mouseY);
        }
    }

    private void drawRitualRefractionTableInformation(int mouseX, int mouseY, float partialTicks) {
        String line;
        int i;
        for (i = 0; i < this.locTextRitual.size(); ++i) {
            line = this.locTextRitual.get(i);
            RenderingDrawUtils.renderStringAtPos(this.guiLeft + 30, this.guiTop + 30 + i * 10, this.getGuiZLevel(), this.font, line, -3355444, true);
        }
        for (i = 0; i < this.locTextRefraction.size(); ++i) {
            line = this.locTextRefraction.get(i);
            RenderingDrawUtils.renderStringAtPos(this.guiLeft + 220, this.guiTop + 30 + i * 10, this.getGuiZLevel(), this.font, line, -3355444, true);
        }
    }

    private void drawPageExtendedInformation() {
        String info = this.constellation.getConstellationTag().func_150254_d().toUpperCase();
        info = this.detailed ? info : "? ? ?";
        int width = this.font.func_78256_a(info);
        int chX = 305 - width / 2;
        RenderingDrawUtils.renderStringAtPos(this.guiLeft + chX, this.guiTop + 44, this.getGuiZLevel(), this.font, info, -3355444, true);
        if (this.detailed && !this.locTextMain.isEmpty()) {
            int offsetX = 220;
            int offsetY = 77;
            for (String s : this.locTextMain) {
                RenderingDrawUtils.renderStringAtPos(this.guiLeft + offsetX, this.guiTop + offsetY, this.getGuiZLevel(), this.font, s, -3355444, true);
                offsetY += 13;
            }
        }
    }

    private void drawPagePhaseInformation() {
        List<MoonPhase> phases;
        if (this.activePhases == null) {
            this.testActivePhases();
            if (this.activePhases == null) {
                return;
            }
        }
        if ((phases = this.activePhases).isEmpty()) {
            String none = "? ? ?";
            double scale = 1.8;
            double length = (double)this.font.func_78256_a(none) * scale;
            double offsetLeft = (double)(this.guiLeft + 296) - length / 2.0;
            int offsetTop = this.guiTop + 199;
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)(offsetLeft + 10.0), (double)offsetTop, (double)0.0);
            RenderSystem.scaled((double)scale, (double)scale, (double)scale);
            RenderingDrawUtils.renderStringWithShadowAtCurrentPos(this.font, none, -857874979);
            RenderSystem.popMatrix();
        } else {
            boolean known = ResearchHelper.getClientProgress().hasConstellationDiscovered(this.constellation);
            int size = 19;
            int offsetX = 95 + this.width / 2 - MoonPhase.values().length * (size + 2) / 2;
            int offsetY = 199 + this.guiTop;
            RenderSystem.enableBlend();
            Blending.DEFAULT.apply();
            MoonPhase[] mPhases = MoonPhase.values();
            for (int i = 0; i < mPhases.length; ++i) {
                float brightness;
                MoonPhase phase = mPhases[i];
                int index = i;
                phase.getTexture().bindTexture();
                if (known && this.activePhases.contains((Object)phase)) {
                    Blending.PREALPHA.apply();
                    brightness = 1.0f;
                } else {
                    Blending.DEFAULT.apply();
                    brightness = 0.7f;
                }
                RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> RenderingGuiUtils.rect(buf, offsetX + index * (size + 2), offsetY, this.getGuiZLevel(), size, size).color(brightness, brightness, brightness, brightness).draw());
            }
            Blending.DEFAULT.apply();
            RenderSystem.disableBlend();
        }
    }

    private void drawPageConstellation(float partial) {
        String name = this.constellation.getConstellationName().func_150254_d().toUpperCase();
        int width = this.font.func_78256_a(name);
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)((float)this.guiLeft + (305.0f - (float)width * 1.8f / 2.0f)), (double)(this.guiTop + 26), (double)this.getGuiZLevel());
        RenderSystem.scaled((double)1.8, (double)1.8, (double)1.0);
        RenderingDrawUtils.renderStringWithShadowAtCurrentPos(this.font, name, -3947581);
        RenderSystem.popMatrix();
        String dstInfo = this.constellation.getConstellationTypeDescription().func_150254_d();
        if (!this.detailed) {
            dstInfo = "???";
        }
        dstInfo = I18n.func_135052_a((String)dstInfo, (Object[])new Object[0]);
        width = this.font.func_78256_a(dstInfo);
        RenderingDrawUtils.renderStringAtPos(this.guiLeft + (305 - width / 2), this.guiTop + 219, this.getGuiZLevel(), this.font, dstInfo, -2236963, true);
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        Random rand = new Random(4726142277924544921L);
        boolean known = ResearchHelper.getClientProgress().hasConstellationDiscovered(this.constellation);
        RenderingConstellationUtils.renderConstellationIntoGUI(known ? this.constellation.getConstellationColor() : this.constellation.getTierRenderColor(), this.constellation, this.guiLeft + 40, this.guiTop + 60, this.getGuiZLevel(), 150.0f, 150.0f, 2.0, () -> Float.valueOf(0.6f + 0.4f * RenderingConstellationUtils.conCFlicker(ClientScheduler.getClientTick(), partial, 12 + rand.nextInt(10))), true, false);
        RenderSystem.disableBlend();
    }

    private void drawNavArrows(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.enableBlend();
        Blending.DEFAULT.apply();
        this.rectNext = null;
        this.rectPrev = null;
        this.rectBack = this.drawArrow(this.guiLeft + 197, this.guiTop + 230, this.getGuiZLevel(), NavigationArrowScreen.Type.LEFT, mouseX, mouseY, partialTicks);
        if (this.doublePageID - 1 >= 0) {
            this.rectPrev = this.drawArrow(this.guiLeft + 25, this.guiTop + 220, this.getGuiZLevel(), NavigationArrowScreen.Type.LEFT, mouseX, mouseY, partialTicks);
        }
        if (this.doublePageID + 1 <= this.doublePages) {
            this.rectNext = this.drawArrow(this.guiLeft + 367, this.guiTop + 220, this.getGuiZLevel(), NavigationArrowScreen.Type.RIGHT, mouseX, mouseY, partialTicks);
        }
        RenderSystem.disableBlend();
    }

    private void drawCstBackground() {
        TexturesAS.TEX_BLACK.bindTexture();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
            buf.func_225582_a_((double)(this.guiLeft + 15), (double)(this.guiTop + 240), (double)this.getGuiZLevel()).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
            buf.func_225582_a_((double)(this.guiLeft + 200), (double)(this.guiTop + 240), (double)this.getGuiZLevel()).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
            buf.func_225582_a_((double)(this.guiLeft + 200), (double)(this.guiTop + 10), (double)this.getGuiZLevel()).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
            buf.func_225582_a_((double)(this.guiLeft + 15), (double)(this.guiTop + 10), (double)this.getGuiZLevel()).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        });
        RenderSystem.enableBlend();
        TexturesAS.TEX_GUI_BACKGROUND_CONSTELLATIONS.bindTexture();
        RenderingUtils.draw(7, DefaultVertexFormats.field_227851_o_, buf -> {
            buf.func_225582_a_((double)(this.guiLeft + 15), (double)(this.guiTop + 240), (double)this.getGuiZLevel()).func_227885_a_(0.8f, 0.8f, 1.0f, 0.7f).func_225583_a_(0.3f, 0.9f).func_181675_d();
            buf.func_225582_a_((double)(this.guiLeft + 200), (double)(this.guiTop + 240), (double)this.getGuiZLevel()).func_227885_a_(0.8f, 0.8f, 1.0f, 0.7f).func_225583_a_(0.7f, 0.9f).func_181675_d();
            buf.func_225582_a_((double)(this.guiLeft + 200), (double)(this.guiTop + 10), (double)this.getGuiZLevel()).func_227885_a_(0.8f, 0.8f, 1.0f, 0.7f).func_225583_a_(0.7f, 0.1f).func_181675_d();
            buf.func_225582_a_((double)(this.guiLeft + 15), (double)(this.guiTop + 10), (double)this.getGuiZLevel()).func_227885_a_(0.8f, 0.8f, 1.0f, 0.7f).func_225583_a_(0.3f, 0.1f).func_181675_d();
        });
        RenderSystem.disableBlend();
    }

    @Override
    protected boolean shouldRightClickCloseScreen(double mouseX, double mouseY) {
        return true;
    }

    public void onClose() {
        Minecraft.func_71410_x().func_147108_a((Screen)this.origin);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (super.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton != 0) {
            return false;
        }
        if (this.handleBookmarkClick(mouseX, mouseY)) {
            return true;
        }
        if (this.rectBack != null && this.rectBack.contains(mouseX, mouseY)) {
            Minecraft.func_71410_x().func_147108_a((Screen)this.origin);
            return true;
        }
        if (this.rectPrev != null && this.rectPrev.contains(mouseX, mouseY)) {
            if (this.doublePageID >= 1) {
                --this.doublePageID;
            }
            SoundHelper.playSoundClient(SoundsAS.GUI_JOURNAL_PAGE, 1.0f, 1.0f);
            return true;
        }
        if (this.rectNext != null && this.rectNext.contains(mouseX, mouseY)) {
            if (this.doublePageID <= this.doublePages - 1) {
                ++this.doublePageID;
            }
            SoundHelper.playSoundClient(SoundsAS.GUI_JOURNAL_PAGE, 1.0f, 1.0f);
            return true;
        }
        return this.doublePageID != 0 && this.lastFramePage != null && this.lastFramePage.propagateMouseClick(mouseX, mouseY);
    }
}

